/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.controls;

import com.paterva.maltego.util.ui.components.LabelWithBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.calendar.SingleDaySelectionModel;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;

public class DateTimePicker
extends JXDatePicker {
    private JSpinner _timeSpinner;
    private JPanel _timePanel;
    private String _timeFormat;
    private boolean _updatingSpinner = false;
    private boolean _updatingText = false;

    public DateTimePicker() {
        JXMonthView mv = this.getMonthView();
        mv.setSelectionModel((DateSelectionModel)new SingleDaySelectionModel(){

            protected void setSelection(Date date) {
                date = DateTimePicker.this.appendTime(date);
                super.setSelection(date);
            }
        });
        mv.setFirstDayOfWeek(2);
        Color weekendColor = UIManager.getLookAndFeelDefaults().getColor("JXMonthViewMod.weekendForeground");
        mv.setDayForeground(7, weekendColor);
        mv.setDayForeground(1, weekendColor);
        this.getEditor().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                if (!DateTimePicker.this._updatingSpinner) {
                    DateTimePicker.this._updatingText = true;
                    String text = DateTimePicker.this.getEditor().getText();
                    try {
                        Date date = DateTimePicker.this.getFormats()[0].parse(text);
                        DateTimePicker.this.setTimeSpinners(date);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    DateTimePicker.this._updatingText = false;
                }
            }
        });
        this.setLinkPanel(this.getLinkPanel());
    }

    public DateTimePicker(Date d) {
        this();
        this.setDate(d);
    }

    public void commitEdit() throws ParseException {
        super.commitEdit();
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setTimeSpinners(this.getDate());
    }

    public void setLinkDay(Date linkDay) {
        super.setLinkDay(linkDay);
    }

    public void setLinkPanel(JPanel linkPanel) {
        super.setLinkPanel(linkPanel);
    }

    public JPanel getLinkPanel() {
        JPanel linkPanel = super.getLinkPanel();
        if (linkPanel instanceof JXPanel) {
            JXPanel jxLinkPanel = (JXPanel)linkPanel;
            Component[] bg = UIManager.getLookAndFeelDefaults().getColor("Panel.background");
            jxLinkPanel.setBackgroundPainter((Painter)new MattePainter((Paint)bg));
        }
        if (this._timePanel == null) {
            this._timePanel = this.createTimePanel();
        }
        this.setTimeSpinners(this.getDate());
        boolean isAlReadyAdded = false;
        for (Component comp : linkPanel.getComponents()) {
            if (!comp.equals(this._timePanel)) continue;
            isAlReadyAdded = true;
        }
        if (!isAlReadyAdded) {
            JXHyperlink linkPanelInside = (JXHyperlink)linkPanel.getComponent(0);
            linkPanel.removeAll();
            linkPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(6, 0, 6, 0), 0, 0);
            linkPanel.add((Component)linkPanelInside, gbc);
            gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
            linkPanel.add((Component)this._timePanel, gbc);
        }
        return linkPanel;
    }

    private JPanel createTimePanel() {
        JPanel newPanel = new JPanel();
        newPanel.setLayout(new GridBagLayout());
        SpinnerDateModel dateModel = new SpinnerDateModel();
        this._timeSpinner = new JSpinner(dateModel);
        if (this._timeFormat == null) {
            this._timeFormat = "HH:mm:ss.S";
        }
        this.updateTextFieldFormat();
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(1, 1, 1, 0), 5, 0);
        newPanel.add((Component)new LabelWithBackground("Time:"), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(1, 0, 1, 1), 10, 0);
        newPanel.add((Component)this._timeSpinner, gbc);
        this._timeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!DateTimePicker.this._updatingText) {
                    DateTimePicker.this._updatingSpinner = true;
                    DateTimePicker.this.commitTime();
                    DateTimePicker.this._updatingSpinner = false;
                }
            }
        });
        return newPanel;
    }

    private void updateTextFieldFormat() {
        if (this._timeSpinner == null) {
            return;
        }
        JSpinner.DateEditor de = new JSpinner.DateEditor(this._timeSpinner, this._timeFormat);
        this._timeSpinner.setEditor(de);
    }

    private void commitTime() {
        Date oldDate = this.getDate();
        if (oldDate != null) {
            Date newDate = this.appendTime(oldDate);
            this.setDate(newDate);
            this.firePropertyChange("date", oldDate, newDate);
        }
    }

    private Date appendTime(Date date) {
        if (date != null) {
            Date time = (Date)this._timeSpinner.getValue();
            GregorianCalendar timeCalendar = new GregorianCalendar();
            timeCalendar.setTime(time);
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            calendar.set(11, timeCalendar.get(11));
            calendar.set(12, timeCalendar.get(12));
            calendar.set(13, timeCalendar.get(13));
            calendar.set(14, timeCalendar.get(14));
            date = calendar.getTime();
        }
        return date;
    }

    private void setTimeSpinners(Date date) {
        if (date != null) {
            this._timeSpinner.setValue(date);
        }
    }

    public String getTimeFormat() {
        return this._timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this._timeFormat = timeFormat;
        this.updateTextFieldFormat();
    }
}

