/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.controls;

import com.bulenkov.darcula.ui.DarculaModFormattedTextFieldUI;
import com.paterva.maltego.typing.editing.controls.DateRangePickerFixedPopupContent;
import com.paterva.maltego.typing.editing.controls.DateRangePickerPresetsPopupContent;
import com.paterva.maltego.typing.editing.controls.DateTimePicker;
import com.paterva.maltego.typing.types.DateRange;
import com.paterva.maltego.util.ui.VFlowLayout;
import com.paterva.maltego.util.ui.components.ArrowIcon;
import com.paterva.maltego.util.ui.components.LabelWithBackground;
import com.paterva.maltego.util.ui.components.RadioButtonHeaderControl;
import com.paterva.maltego.util.ui.ctxmenu.WindowPopupManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.TextUI;
import org.jdesktop.swingx.event.EventListenerMap;

public class DateRangePicker
extends JPanel {
    public static final String DATE_CHANGED_COMMAND = "DateRangeChanged";
    private JPanel _popupPanel = null;
    private DateRangePickerFixedPopupContent _popupPanelFixedInnerControl = null;
    private DateRangePickerPresetsPopupContent _popupPanelPresetsInnerControl = null;
    private final List<HeaderControlActionCallbackImpl> _cpToggleCallbacks = new ArrayList<HeaderControlActionCallbackImpl>();
    private final int[] _popupContentHeight = new int[]{-1};
    private final JTextField _controlInterfaceEditor = new JTextField();
    private EventListenerMap _listenerMap;
    private int _selectedIndex = this.getRelativeIndex();

    public DateRangePicker() {
        this.initComponent();
    }

    public void setDateRange(DateRange dateRange) {
        DateRange newDateRange;
        DateRange dateRange2 = newDateRange = dateRange != null ? DateRange.createCopy((DateRange)dateRange) : null;
        if (dateRange != null) {
            this._selectedIndex = dateRange.isRelative() ? this.getRelativeIndex() : 0;
        }
        this.getPopupPanelFixedInnerControl().setDateRange(newDateRange);
        this.getPopupPanelPresetsInnerControl().setDateRange(newDateRange);
    }

    public DateRange getDateRange() {
        DateRange fixedDateRange = this.getPopupPanelFixedInnerControl().getDateRange();
        DateRange presetsDateRange = this.getPopupPanelPresetsInnerControl().getDateRange();
        boolean isRelative = this._selectedIndex == this.getRelativeIndex();
        DateRange newDateRange = fixedDateRange != null && presetsDateRange != null ? new DateRange(fixedDateRange.getFixedDateRange(), presetsDateRange.getRelativeItem(), isRelative) : null;
        return newDateRange;
    }

    public void setFormats(String format) {
        this.getPopupPanelFixedInnerControl().setFormats(format);
    }

    private void setEditorText(DateRange dateRange) {
        DateRange newDateRange;
        boolean isRelative = this._selectedIndex == this.getRelativeIndex();
        DateRange dateRange2 = newDateRange = dateRange != null ? new DateRange(dateRange.getFixedDateRange(), dateRange.getRelativeItem(), isRelative) : null;
        if (newDateRange != null) {
            this.getEditor().setText(newDateRange.toDisplayString());
            if (newDateRange.isValidRange()) {
                this.getEditor().setForeground(DateRangePickerFixedPopupContent.TEXT_FIELD_COLOR);
            } else {
                this.getEditor().setForeground(DateRangePickerFixedPopupContent.TEXT_FIELD_ERROR_COLOR);
            }
            this.fireActionPerformed(DATE_CHANGED_COMMAND);
        }
    }

    public int getRelativeIndex() {
        return 1;
    }

    private DateRangePickerFixedPopupContent getPopupPanelFixedInnerControl() {
        return this._popupPanelFixedInnerControl;
    }

    private DateRangePickerPresetsPopupContent getPopupPanelPresetsInnerControl() {
        return this._popupPanelPresetsInnerControl;
    }

    private void initComponent() {
        this._listenerMap = new EventListenerMap();
        this.setLayout(new GridBagLayout());
        this._controlInterfaceEditor.setEditable(false);
        this._controlInterfaceEditor.setUI((TextUI)new DarculaModFormattedTextFieldUI());
        MouseAdapterImpl mouseAdapterImpl = new MouseAdapterImpl();
        this._controlInterfaceEditor.addMouseListener(mouseAdapterImpl);
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 10, 0);
        this.add((Component)this._controlInterfaceEditor, gbc);
        JButton popupButton = this.createPopupButton();
        popupButton.addMouseListener(mouseAdapterImpl);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)popupButton, gbc);
        this.getPopupPanel();
    }

    public JTextField getEditor() {
        return this._controlInterfaceEditor;
    }

    public int[] getPopupPanelHeight() {
        return this._popupContentHeight;
    }

    public JPanel getPopupPanel() {
        if (this._popupPanel == null) {
            this._popupPanel = new JPanel((LayoutManager)new VFlowLayout(0, 3));
            UIDefaults laf = UIManager.getLookAndFeelDefaults();
            this._popupPanel.setBackground(laf.getColor("transform-manager-content-bg"));
            this._popupPanel.setBorder(new LineBorder(laf.getColor("darculaMod.borderColor")));
            this._popupPanelFixedInnerControl = new DateRangePickerFixedPopupContent();
            this._popupPanelPresetsInnerControl = new DateRangePickerPresetsPopupContent();
            this._popupPanelFixedInnerControl.setDateTimeRangePresetsChangeActionCallBack(new DateTimeRangePresetsChangeActionImpl());
            this._popupPanelPresetsInnerControl.setDateTimeRangePresetsChangeActionCallBack(new DateTimeRangePresetsChangeActionImpl());
            JPanel fixedDateRangePanel = this._popupPanelFixedInnerControl.getFixedDateRangePanel();
            this.insertSectionContentPanel(fixedDateRangePanel, fixedDateRangePanel.getToolTipText());
            JPanel presetsRelativeDateRangePanel = this._popupPanelPresetsInnerControl.getPresetsRelativeDateRangePanel();
            this.insertSectionContentPanel(presetsRelativeDateRangePanel, presetsRelativeDateRangePanel.getToolTipText());
            this._popupPanel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("popupContentShown".equals(evt.getPropertyName())) {
                        DateRangePicker.this._popupPanelFixedInnerControl.setIsUpdating(true);
                        DateRangePicker.this._popupPanelPresetsInnerControl.setIsUpdating(true);
                        DateRangePicker.this.selectPanels();
                        DateRangePicker.this._popupPanelFixedInnerControl.setIsUpdating(false);
                        DateRangePicker.this._popupPanelPresetsInnerControl.setIsUpdating(false);
                    }
                }
            });
            this.setEditorText(this.getDateRange());
        }
        return this._popupPanel;
    }

    private void insertSectionContentPanel(JPanel content, String headingText) {
        JPanel cp = new JPanel();
        cp.setEnabled(false);
        cp.setLayout(new BorderLayout());
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        Color cpBg = laf.getColor("transform-manager-lowlight-bg");
        HeaderControlActionCallbackImpl cpCallback = new HeaderControlActionCallbackImpl();
        cpCallback.setInnerComponents(DateRangePicker.getAllComponents(content));
        RadioButtonHeaderControl header = new RadioButtonHeaderControl((Border)new MatteBorder(0, 0, 1, 0, cpBg), (RadioButtonHeaderControl.ActionCallback)cpCallback);
        header.setTitle(headingText);
        cp.add((Component)content, "North");
        cp.setBackground(cpBg);
        EmptyBorder collapsiblePaneBorder = new EmptyBorder(0, 6, 6, 6);
        cp.setBorder(collapsiblePaneBorder);
        this._popupPanel.add((Component)header);
        this._popupPanel.add(cp);
        this._cpToggleCallbacks.add(cpCallback);
    }

    private static List<Component> getAllComponents(Container c) {
        Component[] comps = c.getComponents();
        ArrayList<Component> compList = new ArrayList<Component>();
        for (Component comp : comps) {
            if (comp instanceof JLabel || comp instanceof JComboBox || comp instanceof DateTimePicker || comp instanceof JFormattedTextField || comp instanceof JButton) {
                compList.add(comp);
            }
            if (!(comp instanceof Container)) continue;
            compList.addAll(DateRangePicker.getAllComponents((Container)comp));
        }
        return compList;
    }

    private JButton createPopupButton() {
        Color bg = new LabelWithBackground().getBackground();
        JButton popupButton = new JButton();
        popupButton.setName("popupButton");
        popupButton.setMargin(new Insets(0, 0, 0, 0));
        popupButton.setFocusable(false);
        ArrowIcon.setupPopupButton((JButton)popupButton, (Color)bg);
        return popupButton;
    }

    private void selectPanels() {
        int selectIndex = this._selectedIndex;
        if (!this._cpToggleCallbacks.isEmpty() && this._cpToggleCallbacks.size() > selectIndex) {
            this.setContentPanelSelected(this._cpToggleCallbacks.get(selectIndex));
        } else if (!this._cpToggleCallbacks.isEmpty()) {
            this.setContentPanelSelected(this._cpToggleCallbacks.get(0));
        }
    }

    private void setContentPanelSelected(HeaderControlActionCallbackImpl specificCallBack) {
        for (HeaderControlActionCallbackImpl cpCallback : this._cpToggleCallbacks) {
            if (!cpCallback.equals((Object)specificCallBack)) continue;
            cpCallback.perform(cpCallback, true, true);
        }
    }

    public void addActionListener(ActionListener l) {
        this._listenerMap.add(ActionListener.class, (EventListener)l);
    }

    public void removeActionListener(ActionListener l) {
        this._listenerMap.remove(ActionListener.class, (EventListener)l);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        EventListener[] result;
        List listeners = this._listenerMap.getListeners(listenerType);
        if (!listeners.isEmpty()) {
            result = (EventListener[])Array.newInstance(listenerType, listeners.size());
            result = listeners.toArray(result);
        } else {
            result = super.getListeners(listenerType);
        }
        return result;
    }

    protected void fireActionPerformed(String actionCommand) {
        ActionListener[] listeners = (ActionListener[])this.getListeners(ActionListener.class);
        ActionEvent e = null;
        for (ActionListener listener : listeners) {
            if (e == null) {
                e = new ActionEvent(this, 1001, actionCommand);
            }
            listener.actionPerformed(e);
        }
    }

    private class MouseAdapterImpl
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent evt) {
            WindowPopupManager.getInstance().show((Component)DateRangePicker.this._controlInterfaceEditor, DateRangePicker.this.getPopupPanel(), evt, DateRangePicker.this._popupContentHeight);
        }
    }

    private class DateTimeRangePresetsChangeActionImpl
    extends DateRangePickerFixedPopupContent.DateTimeRangePresetsChangeAction {
        private DateTimeRangePresetsChangeActionImpl() {
        }

        @Override
        public void perform(DateRange daterange) {
            DateRangePicker.this.setEditorText(daterange);
        }
    }

    private class HeaderControlActionCallbackImpl
    extends RadioButtonHeaderControl.ActionCallback {
        private HeaderControlActionCallbackImpl() {
        }

        public void perform(RadioButtonHeaderControl.ActionCallback cb, boolean isSelected, boolean changeSelectedStateOfOther) {
            if (changeSelectedStateOfOther) {
                for (HeaderControlActionCallbackImpl cpCallback : DateRangePicker.this._cpToggleCallbacks) {
                    List innerComponents = cpCallback.getInnerComponents();
                    if (cpCallback.equals(cb)) {
                        cpCallback.setSelected(cpCallback, isSelected, false);
                        for (Component comp : innerComponents) {
                            if (comp instanceof JFormattedTextField) {
                                ((JFormattedTextField)comp).putClientProperty("MustGreyOut", !isSelected);
                            }
                            comp.setEnabled(isSelected);
                        }
                        continue;
                    }
                    cpCallback.setSelected(cpCallback, !isSelected, false);
                    for (Component comp : innerComponents) {
                        if (comp instanceof JFormattedTextField) {
                            ((JFormattedTextField)comp).putClientProperty("MustGreyOut", isSelected);
                        }
                        comp.setEnabled(!isSelected);
                    }
                }
                int index = DateRangePicker.this._cpToggleCallbacks.indexOf(cb);
                if (index != -1 && isSelected) {
                    DateRangePicker.this._selectedIndex = index;
                    DateRangePicker.this.setEditorText(DateRangePicker.this.getDateRange());
                }
            }
        }
    }
}

