/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.PropertyBag;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.FileStore;
import com.paterva.maltego.util.FileUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;

public class AttachmentUtils {
    public static List<PropertyDescriptor> getPropertyDescriptors(PropertyBag propertyBag) {
        ArrayList<PropertyDescriptor> pds = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor pd : propertyBag.getProperties()) {
            if (!Attachments.class.equals((Object)pd.getType())) continue;
            pds.add(pd);
        }
        return pds;
    }

    public static List<Attachment> getAllAttachments(PropertyBag propertyBag) {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        List<PropertyDescriptor> pds = AttachmentUtils.getPropertyDescriptors(propertyBag);
        for (PropertyDescriptor pd : pds) {
            Attachments atts = (Attachments)propertyBag.getValue(pd);
            if (atts == null) continue;
            for (Attachment att : atts) {
                attachments.add(att);
            }
        }
        return attachments;
    }

    public static Attachment getEntityImageAttachment(MaltegoEntity entity) {
        Attachments atts;
        Attachment att = null;
        PropertyDescriptor imgProp = entity.getNonBlankImageExpression().map(imgExpr -> entity.getProperties().get(imgExpr)).orElse(null);
        if (imgProp != null && Attachments.class.equals((Object)imgProp.getType()) && (atts = (Attachments)entity.getValue(imgProp)) != null) {
            att = atts.getPrimaryImage();
        }
        return att;
    }

    public static void setAttachmentAsEntityImage(MaltegoEntity entity, Attachment attachment) {
        for (PropertyDescriptor pd : entity.getProperties()) {
            Attachments atts;
            if (!Attachments.class.equals((Object)pd.getType()) || (atts = (Attachments)entity.getValue(pd)) == null) continue;
            for (Attachment att : atts) {
                if (!att.equals((Object)attachment)) continue;
                atts = new Attachments(atts);
                atts.setPrimaryImage(att);
                entity.setValue(pd, (Object)atts);
                entity.setImageExpression(pd.getName());
                return;
            }
        }
    }

    public static int getAttachmentCount(PropertyBag propertyBag) {
        int count = 0;
        List<PropertyDescriptor> pds = AttachmentUtils.getPropertyDescriptors(propertyBag);
        for (PropertyDescriptor pd : pds) {
            Attachments atts = (Attachments)propertyBag.getValue(pd);
            if (atts == null) continue;
            count += atts.size();
        }
        return count;
    }

    public static int getAttachmentsSize(PropertyBag propertyBag) {
        int size = 0;
        List<Attachment> atts = AttachmentUtils.getAllAttachments(propertyBag);
        for (Attachment att : atts) {
            size = (int)((long)size + FileStore.getDefault().getSize(att.getId()));
        }
        return size;
    }

    public static List<Attachment> createAttachments(List<File> files, List<FastURL> sources) {
        ArrayList<Attachment> newAtts = new ArrayList<Attachment>(files.size());
        for (int i = 0; i < files.size(); ++i) {
            Attachment att = AttachmentUtils.createAttachment(files.get(i), sources.get(i));
            if (att == null) continue;
            newAtts.add(att);
        }
        return newAtts;
    }

    public static Attachment createAttachment(File file, FastURL source) {
        Attachment att = null;
        if (!file.isDirectory()) {
            try {
                int id = FileStore.getDefault().add(file);
                att = new Attachment(id, source);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return att;
    }

    public static void attach(final PropertyBag propertyBag, final PropertyDescriptor pd, final List<Attachment> newAtts) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Attachments atts = AttachmentUtils.getCopyOrCreateAttachments(propertyBag, pd);
                for (Attachment att : newAtts) {
                    atts.add((Object)att);
                }
                propertyBag.setValue(pd, (Object)atts);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void attach(final PropertyBag propertyBag, final PropertyDescriptor pd, final Attachment att) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Attachments atts = AttachmentUtils.getCopyOrCreateAttachments(propertyBag, pd);
                atts.add((Object)att);
                propertyBag.setValue(pd, (Object)atts);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void attachFiles(PropertyBag propertyBag, PropertyDescriptor pd, List<File> files, List<FastURL> sources) {
        List<Attachment> atts = AttachmentUtils.createAttachments(files, sources);
        if (atts != null && !atts.isEmpty()) {
            AttachmentUtils.attach(propertyBag, pd, atts);
        }
    }

    public static void attachFile(PropertyBag propertyBag, PropertyDescriptor pd, File file, FastURL source) {
        Attachment att = AttachmentUtils.createAttachment(file, source);
        if (att != null) {
            AttachmentUtils.attach(propertyBag, pd, att);
        }
    }

    public static long getSize(List<Attachment> atts) {
        long size = 0L;
        for (Attachment att : atts) {
            size += AttachmentUtils.getSize(att);
        }
        return size;
    }

    public static long getSize(Attachment att) {
        return FileStore.getDefault().getSize(att.getId());
    }

    public static int export(String path, List<Attachment> atts) {
        int savedCount = 0;
        for (Attachment att : atts) {
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            if (!AttachmentUtils.export(path, att)) continue;
            ++savedCount;
        }
        return savedCount;
    }

    public static boolean export(String path, Attachment att) {
        boolean success = false;
        try {
            File attFile = FileStore.getDefault().get(att.getId());
            path = path + att.getFileName();
            File destFile = new File(path);
            if (AttachmentUtils.checkFileOverwrite(destFile)) {
                FileUtilities.copyFile((File)attFile, (File)destFile);
                success = true;
            }
        }
        catch (FileNotFoundException ex) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)("Could not export " + att.getFileName() + ". The internal file store is corrupt."), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
        }
        catch (IOException ex) {
            AttachmentUtils.showCouldNotSave(ex, att.getFileName());
        }
        return success;
    }

    private static void showCouldNotSave(IOException ex, String filename) {
        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)("Could not export " + filename + ".\n " + ex.getLocalizedMessage()), 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
    }

    private static boolean checkFileOverwrite(File file) {
        if (file.exists()) {
            NotifyDescriptor.Confirmation conf = new NotifyDescriptor.Confirmation((Object)("The file " + file.getName() + " exists. Do you want to overwrite it?"), "File Exists", 2);
            return DialogDisplayer.getDefault().notify((NotifyDescriptor)conf) == NotifyDescriptor.OK_OPTION;
        }
        return true;
    }

    public static boolean hasAttachmentsProperty(PropertyBag propertyBag) {
        for (PropertyDescriptor pd : propertyBag.getProperties()) {
            if (!Attachments.class.equals((Object)pd.getType())) continue;
            return true;
        }
        return false;
    }

    public static PropertyDescriptor addAttachmentsProperty(PropertyBag propertyBag) {
        DisplayDescriptor attsPd = new DisplayDescriptor(Attachments.class, "property.atts31415237681098", "Attachments");
        propertyBag.addProperty((PropertyDescriptor)attsPd);
        return attsPd;
    }

    public static PropertyDescriptor getOrCreateAttachmentsProperty(PropertyBag propertyBag) {
        DisplayDescriptor attsPd = null;
        for (PropertyDescriptor pd : propertyBag.getProperties()) {
            if (!Attachments.class.equals((Object)pd.getType())) continue;
            attsPd = pd;
            break;
        }
        if (attsPd == null) {
            attsPd = new DisplayDescriptor(Attachments.class, "property.atts31415237681098", "Attachments");
            propertyBag.addProperty((PropertyDescriptor)attsPd);
        }
        return attsPd;
    }

    public static Attachments getCopyOrCreateAttachments(PropertyBag propertyBag, PropertyDescriptor pd) {
        Attachments atts = (Attachments)propertyBag.getValue(pd);
        atts = atts == null ? new Attachments() : new Attachments(atts);
        return atts;
    }

    public static List<Attachment> getImageAttachments(PropertyBag propertyBag) {
        List<Attachment> atts = AttachmentUtils.getAllAttachments(propertyBag);
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        for (Attachment att : atts) {
            String fileName = att.getFileName();
            if (fileName == null || !"Image".equals(FileUtilities.getFileType((String)fileName))) continue;
            attachments.add(att);
        }
        return attachments;
    }
}

