/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.certificates.impl;

import com.paterva.maltego.certificates.CertificateRepository;
import com.paterva.maltego.certificates.CertificateTrustHandler;
import com.paterva.maltego.certificates.CertificateUtils;
import com.paterva.maltego.util.MaltegoHelper;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.openide.util.Exceptions;
import sun.security.ssl.SSLSocketImpl;

public class MultiKeyStoreTrustManager
extends X509ExtendedTrustManager {
    protected ArrayList<X509TrustManager> x509TrustManagers = new ArrayList();
    private boolean _testing = false;
    private boolean _overrideBackoff = false;
    private boolean _attachCertAction = false;

    public MultiKeyStoreTrustManager(boolean testing, boolean overrideBackoff, boolean attachCertAction, KeyStore ... additionalkeyStores) {
        this._testing = testing;
        this._overrideBackoff = overrideBackoff;
        this._attachCertAction = attachCertAction;
        ArrayList<TrustManagerFactory> factories = new ArrayList<TrustManagerFactory>();
        try {
            TrustManagerFactory original = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            original.init((KeyStore)null);
            factories.add(original);
            for (KeyStore keyStore : additionalkeyStores) {
                TrustManagerFactory additionalCerts = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                additionalCerts.init(keyStore);
                factories.add(additionalCerts);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (TrustManagerFactory tmf : factories) {
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                this.x509TrustManagers.add((X509TrustManager)tm);
            }
        }
        if (this.x509TrustManagers.isEmpty()) {
            throw new RuntimeException("Couldn't find any X509TrustManagers");
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        URL url = null;
        if (socket instanceof SSLSocketImpl) {
            SSLSocketImpl socketImpl = (SSLSocketImpl)socket;
            try {
                Object hostname;
                Method method;
                String ver = MaltegoHelper.getJavaVersion();
                String hostnameString = null;
                if (MaltegoHelper.isJava8((String)ver) || MaltegoHelper.isJava9((String)ver) || MaltegoHelper.isJava10((String)ver)) {
                    method = socketImpl.getClass().getDeclaredMethod("getHost", new Class[0]);
                    method.setAccessible(true);
                    hostname = method.invoke((Object)socketImpl, new Object[0]);
                    if (hostname != null && hostname instanceof String) {
                        hostnameString = (String)hostname;
                    }
                } else {
                    method = socketImpl.getClass().getDeclaredMethod("getPeerHost", new Class[0]);
                    hostname = method.invoke((Object)socketImpl, new Object[0]);
                    if (hostname != null && hostname instanceof String) {
                        hostnameString = (String)hostname;
                    }
                }
                if (hostnameString == null) {
                    hostnameString = socketImpl.getInetAddress().getHostName();
                }
                url = new URL("https://" + hostnameString);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        CertificateException ex = new CertificateException("URL is null.");
        if (url != null) {
            boolean noTrustedCert;
            String msg = "The certificate for the following URL needs validation:\n" + url + "\n\n" + "A summary of the certificate information is shown below, with more detailed information shown on the \"Details\" tab.";
            CertificateRepository certRepo = CertificateRepository.getDefault();
            CertificateTrustHandler certTrustHandler = CertificateTrustHandler.getDefault();
            do {
                noTrustedCert = true;
                for (X509TrustManager tm : this.x509TrustManagers) {
                    try {
                        tm.checkServerTrusted(chain, authType);
                        this.checkChain(tm, certRepo, chain);
                        noTrustedCert = false;
                    }
                    catch (CertificateException e) {
                        ex = e;
                    }
                }
            } while (certTrustHandler.handleCertificate(msg, chain, url.toString(), false, noTrustedCert, this._testing, this._overrideBackoff) == CertificateTrustHandler.TrustResult.STILL_TO_CHOOSE);
            CertificateTrustHandler.CertificateActions certAction = certTrustHandler.mustShowTrustPrompt(chain[0], url.toString(), noTrustedCert);
            if (CertificateTrustHandler.CertificateActions.ALLOW == certAction) {
                return;
            }
            if (this._attachCertAction) {
                ex = CertificateUtils.attachCertActionToException(certAction, ex);
            }
        }
        throw ex;
    }

    private void checkChain(X509TrustManager tm, CertificateRepository certRepo, X509Certificate[] chain) throws CertificateException {
        X509Certificate[] acceptedIssuers;
        X509Certificate serverCert = chain[0];
        if (CertificateUtils.isBlackListedInCertRepo(certRepo, serverCert)) {
            throw new CertificateException("Certificate blacklisted in Maltego \"Certificate Manager\".");
        }
        boolean found = false;
        block0: for (X509Certificate acceptedIssuer : acceptedIssuers = tm.getAcceptedIssuers()) {
            for (X509Certificate cert : chain) {
                if ((!CertificateUtils.isValid(acceptedIssuer) || !CertificateUtils.isSigningCa(acceptedIssuer, cert)) && (!CertificateUtils.isValid(cert) || !acceptedIssuer.equals(cert))) continue;
                found = true;
                continue block0;
            }
        }
        if (!found) {
            throw new CertificateException("No valid certificate chain found.");
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        for (X509TrustManager tm : this.x509TrustManagers) {
            list.addAll(Arrays.asList(tm.getAcceptedIssuers()));
        }
        return list.toArray(new X509Certificate[list.size()]);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] xcs, String authType, Socket socket) throws CertificateException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void checkClientTrusted(X509Certificate[] xcs, String authType, SSLEngine ssle) throws CertificateException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] xcs, String authType, SSLEngine ssle) throws CertificateException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void checkClientTrusted(X509Certificate[] xcs, String authType) throws CertificateException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] xcs, String authType) throws CertificateException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

