/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.layout.view;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.layout.LayoutFactory;
import com.paterva.maltego.layout.view.TransactionLayoutCallback;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.ui.graph.data.GraphDataUtils;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutMode;
import com.paterva.maltego.ui.graph.view2d.layout.MaltegoHierarchicLayouter;
import com.paterva.maltego.ui.graph.view2d.layout.MaltegoLabelLayouter;
import com.paterva.maltego.ui.graph.view2d.layout.MaltegoLayouter;
import com.paterva.maltego.ui.graph.view2d.layout.MinimizeVisibleEntityMovementLayouter;
import com.paterva.maltego.ui.graph.view2d.layout.NodeOrderLayouter;
import com.paterva.maltego.ui.graph.view2d.layout.PreventDriftLayouter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;
import y.algo.GraphConnectivity;
import y.base.DataProvider;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.layout.BufferedLayouter;
import y.layout.LayoutGraph;
import y.layout.Layouter;
import y.layout.hierarchic.IncrementalHierarchicLayouter;
import y.layout.partial.PartialLayouter;
import y.util.DataProviderAdapter;
import y.view.Graph2D;
import y.view.Graph2DLayoutExecutor;
import y.view.Graph2DView;
import y.view.LayoutMorpher;
import y.view.Selections;

public class ViewLayouter {
    private static final Logger LOG = Logger.getLogger(ViewLayouter.class.getName());

    public static void layoutAll(Graph2DView view, LayoutMode mode, boolean keepZoom, Runnable callback, boolean isSignificant) throws IllegalStateException {
        ViewLayouter.layoutAll(view, mode, keepZoom, false, Collections.EMPTY_SET, callback, isSignificant);
    }

    public static void layoutAll(Graph2DView view, LayoutMode mode, boolean keepZoom, boolean incremental, Set<Node> newNodes, Runnable callback, boolean isSignificant) throws IllegalStateException {
        ViewLayouter.layoutProvided(view, null, mode, keepZoom, incremental, newNodes, callback, isSignificant);
    }

    public static void layoutProvided(Graph2DView view, DataProvider nodeProvider, LayoutMode mode, boolean keepZoom, Runnable callback, boolean isSignificant) throws IllegalStateException {
        ViewLayouter.layoutProvided(view, nodeProvider, mode, keepZoom, false, Collections.EMPTY_SET, callback, isSignificant);
    }

    public static void layoutProvided(final Graph2DView view, final DataProvider nodeProvider, LayoutMode mode, final boolean keepZoom, boolean incremental, Set<Node> newNodes, final Runnable callback, final boolean isSignificant) throws IllegalStateException {
        final Graph2D graph2D = view.getGraph2D();
        final GraphID graphID = GraphIDProvider.forGraph((Graph2D)graph2D);
        Layouter layouter = LayoutFactory.getLayouter(graph2D, mode, incremental);
        if (layouter == null || graph2D.nodeCount() == 0) {
            if (callback != null) {
                callback.run();
            }
        } else {
            HashSet<Object> incrementalNodes;
            if (incremental && graph2D.nodeCount() < 60) {
                incrementalNodes = new HashSet();
                NodeCursor nodes = graph2D.nodes();
                while (nodes.ok()) {
                    incrementalNodes.add(nodes.node());
                    nodes.next();
                }
            } else {
                incrementalNodes = new HashSet<Node>(newNodes);
            }
            final Layouter augmentedLayouter = ViewLayouter.augmentLayouter(nodeProvider, mode, graph2D, view, layouter, incremental, incrementalNodes);
            final HashSet<Node> newNodesCopy = new HashSet<Node>(newNodes);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    block4: {
                        try {
                            if (GraphStoreRegistry.getDefault().isExistingAndOpen(graphID)) {
                                HackLayoutMorpher layoutMorpher = new HackLayoutMorpher();
                                layoutMorpher.setKeepZoomFactor(keepZoom);
                                layoutMorpher.setSmoothViewTransform(false);
                                Graph2DLayoutExecutor executer = new Graph2DLayoutExecutor(7);
                                executer.setLayoutMorpher((LayoutMorpher)layoutMorpher);
                                TransactionLayoutCallback transactionCallback = new TransactionLayoutCallback(graph2D, nodeProvider, newNodesCopy, callback, isSignificant);
                                Graph2DView viewWrapper = view;
                                executer.doLayout(viewWrapper, augmentedLayouter, (Runnable)transactionCallback, null);
                                GraphDataObject gdo = GraphDataUtils.getGraphDataObject((Graph)graph2D);
                                if (gdo != null) {
                                    gdo.setModified(true);
                                }
                            }
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                            if (callback == null) break block4;
                            callback.run();
                        }
                    }
                }
            });
        }
    }

    public static void layoutNodes(Graph2DView view, Set<Node> nodes, LayoutMode mode, boolean keepZoom, Runnable callback, boolean isSignificant) throws IllegalStateException {
        if (nodes == null || nodes.isEmpty()) {
            if (callback != null) {
                callback.run();
            }
            return;
        }
        PartialNodeDataProvider nodeProvider = new PartialNodeDataProvider(nodes);
        ViewLayouter.layoutProvided(view, (DataProvider)nodeProvider, mode, keepZoom, callback, isSignificant);
    }

    public static void layoutSelection(Graph2DView view, LayoutMode mode, boolean keepZoom, Runnable callback, boolean isSignificant) throws IllegalStateException {
        DataProvider nodeProvider = Selections.createSelectionDataProvider((Graph2D)view.getGraph2D());
        ViewLayouter.layoutProvided(view, nodeProvider, mode, keepZoom, callback, isSignificant);
    }

    public static void layoutAll(Graph2D graph2D, LayoutMode mode) throws IllegalStateException {
        ViewLayouter.layoutProvided(graph2D, null, mode);
    }

    public static void layoutNodes(Graph2D graph2D, Set<Node> nodes, LayoutMode mode) throws IllegalStateException {
        if (nodes != null && !nodes.isEmpty()) {
            PartialNodeDataProvider nodeProvider = new PartialNodeDataProvider(nodes);
            ViewLayouter.layoutProvided(graph2D, (DataProvider)nodeProvider, mode);
        }
    }

    public static void layoutProvided(Graph2D graph2D, DataProvider nodeProvider, LayoutMode mode) throws IllegalStateException {
        Layouter layouter = LayoutFactory.getLayouter(graph2D, mode, false);
        if (layouter != null) {
            layouter = ViewLayouter.augmentLayouter(nodeProvider, mode, graph2D, null, layouter);
            layouter = new BufferedLayouter(layouter);
            layouter.doLayout((LayoutGraph)graph2D);
        }
    }

    private static Layouter augmentLayouter(DataProvider nodeProvider, LayoutMode mode, Graph2D graph2D, Graph2DView view, Layouter layouter) {
        return ViewLayouter.augmentLayouter(nodeProvider, mode, graph2D, view, layouter, false, Collections.EMPTY_SET);
    }

    private static Layouter augmentLayouter(DataProvider nodeProvider, LayoutMode mode, Graph2D graph2D, Graph2DView view, Layouter layouter, boolean incremental, Set<Node> newNodes) {
        if (nodeProvider != null) {
            boolean isAlignLayout = LayoutMode.ALIGN_LEFT.equals((Object)mode) || LayoutMode.ALIGN_RIGHT.equals((Object)mode) || LayoutMode.ALIGN_TOP.equals((Object)mode) || LayoutMode.ALIGN_BOTTOM.equals((Object)mode) || LayoutMode.CENTER_VERTICALLY.equals((Object)mode) || LayoutMode.CENTER_HORIZONTALLY.equals((Object)mode);
            graph2D.addDataProvider(PartialLayouter.PARTIAL_NODES_DPKEY, nodeProvider);
            if (LOG.isLoggable(Level.ALL)) {
                NodeCursor nc = graph2D.nodes();
                while (nc.ok()) {
                    Node node = nc.node();
                    boolean bool = nodeProvider.getBool((Object)node);
                    LOG.log(Level.FINE, "{0}: {1}", new Object[]{node, bool});
                    nc.next();
                }
            }
            PartialLayouter pl = new PartialLayouter(layouter);
            if (LayoutMode.BLOCK.equals((Object)mode)) {
                pl.setComponentAssignmentStrategy((byte)3);
                graph2D.addDataProvider(PartialLayouter.COMPONENT_ASSIGNMENT_DPKEY, (DataProvider)new SiblingComponentProvider());
            } else if (isAlignLayout) {
                pl.setComponentAssignmentStrategy((byte)3);
                graph2D.addDataProvider(PartialLayouter.COMPONENT_ASSIGNMENT_DPKEY, (DataProvider)new SingleComponentProvider());
            } else {
                pl.setComponentAssignmentStrategy((byte)1);
            }
            pl.setPositioningStrategy((byte)3);
            if (LayoutMode.BLOCK.equals((Object)mode) || LayoutMode.HIERARCHICAL.equals((Object)mode)) {
                pl.setLayoutOrientation((byte)0);
            } else {
                pl.setLayoutOrientation((byte)-1);
            }
            layouter = pl;
            if (isAlignLayout) {
                PreventDriftLayouter pdl = new PreventDriftLayouter();
                pdl.setNodeProviderKey(PartialLayouter.PARTIAL_NODES_DPKEY);
                pdl.setCoreLayouter(layouter);
                layouter = pdl;
            }
        } else {
            if (incremental) {
                if (layouter instanceof IncrementalHierarchicLayouter) {
                    IncrementalHierarchicLayouter ihl = (IncrementalHierarchicLayouter)layouter;
                    ihl.setLayoutMode((byte)0);
                    MaltegoHierarchicLayouter mhl = new MaltegoHierarchicLayouter(newNodes);
                    mhl.setCoreLayouter((Layouter)ihl);
                    layouter = mhl;
                } else if (layouter instanceof MaltegoLayouter) {
                    MaltegoLayouter ml = (MaltegoLayouter)layouter;
                    ml.setIncremental(true);
                    ml.setNewNodes(newNodes);
                }
            }
            if (view != null) {
                MinimizeVisibleEntityMovementLayouter mveml = new MinimizeVisibleEntityMovementLayouter(view);
                mveml.setCoreLayouter(layouter);
                layouter = mveml;
            }
        }
        NodeOrderLayouter nol = new NodeOrderLayouter();
        nol.setCoreLayouter(layouter);
        layouter = nol;
        MaltegoLabelLayouter labelLayouter = new MaltegoLabelLayouter();
        labelLayouter.setCoreLayouter(layouter);
        layouter = labelLayouter;
        return layouter;
    }

    private static class SingleComponentProvider
    extends DataProviderAdapter {
        private SingleComponentProvider() {
        }

        public Object get(Object o) {
            return null;
        }
    }

    private static class SiblingComponentProvider
    extends DataProviderAdapter {
        private final Map<Object, NodeList> _groups = new HashMap<Object, NodeList>();

        private SiblingComponentProvider() {
        }

        public Object get(Object o) {
            Object nodeGroup = null;
            if (o instanceof Node) {
                Node node = (Node)o;
                nodeGroup = this.findGroup(node);
                if (nodeGroup == null) {
                    nodeGroup = new Object();
                    this._groups.put(nodeGroup, new NodeList(node));
                } else {
                    this._groups.get(nodeGroup).add((Object)node);
                }
            }
            return nodeGroup;
        }

        private Object findGroup(Node node) {
            Graph graph = node.getGraph();
            for (Object group : this._groups.keySet()) {
                NodeList neighbors;
                NodeList nodeList = this._groups.get(group);
                if (!this.overlaps(nodeList, neighbors = GraphConnectivity.getNeighbors((Graph)graph, (NodeList)new NodeList(node), (int)2))) continue;
                return group;
            }
            return null;
        }

        private boolean overlaps(NodeList nodeList1, NodeList nodeList2) {
            NodeCursor nc = nodeList1.nodes();
            while (nc.ok()) {
                if (nodeList2.contains((Object)nc.node())) {
                    return true;
                }
                nc.next();
            }
            return false;
        }
    }

    private static class HackLayoutMorpher
    extends LayoutMorpher {
        private static boolean _hasWarned = false;

        private HackLayoutMorpher() {
        }

        public void calcFrame(double d) {
            block2: {
                try {
                    super.calcFrame(d);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    if (_hasWarned) break block2;
                    System.out.println("WARNING LayoutMorpher ArrayIndexOutOfBoundsException ignored by design");
                    _hasWarned = true;
                }
            }
        }
    }

    private static class PartialNodeDataProvider
    extends DataProviderAdapter {
        private final Set<Node> _nodes;

        public PartialNodeDataProvider(Set<Node> nodes) {
            this._nodes = new HashSet<Node>(nodes);
        }

        public boolean getBool(Object obj) {
            if (obj instanceof Node) {
                try {
                    return this._nodes.contains((Node)obj);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return false;
        }
    }
}

