/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.layout.view;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.transacting.GraphTransactorRegistry;
import com.paterva.maltego.ui.graph.transactions.GraphPositionAndPathHelper;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.util.SimilarStrings;
import com.paterva.maltego.util.ui.WindowUtil;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Timer;
import org.openide.util.Exceptions;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.view.Graph2D;

public class TransactionLayoutCallback
implements Runnable {
    private final GraphID _graphID;
    private final Graph2D _graph2D;
    private final Map<EntityID, Point> _centersBefore;
    private final Map<LinkID, List<Point>> _pathsBefore;
    private final Runnable _delegate;
    private final DataProvider _nodeProvider;
    private final boolean _isSignificant;
    private final int _reservedNumber;
    private boolean _graphClosed = false;
    private final PropertyChangeListener _listener;

    public TransactionLayoutCallback(Graph2D graph2D, DataProvider nodeProvider, Set<Node> newNodes, Runnable delegate, boolean isSignificant) {
        this._graph2D = graph2D;
        this._nodeProvider = nodeProvider;
        Set<EntityID> entityIDs = this.getEntityIDs(graph2D, nodeProvider);
        this._centersBefore = GraphPositionAndPathHelper.getViewCenters((Graph2D)graph2D, entityIDs);
        this._pathsBefore = GraphPositionAndPathHelper.getViewPathsForEntities((Graph2D)graph2D, entityIDs);
        this._delegate = delegate;
        this._isSignificant = isSignificant;
        this._graphID = GraphIDProvider.forGraph((Graph2D)graph2D);
        this._reservedNumber = GraphTransactorRegistry.getDefault().get(this._graphID).reserve();
        this.ensureLayoutChangeForNewNodes(newNodes, this._centersBefore, this._pathsBefore);
        this._listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("graphClosing".equals(evt.getPropertyName()) && evt.getNewValue().equals(TransactionLayoutCallback.this._graphID)) {
                    GraphLifeCycleManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                    TransactionLayoutCallback.this._graphClosed = true;
                }
            }
        };
        GraphLifeCycleManager.getDefault().addPropertyChangeListener(this._listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block13: {
            if (!this._graphClosed) {
                GraphLifeCycleManager.getDefault().removePropertyChangeListener(this._listener);
                try {
                    WindowUtil.showWaitCursor();
                    GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
                    if (!graphStore.isOpen()) {
                        Timer timer = new Timer(1000, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                TransactionLayoutCallback.this.run();
                            }
                        });
                        timer.setRepeats(false);
                        timer.start();
                        break block13;
                    }
                    try {
                        Set<EntityID> entitiesAfter = this.getEntityIDs(this._graph2D, this._nodeProvider);
                        GraphTransactionHelper.commitLayoutChanges((SimilarStrings)new SimilarStrings("Change layout"), (Graph2D)this._graph2D, entitiesAfter, this._centersBefore, this._pathsBefore, (Integer)this._reservedNumber, (boolean)this._isSignificant);
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        if (this._delegate != null) {
                            this._delegate.run();
                        }
                    }
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    WindowUtil.hideWaitCursor();
                }
            }
        }
    }

    private Set<EntityID> getEntityIDs(Graph2D graph2D, DataProvider nodeProvider) {
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((Graph)graph2D);
        HashSet<EntityID> ids = new HashSet<EntityID>();
        Graph graph = wrapper.getGraph();
        NodeCursor nodes = graph.nodes();
        while (nodes.ok()) {
            Node node = nodes.node();
            if (nodeProvider == null || nodeProvider.getBool((Object)node)) {
                ids.add(wrapper.entityID(node));
            }
            nodes.next();
        }
        return ids;
    }

    private void ensureLayoutChangeForNewNodes(Set<Node> newNodes, Map<EntityID, Point> centersBefore, Map<LinkID, List<Point>> pathsBefore) {
        Iterator<Node> iterator = newNodes.iterator();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            if (node.getGraph() != null) continue;
            iterator.remove();
        }
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((Graph)this._graph2D);
        for (Node node : newNodes) {
            EntityID entityID = wrapper.entityID(node);
            if (entityID == null) continue;
            Point center = centersBefore.get(entityID);
            if (center != null) {
                center.translate(0, -5);
            }
            EdgeCursor edges = node.edges();
            while (edges.ok()) {
                List<Point> path;
                Edge edge = edges.edge();
                LinkID linkID = wrapper.linkID(edge);
                if (linkID != null && (path = pathsBefore.get(linkID)) != null) {
                    path = new ArrayList<Point>();
                    path.add(new Point(0, 2));
                    path.add(new Point(0, 0));
                    pathsBefore.put(linkID, path);
                }
                edges.next();
            }
        }
    }
}

