/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.layout.view;

import com.paterva.maltego.layout.IncrementalLayoutSettings;
import com.paterva.maltego.ui.graph.GraphType;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutMode;
import com.paterva.maltego.util.ui.components.LeftAlignedToggleButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import org.openide.util.ImageUtilities;
import y.base.Graph;
import y.view.Graph2D;

public class LayoutViewToolbar
extends JToolBar {
    public static final String PROP_ALL_OR_NEW = "layoutAllOrNewChanged";
    public static final String PROP_LAYOUT_MODE = "layoutModeChanged";
    private final ButtonGroup _modeButtonGroup;
    private final JToggleButton _allOrNewButton;
    private final JToggleButton _incrementalButton;
    private final JToggleButton _interactiveOrganicButton;
    private final List<JToggleButton> _modeButtons;
    private Graph2D _graph;
    private IncrementalListener _incrementalListener;
    private LayoutMode _oldMode = LayoutMode.BLOCK;

    public LayoutViewToolbar(boolean hideOnceOffButtons) {
        this._modeButtonGroup = new ButtonGroup();
        this._modeButtons = new ArrayList<JToggleButton>();
        this.setOrientation(1);
        Dimension d = new Dimension(10, 10);
        this.setMinimumSize(d);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setMargin(new Insets(0, 0, 0, 0));
        this._allOrNewButton = new LeftAlignedToggleButton();
        this._allOrNewButton.setIcon(ImageUtilities.loadImageIcon((String)"com/paterva/maltego/layout/resources/Unlocked.png", (boolean)false));
        this._allOrNewButton.setSelectedIcon(ImageUtilities.loadImageIcon((String)"com/paterva/maltego/layout/resources/Locked.png", (boolean)false));
        this._allOrNewButton.addActionListener(new AllOrNewButtonListener());
        this._allOrNewButton.setToolTipText("Locks/unlocks the layouting. When locked, the layouting will only be done on new entities; existing entities will remain in place.");
        this._allOrNewButton.setFocusPainted(false);
        this._allOrNewButton.setFocusable(false);
        if (!hideOnceOffButtons) {
            this.add(this._allOrNewButton);
        }
        this._incrementalButton = new LeftAlignedToggleButton();
        this._incrementalButton.setIcon(ImageUtilities.loadImageIcon((String)"com/paterva/maltego/layout/resources/IncrementalNo.png", (boolean)false));
        this._incrementalButton.setSelectedIcon(ImageUtilities.loadImageIcon((String)"com/paterva/maltego/layout/resources/IncrementalYes.png", (boolean)false));
        this._incrementalButton.addActionListener(new IncrementalButtonListener());
        this._incrementalButton.setToolTipText("<html>Toggle between full or incremental layouting when transforms return.<br>Incremental layouting reduces the distances that nodes move during a layout when there are more than 60 nodes in the graph.<br>Incremental layouting only works for the Block and Hierarchic layouts.</html>");
        this._incrementalButton.setFocusPainted(false);
        this._incrementalButton.setFocusable(false);
        this._incrementalButton.setEnabled(true);
        if (!hideOnceOffButtons) {
            this.add(this._incrementalButton);
        }
        LayoutButtonListener toggleListener = new LayoutButtonListener();
        this.addLayoutMode(LayoutMode.BLOCK, toggleListener, this._modeButtonGroup, hideOnceOffButtons);
        this.addLayoutMode(LayoutMode.HIERARCHICAL, toggleListener, this._modeButtonGroup, hideOnceOffButtons);
        this.addLayoutMode(LayoutMode.CIRCULAR, toggleListener, this._modeButtonGroup, hideOnceOffButtons);
        this.addLayoutMode(LayoutMode.ORGANIC, toggleListener, this._modeButtonGroup, hideOnceOffButtons);
        this._interactiveOrganicButton = this.addLayoutMode(LayoutMode.INTERACTIVE_ORGANIC, toggleListener, null, false);
    }

    @Override
    public void addSeparator() {
        JToolBar.Separator s = new JToolBar.Separator(null){

            @Override
            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(0, y, width, height);
            }
        };
        s.setBorder(new EmptyBorder(0, 0, 0, 0));
        s.setAlignmentX(0.0f);
        this.add(s);
    }

    public void setGraph(Graph2D graph) {
        this._graph = graph;
        this.updateIncremental();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._incrementalListener = new IncrementalListener();
        IncrementalLayoutSettings.getDefault().addPropertyChangeListener(this._incrementalListener);
        this.updateIncremental();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        IncrementalLayoutSettings.getDefault().removePropertyChangeListener(this._incrementalListener);
        this._incrementalListener = null;
    }

    private JToggleButton addLayoutMode(LayoutMode mode, LayoutButtonListener toggleListener, ButtonGroup group, boolean hide) {
        String name = mode.getName();
        LeftAlignedToggleButton toggleButton = new LeftAlignedToggleButton();
        toggleButton.setIcon(ImageUtilities.loadImageIcon((String)("com/paterva/maltego/layout/resources/Layout" + name.replaceAll(" ", "") + ".png"), (boolean)false));
        String tooltip = "Set layout mode to " + name;
        toggleButton.setToolTipText(tooltip);
        toggleButton.setFocusPainted(false);
        toggleButton.setActionCommand(name);
        toggleButton.addActionListener(toggleListener);
        toggleButton.setFocusable(false);
        if (group != null) {
            group.add((AbstractButton)toggleButton);
        }
        if (!hide) {
            this.add((Component)toggleButton);
        }
        this._modeButtons.add((JToggleButton)toggleButton);
        return toggleButton;
    }

    public void setLayoutAll(boolean layoutAll) {
        this._allOrNewButton.setSelected(!layoutAll);
    }

    public boolean isLayoutAll() {
        return !this._allOrNewButton.isSelected();
    }

    public void setLayoutMode(LayoutMode mode) {
        for (JToggleButton button : this._modeButtons) {
            if (!mode.getName().equals(button.getActionCommand())) continue;
            button.setSelected(true);
            break;
        }
    }

    public LayoutMode getLayoutMode() {
        for (JToggleButton button : this._modeButtons) {
            if (!button.isSelected()) continue;
            return LayoutMode.getMode((String)button.getActionCommand());
        }
        return null;
    }

    public void setInteractiveSelected(boolean selected, boolean fireChange) {
        if (selected != this._interactiveOrganicButton.isSelected()) {
            this._interactiveOrganicButton.setSelected(selected);
            this.onInteractiveChanged();
            if (fireChange) {
                this.firePropertyChange(PROP_LAYOUT_MODE, null, this.getLayoutMode());
            }
        }
    }

    public boolean isInteractiveSelected() {
        return this._interactiveOrganicButton.isSelected();
    }

    private void onInteractiveChanged() {
        if (this._interactiveOrganicButton.isSelected()) {
            this._oldMode = this.getLayoutMode();
            this._modeButtonGroup.clearSelection();
        } else {
            this.setLayoutMode(this._oldMode);
        }
    }

    private void updateIncremental() {
        boolean selected;
        boolean incremental;
        if (this._graph != null && (incremental = IncrementalLayoutSettings.getDefault().isIncremental(GraphType.getType((Graph)this._graph))) != (selected = this._incrementalButton.isSelected())) {
            this._incrementalButton.setSelected(incremental);
        }
    }

    private class IncrementalListener
    implements PropertyChangeListener {
        private IncrementalListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LayoutViewToolbar.this.updateIncremental();
        }
    }

    private class IncrementalButtonListener
    implements ActionListener {
        private IncrementalButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (LayoutViewToolbar.this._graph != null) {
                IncrementalLayoutSettings.getDefault().setIncremental(GraphType.getType((Graph)LayoutViewToolbar.this._graph), LayoutViewToolbar.this._incrementalButton.isSelected());
            }
        }
    }

    private class AllOrNewButtonListener
    implements ActionListener {
        private AllOrNewButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LayoutViewToolbar.this.firePropertyChange(LayoutViewToolbar.PROP_ALL_OR_NEW, !LayoutViewToolbar.this.isLayoutAll(), LayoutViewToolbar.this.isLayoutAll());
        }
    }

    private class LayoutButtonListener
    implements ActionListener {
        private LayoutButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LayoutMode mode = LayoutMode.getMode((String)e.getActionCommand());
            boolean enabled = mode == LayoutMode.BLOCK || mode == LayoutMode.HIERARCHICAL;
            LayoutViewToolbar.this._incrementalButton.setEnabled(enabled);
            if (LayoutMode.INTERACTIVE_ORGANIC.equals((Object)mode)) {
                LayoutViewToolbar.this.onInteractiveChanged();
            } else {
                LayoutViewToolbar.this._interactiveOrganicButton.setSelected(false);
            }
            LayoutViewToolbar.this.firePropertyChange(LayoutViewToolbar.PROP_LAYOUT_MODE, null, mode);
        }
    }
}

