/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.layout.view;

import com.paterva.maltego.layout.LayoutFactory;
import com.paterva.maltego.layout.view.LayoutHandler;
import com.paterva.maltego.ui.graph.view2d.InteractiveMoveSelectionMode;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutMode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.GraphEvent;
import y.base.GraphListener;
import y.base.Node;
import y.geom.YPoint;
import y.layout.BufferedLayouter;
import y.layout.CopiedLayoutGraph;
import y.layout.LayoutGraph;
import y.layout.Layouter;
import y.layout.organic.InteractiveOrganicLayouter;
import y.layout.organic.SmartOrganicLayouter;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.Graph2DView;
import y.view.ViewMode;

public class InteractiveLayoutViewHandler
implements LayoutHandler {
    public static final String PROP_LAYOUTER = "layouterChanged";
    private static final int CLEANUP_DELAY = 600000;
    private long _lastCleanup;
    private Graph2DView _view;
    private Timer _timer;
    private Layouter _layouter;
    private UpdateHandler _updater;
    private static final int RELAYOUT_NODE_COUNT = 2000;
    private int _nodesChanged = 0;
    private boolean _preparingView = false;
    private final Object _relayoutLock = new Object();
    private LayoutMode _layoutMode;
    private boolean _preventWakeUp = false;
    private boolean _showing = false;
    private PropertyChangeSupport _layouterChangeSupport = new PropertyChangeSupport(this);
    private CopiedLayoutGraph _copiedLayoutGraph;

    InteractiveLayoutViewHandler(Graph2DView view) {
        this._view = view;
        this._updater = new UpdateHandler();
        this._timer = new Timer(21, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                Object object = InteractiveLayoutViewHandler.this._relayoutLock;
                synchronized (object) {
                    if (InteractiveLayoutViewHandler.this._preparingView) {
                        return;
                    }
                }
                if (InteractiveLayoutViewHandler.this._layouter instanceof InteractiveOrganicLayouter) {
                    InteractiveOrganicLayouter layouter = (InteractiveOrganicLayouter)InteractiveLayoutViewHandler.this._layouter;
                    if (layouter.commitPositionsSmoothly(50.0, 0.1) > 0.0) {
                        InteractiveLayoutViewHandler.this.clearBendsAndResetPorts();
                        InteractiveLayoutViewHandler.this._view.getGraph2D().updateViews();
                    }
                    if (layouter.isSleeping() && InteractiveLayoutViewHandler.this.needsCleanup()) {
                        InteractiveLayoutViewHandler.this.cleanup();
                    }
                }
            }
        });
    }

    public void setLayoutMode(LayoutMode newLayoutMode) {
        if (this._layoutMode == newLayoutMode) {
            return;
        }
        this._layoutMode = newLayoutMode;
        if (this._layoutMode == null) {
            if (this._timer != null) {
                this._timer.stop();
            }
            this.dispose(this._copiedLayoutGraph);
            this._copiedLayoutGraph = null;
            this._layouter = null;
            return;
        }
        if (this._showing) {
            this.createLayouter();
            this._timer.start();
        }
    }

    private void clearBendsAndResetPorts() {
        Graph2D graph2D = this._view.getGraph2D();
        this._preventWakeUp = true;
        graph2D.firePreEvent();
        EdgeCursor edges = graph2D.edges();
        while (edges.ok()) {
            Edge edge = edges.edge();
            EdgeRealizer realizer = graph2D.getRealizer(edge);
            realizer.clearBends();
            graph2D.setSourcePointRel(edge, YPoint.ORIGIN);
            graph2D.setTargetPointRel(edge, YPoint.ORIGIN);
            edges.next();
        }
        graph2D.firePostEvent();
        this._preventWakeUp = false;
    }

    public ViewMode getMoveSelectionMode() {
        if (this._layouter instanceof InteractiveOrganicLayouter) {
            InteractiveOrganicLayouter layouter = (InteractiveOrganicLayouter)this._layouter;
            return new InteractiveMoveSelectionMode(layouter);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onGraphChanged(Graph2D oldGraph, Graph2D newGraph) {
        if (oldGraph != null) {
            oldGraph.removeGraphListener((GraphListener)this._updater);
        }
        if (newGraph != null) {
            Object object = this._relayoutLock;
            synchronized (object) {
                this._nodesChanged = newGraph.nodeCount();
            }
            if (this._showing) {
                this.createLayouter();
                this._timer.start();
            } else {
                this.dispose(this._copiedLayoutGraph);
                this._copiedLayoutGraph = null;
                this._layouter = null;
            }
            newGraph.addGraphListener((GraphListener)this._updater);
        }
    }

    @Override
    public void onGraphUpdated(Set<Node> newNodes) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareToShow() {
        boolean relayout;
        Object object = this._relayoutLock;
        synchronized (object) {
            relayout = this._nodesChanged >= 2000;
            this._preparingView = true;
        }
        if (relayout) {
            SmartOrganicLayouter organicLayouter = new SmartOrganicLayouter();
            organicLayouter.enableOnlyCore();
            organicLayouter.setPreferredEdgeLength(760.0);
            organicLayouter.setQualityTimeRatio(0.48);
            organicLayouter.setNodeEdgeOverlapAvoided(false);
            organicLayouter.setNodeOverlapsAllowed(true);
            organicLayouter.setCompactness(0.72);
            organicLayouter.setNodeSizeAware(false);
            organicLayouter.setSmartComponentLayoutEnabled(false);
            new BufferedLayouter((Layouter)organicLayouter).doLayout((LayoutGraph)this._view.getGraph2D());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InteractiveLayoutViewHandler.this._view.fitContent();
                }
            });
        }
        object = this._relayoutLock;
        synchronized (object) {
            this._nodesChanged = 0;
            this._preparingView = false;
        }
    }

    private void createLayouter() {
        double nodeCount = this._view.getGraph2D().nodeCount();
        int delay = (int)(nodeCount * nodeCount / 100000.0 + 21.0);
        delay = Math.min(delay, 1000);
        this._timer.setDelay(delay);
        Layouter old = this._layouter;
        if (this._layoutMode == null) {
            this._layoutMode = LayoutMode.BLOCK;
        }
        this._layouter = LayoutFactory.getLayouter(this._view.getGraph2D(), this._layoutMode, false);
        if (this._layouter instanceof InteractiveOrganicLayouter) {
            InteractiveOrganicLayouter layouter = (InteractiveOrganicLayouter)this._layouter;
            if (!layouter.isRunning()) {
                this.dispose(this._copiedLayoutGraph);
                this._copiedLayoutGraph = new CopiedLayoutGraph((LayoutGraph)this._view.getGraph2D());
                layouter.startLayout((LayoutGraph)this._copiedLayoutGraph);
            }
            layouter.wakeUp();
        }
        this._layouterChangeSupport.firePropertyChange(PROP_LAYOUTER, old, this._layouter);
        this._lastCleanup = System.currentTimeMillis();
    }

    private void dispose(CopiedLayoutGraph graph) {
        if (graph != null) {
            Object[] dataProviders;
            graph.clear();
            for (Object dataProvider : dataProviders = graph.getDataProviderKeys()) {
                graph.removeDataProvider(dataProvider);
            }
        }
    }

    @Override
    public void onComponentShowing() {
        this._showing = true;
        if (this._layoutMode != null) {
            if (this._layouter == null) {
                this.createLayouter();
            }
            this._timer.start();
        }
    }

    @Override
    public void onComponentHidden() {
        this._showing = false;
        if (this._timer.isRunning()) {
            this._timer.stop();
        }
    }

    @Override
    public void onComponentClosed() {
        if (this._layouter != null) {
            if (this._layouter instanceof InteractiveOrganicLayouter) {
                InteractiveOrganicLayouter layouter = (InteractiveOrganicLayouter)this._layouter;
                layouter.stop();
            }
            this.dispose(this._copiedLayoutGraph);
            this._copiedLayoutGraph = null;
            this._layouter = null;
        }
    }

    private boolean needsCleanup() {
        return System.currentTimeMillis() - this._lastCleanup > 600000L;
    }

    private void cleanup() {
        this._timer.stop();
        if (this._layouter instanceof InteractiveOrganicLayouter) {
            InteractiveOrganicLayouter layouter = (InteractiveOrganicLayouter)this._layouter;
            layouter.stopAndWait();
        }
        this.createLayouter();
        this._timer.start();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._layouterChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._layouterChangeSupport.removePropertyChangeListener(listener);
    }

    private class UpdateHandler
    implements GraphListener {
        private int _block = 0;

        private UpdateHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onGraphEvent(GraphEvent e) {
            if (e.getGraph() instanceof Graph2D) {
                Object object;
                switch (e.getType()) {
                    case 12: {
                        ++this._block;
                        break;
                    }
                    case 13: {
                        --this._block;
                        break;
                    }
                    case 0: 
                    case 3: {
                        object = InteractiveLayoutViewHandler.this._relayoutLock;
                        synchronized (object) {
                            if (!InteractiveLayoutViewHandler.this._view.isShowing()) {
                                InteractiveLayoutViewHandler.this._nodesChanged++;
                            }
                            break;
                        }
                    }
                }
                if (this._block == 0) {
                    object = InteractiveLayoutViewHandler.this._relayoutLock;
                    synchronized (object) {
                        if (!InteractiveLayoutViewHandler.this._preparingView && !InteractiveLayoutViewHandler.this._preventWakeUp && InteractiveLayoutViewHandler.this._layouter instanceof InteractiveOrganicLayouter) {
                            InteractiveOrganicLayouter layouter = (InteractiveOrganicLayouter)InteractiveLayoutViewHandler.this._layouter;
                            layouter.wakeUp();
                        }
                    }
                }
            }
        }
    }
}

