/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.layout.actions;

import com.paterva.maltego.layout.view.ViewLayouter;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.actions.CookieAction;
import com.paterva.maltego.ui.graph.util.YFilesUtil;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutMode;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutSettings;
import javax.swing.JComponent;
import y.view.Graph2DView;

public abstract class AbstractLayoutAction
extends CookieAction<GraphViewCookie> {
    public AbstractLayoutAction() {
        super(GraphViewCookie.class);
    }

    protected abstract LayoutMode getLayoutMode();

    protected abstract boolean isLayoutAll();

    protected abstract boolean isKeepZoom();

    public String getName() {
        return this.getLayoutMode().getName();
    }

    protected void performLayout(Graph2DView graph2DView) {
        GraphView graphView = ((GraphViewCookie)this.getCookie()).getGraphView();
        if (this.isLayoutAll()) {
            LayoutSettings layoutSettings = graphView.getLayoutSettings();
            boolean layoutAll = layoutSettings.isLayoutAll();
            if (!layoutAll) {
                ViewLayouter.layoutAll(graph2DView, this.getLayoutMode(), this.isKeepZoom(), null, false);
            }
            graphView.setLayout(new LayoutSettings(layoutAll, this.getLayoutMode()), true);
        } else {
            YFilesUtil.clearSelectedEntityBends((GraphView)graphView);
            ViewLayouter.layoutSelection(graph2DView, this.getLayoutMode(), this.isKeepZoom(), null, true);
        }
    }

    protected void performAction(GraphViewCookie cookie) {
        JComponent viewControl;
        GraphView graphView = cookie.getGraphView();
        boolean isInteractive = graphView.isInteractiveLayout();
        boolean layout = true;
        if (isInteractive) {
            layout = true;
            graphView.setFreezeLayout(true);
            graphView.setInteractiveLayout(false);
            graphView.setFreezeLayout(false);
        }
        if (layout && (viewControl = graphView.getViewControl()) instanceof Graph2DView) {
            Graph2DView graph2DView = (Graph2DView)viewControl;
            this.performLayout(graph2DView);
        }
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }
}

