/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.importexport.wizard.im;

import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigImporter;
import com.paterva.maltego.importexport.nodes.AllConfigsNode;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import com.paterva.maltego.util.ui.dialog.WizardNavigationSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.openide.WizardDescriptor;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;

class ImportProgressController
extends ValidatingController<JPanel>
implements WizardNavigationSupport {
    private JTextArea _text = new JTextArea("");

    public ImportProgressController() {
        this.setName("Import");
    }

    protected JPanel createComponent() {
        JLabel title = new JLabel("Import Complete");
        title.setFont(title.getFont().deriveFont(1, (float)title.getFont().getSize() + 1.0f));
        this._text.setBackground(title.getBackground());
        this._text.setTabSize(4);
        this._text.setEnabled(false);
        this._text.setDisabledTextColor(Color.BLACK);
        JLabel finishLabel = new JLabel("Click Finish to close the wizard.");
        finishLabel.setHorizontalAlignment(4);
        JPanel northPanel = new JPanel(new BorderLayout(10, 10));
        northPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        northPanel.add((Component)title, "North");
        northPanel.add(this._text);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)northPanel, "North");
        panel.add((Component)finishLabel, "South");
        return panel;
    }

    protected void readSettings(WizardDescriptor settings) {
        Object icon;
        Object description = settings.getProperty("progress_description");
        if (description != null) {
            this.setDescription((String)description);
        }
        if ((icon = settings.getProperty("progress_icon")) != null) {
            this.setImage(ImageUtilities.loadImage((String)((String)icon).replace(".png", "48.png")));
        }
        AllConfigsNode allConfigsNode = (AllConfigsNode)((Object)this.getDescriptor().getProperty("allConfigs"));
        Map allConfigs = (Map)this.getDescriptor().getProperty("configsMap");
        Node[] nodes = allConfigsNode.getChildren().getNodes();
        String displayResults = "";
        for (Node node : nodes) {
            Config config = (Config)node.getLookup().lookup(Config.class);
            ConfigImporter importer = (ConfigImporter)allConfigs.get(config);
            int result = importer.applyConfig(config);
            if (result <= 0) continue;
            displayResults = displayResults + "\t" + result + "\t" + node.getName() + "\n";
        }
        displayResults = displayResults.isEmpty() ? "Nothing was imported." : "The following items were imported:\n\n" + displayResults;
        this._text.setText(displayResults);
    }

    protected void storeSettings(WizardDescriptor settings) {
    }

    public boolean canBack() {
        return false;
    }
}

