/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.importexport.wizard.ex;

import com.paterva.maltego.archive.mtz.MaltegoArchiveWriter;
import com.paterva.maltego.archive.mtz.MtzVersion;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigExporter;
import com.paterva.maltego.importexport.nodes.AllConfigsNode;
import com.paterva.maltego.util.ui.PasswordUtil;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import org.openide.WizardDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

class ExportProgressController
extends ValidatingController<JPanel> {
    private JTextArea _text = new JTextArea("");

    public ExportProgressController() {
        this.setName("Export");
    }

    protected JPanel createComponent() {
        JLabel title = new JLabel("Export Complete");
        title.setFont(title.getFont().deriveFont(1, (float)title.getFont().getSize() + 1.0f));
        this._text.setBackground(title.getBackground());
        this._text.setTabSize(4);
        this._text.setEnabled(false);
        this._text.setDisabledTextColor(Color.BLACK);
        JLabel finishLabel = new JLabel("Click Finish to close the wizard.");
        finishLabel.setHorizontalAlignment(4);
        JPanel northPanel = new JPanel(new BorderLayout(10, 10));
        northPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        northPanel.add((Component)title, "North");
        northPanel.add(this._text);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)northPanel, "North");
        panel.add((Component)finishLabel, "South");
        return panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readSettings(WizardDescriptor settings) {
        Object icon;
        Object description = settings.getProperty("progress_description");
        if (description != null) {
            this.setDescription((String)description);
        }
        if ((icon = settings.getProperty("progress_icon")) != null) {
            this.setImage(ImageUtilities.loadImage((String)((String)icon).replace(".png", "48.png")));
        }
        String displayResults = "";
        File file = (File)settings.getProperty("selectedFile");
        boolean encrypt = (Boolean)settings.getProperty("encrypt");
        MaltegoArchiveWriter writer = null;
        try {
            MtzVersion mtgxVersion = MtzVersion.getMTZ();
            if (!encrypt) {
                writer = new MaltegoArchiveWriter(mtgxVersion, (OutputStream)new FileOutputStream(file));
            } else {
                String password = (String)settings.getProperty("password");
                ZipParameters zipParams = PasswordUtil.getZipParameters((String)password);
                try {
                    if (file.exists()) {
                        file.delete();
                    }
                    ZipFile zipFile = new ZipFile(file);
                    writer = new MaltegoArchiveWriter(mtgxVersion, zipFile, zipParams);
                }
                catch (ZipException ex) {
                    throw new IOException(ex);
                }
            }
            AllConfigsNode allConfigsNode = (AllConfigsNode)((Object)this.getDescriptor().getProperty("allConfigs"));
            Map allConfigs = (Map)this.getDescriptor().getProperty("configsMap");
            StringBuilder sb = new StringBuilder(displayResults);
            for (Node node : allConfigsNode.getChildren().getNodes()) {
                Config config = (Config)node.getLookup().lookup(Config.class);
                ConfigExporter exporter = (ConfigExporter)allConfigs.get(config);
                int result = exporter.saveConfig(writer, config);
                if (result <= 0) continue;
                sb.append("\t");
                sb.append(result);
                sb.append("\t");
                sb.append(node.getName());
                sb.append("\n");
            }
            displayResults = sb.toString();
            displayResults = displayResults.isEmpty() ? "Nothing was exported." : "The following items were exported:\n\n" + displayResults;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            displayResults = "The following error occurred:\n\n" + ex.getMessage();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        this._text.setText(displayResults);
    }

    protected void storeSettings(WizardDescriptor settings) {
    }
}

