/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.importexport.previous;

import com.paterva.maltego.importexport.ConfigImporter;
import com.paterva.maltego.importexport.previous.PreviousConfigDirs;
import com.paterva.maltego.importexport.previous.PreviousVersion;
import com.paterva.maltego.importexport.wizard.im.ImportWizard;
import com.paterva.maltego.util.ui.actions.ActionSupplemental;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

@ActionSupplemental(key="description", value="Import your configuration items from an older version of Maltego")
public class MigrationWizardAction
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        ConfigImporter[] importers = ConfigImporter.getAll(Lookup.getDefault());
        if (importers.length == 0) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"The chosen import operation is not available in this version of Maltego."));
        } else {
            try {
                File parent = PreviousConfigDirs.getMaltegoConfigParent();
                if (!parent.isDirectory()) {
                    String msg = "Maltego user directory does not exist:\n" + parent.getAbsolutePath();
                    NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)msg);
                    descriptor.setTitle("Migration Wizard");
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                } else {
                    List<String> dirs = PreviousConfigDirs.getPreviousConfigDirs(parent);
                    if (dirs.isEmpty()) {
                        String msg = "No previous versions of Maltego (3.4 or newer) found in:\n" + parent.getAbsolutePath();
                        NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)msg);
                        descriptor.setTitle("Migration Wizard");
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                    } else {
                        ArrayList<PreviousVersion> versions = new ArrayList<PreviousVersion>(dirs.size());
                        for (String dir : dirs) {
                            PreviousVersion version = new PreviousVersion(new File(parent, dir));
                            versions.add(version);
                        }
                        Collections.sort(versions);
                        Collections.reverse(versions);
                        PreviousVersion[] versionsArr = versions.toArray(new PreviousVersion[versions.size()]);
                        HashMap<String, String> descriptionAndIcons = new HashMap<String, String>();
                        descriptionAndIcons.put("item_selection_description", "Select the configuration items you which to import from the old Maltego version.");
                        descriptionAndIcons.put("item_selection_icon", "com/paterva/maltego/importexport/resources/Migration.png");
                        descriptionAndIcons.put("progress_description", "The summary of the progress to import configurations from an old Maltego version is shown below.");
                        descriptionAndIcons.put("progress_icon", "com/paterva/maltego/importexport/resources/Migration.png");
                        descriptionAndIcons.put("previous_version_description", "Please select the old Maltego version from which you would like to import configuration items.");
                        descriptionAndIcons.put("previous_version_icon", "com/paterva/maltego/importexport/resources/Migration.png");
                        WizardUtilities.runWizard((WizardDescriptor)ImportWizard.createPreviousImport(importers, versionsArr, descriptionAndIcons));
                    }
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

