/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.importexport.option;

import com.paterva.maltego.importexport.ConfigImporter;
import com.paterva.maltego.importexport.wizard.im.ImportWizard;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import java.io.File;
import java.util.HashMap;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.Lookup;

public class ConfigFileImporter {
    public void importFile(File file) {
        if (file != null) {
            ConfigImporter[] importers = ConfigImporter.getAll(Lookup.getDefault());
            if (importers.length == 0) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"The chosen import operation is not available in this version of Maltego."));
            } else {
                HashMap<String, String> descriptionAndIcons = new HashMap<String, String>();
                descriptionAndIcons.put("item_selection_description", "Select the configuration items you which to import from the Maltego archive file.");
                descriptionAndIcons.put("item_selection_icon", "com/paterva/maltego/importexport/resources/ImportConfig.png");
                descriptionAndIcons.put("progress_description", "The summary of the progress to import configurations from a Maltego archive file is shown below.");
                descriptionAndIcons.put("progress_icon", "com/paterva/maltego/importexport/resources/ImportConfig.png");
                descriptionAndIcons.put("file_description", "Choose the Maltego archive file (containing configuration items) to import from your file system.");
                descriptionAndIcons.put("file_icon", "com/paterva/maltego/importexport/resources/ImportConfig.png");
                WizardUtilities.runWizard((WizardDescriptor)ImportWizard.create(importers, file, descriptionAndIcons));
            }
        }
    }
}

