/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config.ui;

import com.paterva.maltego.java.config.ConfigFileLocation;
import com.paterva.maltego.java.config.ConfigFileReader;
import com.paterva.maltego.java.config.ConfigFileWriter;
import com.paterva.maltego.java.config.ConfigOptions;
import com.paterva.maltego.java.config.IPVersion;
import com.paterva.maltego.java.config.IPVersionSettings;
import com.paterva.maltego.java.config.app.SilentDetector;
import com.paterva.maltego.java.config.ui.JavaOptions;
import com.paterva.maltego.util.ui.dialog.UIRunQueue;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import org.netbeans.api.options.OptionsDisplayer;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.modules.ModuleInstall;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public class Installer
extends ModuleInstall {
    private static final Logger LOG = Logger.getLogger(Installer.class.getName());
    private static final String PREF_32_BIT_SHOWN = "maltego.java.32bit.shown";
    public static final String REMOVE_IPV4 = "maltego.hack.remove.preferIPv4";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restored() {
        String javaVersion = System.getProperty("java.specification.version");
        if ("1.6".equals(javaVersion) || "1.7".equals(javaVersion)) {
            LOG.log(Level.WARNING, "Java version not supported: {0}", javaVersion);
            try {
                File file = this.getJavaConfigAppJarFile();
                JEditorPane ep = new JEditorPane("text/html", "<html>Java 6 and 7 are no longer supported by Maltego.<br><br>Please install and use Java 8 or 11.<br><br>The latest Java can be downloaded from <a href=\"https://java.com/download\">java.com/download</a>.</body></html>");
                ep.addHyperlinkListener(event -> {
                    if (event.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                        HtmlBrowser.URLDisplayer.getDefault().showURL(event.getURL());
                    }
                });
                ep.setEditable(false);
                ep.setBackground(new JLabel().getBackground());
                JOptionPane.showMessageDialog(null, ep, "Java", 1);
                Runtime.getRuntime().exec(new String[]{"java", "-jar", file.toString(), "-detect"});
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                System.exit(0);
            }
        }
        try {
            JavaOptions.initConfigPath();
            Preferences prefs = NbPreferences.forModule(((Object)((Object)this)).getClass());
            File configFile = new File(ConfigFileLocation.get());
            if (!configFile.isFile()) {
                prefs.put(REMOVE_IPV4, "False");
                new SilentDetector().go();
                Installer.logIPSettings(false);
                UIRunQueue.instance().queue(0, () -> {
                    String msg = "Memory settings were optimized, but will require a restart to take effect.";
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg);
                    nd.setTitle("Memory Settings Optimized");
                    String restartNow = "Restart Now";
                    nd.setOptions((Object[])new String[]{restartNow, "Restart Later"});
                    if (restartNow.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
                        LifecycleManager lifecycle = LifecycleManager.getDefault();
                        lifecycle.markForRestart();
                        lifecycle.exit();
                    }
                });
            } else {
                boolean mustRemoveIPv4 = prefs.get(REMOVE_IPV4, "True").equals("True");
                if (mustRemoveIPv4) {
                    Installer.logIPSettings(true);
                    Installer.removeIPv4(prefs);
                }
                Installer.logIPSettings(false);
                String arch = System.getProperty("os.arch");
                if (arch.contains("86") && !arch.contains("64")) {
                    LOG.warning("Running on 32-bit Java");
                    if (!prefs.getBoolean(PREF_32_BIT_SHOWN, false)) {
                        UIRunQueue.instance().queue(Integer.MAX_VALUE, () -> {
                            String msg = "We have detected that you are running Maltego on a 32-bit Java.\n\nIf you have a 64-bit Operating System please consider using a 64-bit Java installation instead.\n\nDo you want to open the Java Options?";
                            String optionsActions = "Open Java Options";
                            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg);
                            nd.setTitle("32-bit Java");
                            nd.setOptions((Object[])new String[]{optionsActions, "Close"});
                            if (optionsActions.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
                                OptionsDisplayer.getDefault().open("MaltegoJavaOptions");
                            }
                            prefs.putBoolean(PREF_32_BIT_SHOWN, true);
                        });
                    }
                } else {
                    LOG.warning("Running on 64-bit Java");
                    prefs.putBoolean(PREF_32_BIT_SHOWN, false);
                    Installer.checkIfCurrentJavaMustBeChanged();
                }
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    static void removeIPv4(Preferences prefs) {
        IPVersionSettings defaultIPVersionSettings = new IPVersionSettings();
        ConfigFileReader configFileReader = new ConfigFileReader();
        ConfigOptions options = configFileReader.read();
        IPVersionSettings ipVersionSettings = options.getIpVersionSettings();
        IPVersion ipv4 = ipVersionSettings.getIPv4();
        IPVersion ipv6 = ipVersionSettings.getIPv6();
        if (!ipVersionSettings.isManaged() && ipv4.isPrefer() && IPVersion.getIPv6Addresses().equals(ipv6)) {
            options.setIpVersionSettings(defaultIPVersionSettings);
            ConfigFileWriter configFileWriter = new ConfigFileWriter();
            configFileWriter.write(options);
        }
        prefs.put(REMOVE_IPV4, "False");
    }

    private static void logIPSettings(boolean beforeHack) {
        String suffix;
        ConfigFileReader configFileReader = new ConfigFileReader();
        ConfigOptions options = configFileReader.read();
        IPVersionSettings ipVersionSettings = options.getIpVersionSettings();
        boolean managed = ipVersionSettings.isManaged();
        String string = suffix = beforeHack ? " [Before removing IPv4]" : "";
        if (managed) {
            LOG.log(Level.INFO, "IP Settings: Java managed = {0}", managed + suffix);
        } else {
            IPVersion ipv4 = ipVersionSettings.getIPv4();
            IPVersion ipv6 = ipVersionSettings.getIPv6();
            LOG.log(Level.INFO, "IP Settings: {0} = {1}, {2} = {3}", new String[]{ipv4.getKey(), Boolean.toString(ipv4.isPrefer()), ipv6.getKey(), Boolean.toString(ipv6.isPrefer()) + suffix});
        }
    }

    private static void checkIfCurrentJavaMustBeChanged() {
        ConfigFileReader configFileReader = new ConfigFileReader();
        ConfigOptions options = configFileReader.read();
        String configJavaPath = options.getJavaRuntime();
        if (configJavaPath == null || !new File(configJavaPath).exists()) {
            boolean showJavaOptions = false;
            String currentJavaPath = System.getProperty("java.home");
            if (currentJavaPath != null && currentJavaPath.length() > 0) {
                File currentJava = new File(currentJavaPath);
                if (currentJava.exists()) {
                    System.out.println("new java: " + currentJavaPath);
                    ConfigFileWriter configFileWriter = new ConfigFileWriter();
                    options.setJavaRuntime(currentJavaPath);
                    configFileWriter.write(options);
                } else {
                    showJavaOptions = true;
                }
            } else {
                showJavaOptions = true;
            }
            if (showJavaOptions) {
                UIRunQueue.instance().queue(0x7FFFFFFE, () -> {
                    String msg = "We have detected that the stored Java location does not exist.\n\nPlease choose the preferred version from Java Options.";
                    String optionsActions = "Open Java Options";
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg);
                    nd.setTitle("Cannot locate stored Java version");
                    nd.setOptions((Object[])new String[]{optionsActions, "Close"});
                    if (optionsActions.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
                        OptionsDisplayer.getDefault().open("MaltegoJavaOptions");
                    }
                });
            }
        }
    }

    private File getJavaConfigAppJarFile() throws IllegalArgumentException, URISyntaxException {
        String location = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().toString();
        System.out.println("class location: " + location);
        location = location.replaceAll("^jar:(.*)\\!.*$", "$1");
        System.out.println("jar location: " + location);
        File file = Utilities.toFile((URI)new URI(location));
        file = new File(new File(file.getParentFile(), "ext"), "Java_Config_App.jar");
        System.out.println("java config app: " + file);
        return file;
    }
}

