/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.exp;

import com.paterva.maltego.graph.table.io.exp.GraphTableBuilder;
import com.paterva.maltego.graph.table.io.exp.TabularGraphExportResult;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.Lookup;

public abstract class TabularGraphFileExporter {
    public static final String LINK_FILE_SUFFIX = "_links";
    private File _file = null;
    private GraphTableBuilder tableBuilder;

    public static TabularGraphFileExporter[] getAll(Lookup lookup) {
        return (TabularGraphFileExporter[])lookup.lookupAll(TabularGraphFileExporter.class).stream().toArray(TabularGraphFileExporter[]::new);
    }

    public void setGraphTableBuilder(GraphTableBuilder tableBuilder) {
        this.tableBuilder = tableBuilder;
    }

    public GraphTableBuilder getGraphTableBuilder() {
        return this.tableBuilder;
    }

    public void setFile(File file) {
        this._file = file;
    }

    public File getFile() {
        return this._file;
    }

    protected File getLinksFile() throws IOException {
        String path = this._file.getParent();
        String name = this._file.getName();
        name = name.substring(0, name.indexOf(46));
        name = name + "_links." + this.getExtension();
        File file = new File(path, name);
        file.delete();
        file.createNewFile();
        return file;
    }

    public abstract String getFileType();

    public abstract String getExtension();

    public String getFileTypeDescription() {
        return this.getFileType() + " (*." + this.getExtension() + ")";
    }

    public TabularGraphExportResult export(ProgressHandle handle) throws IOException {
        try {
            this.tableBuilder.setHandle(handle);
            if (!this.tableBuilder.isBuilt()) {
                this.tableBuilder.build();
            }
            List<List<String>> table = this.tableBuilder.getTable();
            this.write(this._file, table, handle);
            if (!this.tableBuilder.hasSeparateLinks()) {
                return this.tableBuilder.getResult();
            }
            table = this.tableBuilder.getLinkTable();
            this.write(this.getLinksFile(), table, handle);
            return this.tableBuilder.getResult();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected abstract void write(File var1, List<List<String>> var2, ProgressHandle var3) throws IOException;
}

