/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.format;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.graph.table.TableIO;
import com.paterva.maltego.graph.table.format.EntityTableFormatter;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.openide.util.Exceptions;

public class PropertyFlatMapFormat
extends EntityTableFormatter {
    public static String ENTITY_START_ID = "EntityID";
    public static String ENTITY_TYPE = "EntityType";
    List<String> typeHeader;
    LinkedHashSet<PropertyDescriptor> properties;

    public PropertyFlatMapFormat(TableIO table) {
        super(table);
    }

    void createHeader() {
        if (this.typeHeader != null) {
            return;
        }
        this.properties = new LinkedHashSet();
        this.typeHeader = new ArrayList<String>();
        this.typeHeader.add(ENTITY_START_ID);
        this.typeHeader.add(ENTITY_TYPE);
        this.addRow(this.typeHeader);
    }

    void updateHeader(MaltegoEntity entity) {
        this.createHeader();
        if (!this.properties.addAll((Collection<PropertyDescriptor>)entity.getProperties())) {
            return;
        }
        for (PropertyDescriptor property : this.properties) {
            if (this.typeHeader.contains(property.getName())) continue;
            this.typeHeader.add(property.getName());
        }
    }

    @Override
    public void addEntity(MaltegoEntity entity) {
        this.updateHeader(entity);
        ArrayList<String> row = new ArrayList<String>();
        row.add(((EntityID)entity.getID()).toString());
        row.add(entity.getTypeName());
        for (PropertyDescriptor property : this.properties) {
            Object value = entity.getValue(property);
            row.add(value == null ? "" : Converter.convertTo((Object)value, (Class)property.getType()));
        }
        this.addRow(row);
    }

    @Override
    public Iterator<MaltegoEntity> entityIterator() {
        return new Reader();
    }

    List<String> getHeader(Reader reader) {
        String mark = null;
        List row = null;
        while (!ENTITY_START_ID.equals(mark)) {
            if (!reader.rowIterator.hasNext()) {
                return null;
            }
            row = (List)reader.rowIterator.next();
            String string = mark = row.size() < 3 ? null : (String)row.get(0);
            if (row.size() <= 1 || ENTITY_TYPE.equals(row.get(1))) continue;
            mark = null;
        }
        return row;
    }

    MaltegoEntity getEntity(Reader reader) {
        List row = (List)reader.rowIterator.next();
        if (row.size() < 3) {
            return null;
        }
        if (row.get(0) == null) {
            return null;
        }
        if (((String)row.get(0)).isEmpty()) {
            return null;
        }
        try {
            EntityID entityID = EntityID.parse((String)((String)row.get(0)));
            MaltegoEntitySpec entitySpec = this.getEntitySpec((String)row.get(1));
            MaltegoEntity entity = this.entityFactory().createInstance(entitySpec, false, entityID, true);
            this.setEntityPropertyData(entity, reader.propertyNames, row);
            return entity;
        }
        catch (TypeInstantiationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    void setEntityPropertyData(MaltegoEntity entity, List<String> propertyNames, List<String> values) {
        PropertyDescriptorCollection properties = entity.getProperties();
        for (int column = 2; column < propertyNames.size() && column < values.size(); ++column) {
            String name;
            String value = values.get(column);
            if (value == null || value.isEmpty() || (name = propertyNames.get(column)) == null || name.isEmpty()) continue;
            PropertyDescriptor property = properties.stream().filter(p -> p.getName().equals(name)).findFirst().orElse(null);
            if (property == null) {
                property = new PropertyDescriptor(String.class, name);
                properties.add(property);
            }
            Object data = Converter.convertFrom((String)value, (Class)property.getType());
            entity.setValue(property, data);
        }
    }

    class Reader
    extends EntityTableFormatter.Reader {
        protected Reader() {
        }

        @Override
        public MaltegoEntity next() {
            return PropertyFlatMapFormat.this.getEntity(this);
        }

        @Override
        protected List<String> readHeader() {
            return PropertyFlatMapFormat.this.getHeader(this);
        }
    }
}

