/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config.jre.windows;

import com.paterva.maltego.java.config.jre.DetectJavas;
import com.paterva.maltego.java.config.jre.windows.WinRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Set;

public class WinDetectJava
extends DetectJavas {
    @Override
    protected Set<String> getPathsToTry() {
        Set<String> paths = super.getPathsToTry();
        int[] archs = new int[]{512, 256};
        String[] regKeys = new String[]{"SOFTWARE\\AdoptOpenJDK\\JDK", "SOFTWARE\\AdoptOpenJDK\\JRE", "SOFTWARE\\JavaSoft\\JDK", "SOFTWARE\\JavaSoft\\JRE", "SOFTWARE\\JavaSoft\\Java Development Kit", "SOFTWARE\\JavaSoft\\Java Runtime Environment", "SOFTWARE\\JRockit\\Java Runtime Environment", "SOFTWARE\\JRockit\\Java Development Kit", "SOFTWARE\\JRockit\\JDK", "SOFTWARE\\JRockit\\JRE", "SOFTWARE\\IBM\\Java Runtime Environment", "SOFTWARE\\IBM\\Java2 Runtime Environment", "SOFTWARE\\IBM\\Java Development Kit", "SOFTWARE\\IBM\\JDK", "SOFTWARE\\IBM\\JRE"};
        for (int arch : archs) {
            for (String regKey : regKeys) {
                System.out.println("regKey = " + regKey);
                try {
                    List<String> versionKeys = WinRegistry.readStringSubKeys(-2147483646, regKey, arch);
                    if (versionKeys == null) continue;
                    for (String versionKey : versionKeys) {
                        String path;
                        String keyPath = regKey + "\\" + versionKey;
                        if (regKey != null && regKey.contains("AdoptOpenJDK")) {
                            path = WinRegistry.readString(-2147483646, keyPath + "\\hotspot\\MSI", "Path", arch);
                            if (path == null) {
                                path = WinRegistry.readString(-2147483646, keyPath + "\\openj9\\MSI", "Path", arch);
                            }
                        } else {
                            path = WinRegistry.readString(-2147483646, keyPath, "JavaHome", arch);
                        }
                        if (path == null || path.length() <= 1) continue;
                        if (path.endsWith("\\") || path.endsWith(File.separator)) {
                            path = path.substring(0, path.length() - 1);
                        }
                        System.out.println(keyPath + ": " + path);
                        paths.add(path);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.addJavasFromPath(paths);
        return paths;
    }

    private void addJavasFromPath(Set<String> paths) {
        String envPaths = System.getenv("PATH");
        if (envPaths != null && envPaths.length() > 0) {
            String[] envPathsArray;
            for (String envP : envPathsArray = envPaths.split(";")) {
                try {
                    String envPath;
                    File envF = new File(envP);
                    if (!envF.isDirectory() || !(envPath = envF.getAbsolutePath()).toLowerCase().contains("jdk")) continue;
                    if (envPath.toLowerCase().endsWith("bin") || envPath.toLowerCase().endsWith("bin" + File.separator)) {
                        if ((envF = envF.getParentFile()) != null && envF.isDirectory()) {
                            envPath = envF.getAbsolutePath();
                            if (!envPath.toLowerCase().endsWith(File.separator)) {
                                envPath = envPath + File.separator;
                            }
                        } else {
                            throw new FileNotFoundException();
                        }
                    }
                    if (paths.contains(envPath)) continue;
                    paths.add(envPath);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

