/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config.app;

import com.paterva.maltego.java.config.ConfigFileLocation;
import com.paterva.maltego.java.config.JavaOptionsPanel;
import com.paterva.maltego.java.config.app.AppUtils;
import com.paterva.maltego.java.config.app.SilentDetector;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class JavaOptionsApp {
    private JFrame _frame;
    JavaOptionsPanel _optionsPanel;

    public static void main(String[] args) throws Exception {
        boolean detect;
        String configFilePath = AppUtils.getConfigFilePath();
        if (configFilePath == null) {
            JOptionPane.showMessageDialog(null, "Could not find Maltego user directory.");
        } else {
            ConfigFileLocation.set(configFilePath);
        }
        boolean nogui = JavaOptionsApp.hasArgument(args, "-nogui");
        boolean bl = detect = nogui || JavaOptionsApp.hasArgument(args, "-detect");
        if (detect) {
            new SilentDetector().go();
        }
        if (!nogui) {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    System.setProperty("awt.useSystemAAFontSettings", "on");
                    System.setProperty("swing.aatext", "true");
                    JavaOptionsApp app = new JavaOptionsApp();
                    app.show();
                }
            });
        }
    }

    private static boolean hasArgument(String[] args, String arg) {
        arg = arg.toLowerCase();
        for (String a : args) {
            if (!arg.equals(a.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public void show() {
        this.initializeComponents();
        this._frame.setVisible(true);
    }

    private void initializeComponents() {
        this._optionsPanel = new JavaOptionsPanel();
        this._optionsPanel.load();
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JavaOptionsApp.this._optionsPanel.valid()) {
                    JavaOptionsApp.this._optionsPanel.store();
                    System.exit(0);
                }
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(okButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPanel.add(cancelButton);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this._optionsPanel);
        mainPanel.add(buttonPanel);
        this._frame = new JFrame();
        this._frame.setDefaultCloseOperation(3);
        this._frame.add(mainPanel);
        this._frame.pack();
        this._frame.setSize(new Dimension(600, 670));
        this._frame.getRootPane().setDefaultButton(okButton);
        this._frame.setTitle("Java Options");
        try {
            BufferedImage frame16 = ImageIO.read(this.getClass().getResource("frame16.png"));
            BufferedImage frame32 = ImageIO.read(this.getClass().getResource("frame32.png"));
            BufferedImage frame48 = ImageIO.read(this.getClass().getResource("frame48.png"));
            ArrayList<BufferedImage> frameIcons = new ArrayList<BufferedImage>();
            frameIcons.add(frame16);
            frameIcons.add(frame32);
            frameIcons.add(frame48);
            try {
                Class[] types = new Class[]{List.class};
                Method method = Class.forName("java.awt.Window").getDeclaredMethod("setIconImages", types);
                Object[] parameters = new Object[]{frameIcons};
                method.invoke((Object)this._frame, parameters);
            }
            catch (Exception ex) {
                this._frame.setIconImage(frame48);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this._frame.getSize();
        this._frame.setLocation(new Point((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.width) / 2));
    }
}

