/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config.app;

import com.paterva.maltego.java.config.app.JavaOptionsApp;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AppUtils {
    public static String getConfigFilePath() {
        String configFilePath = null;
        URL location = AppUtils.class.getProtectionDomain().getCodeSource().getLocation();
        System.out.println("pwd: " + location);
        try {
            File file = new File(location.toURI());
            File installDir = AppUtils.getInstallDir(file);
            if (installDir != null) {
                File maltegoConfFile = AppUtils.getMaltegoConfFile(installDir);
                if (!maltegoConfFile.isFile()) {
                    maltegoConfFile = new File("maltego.conf");
                }
                if (maltegoConfFile.isFile()) {
                    System.out.println("install conf: " + maltegoConfFile.getAbsolutePath());
                    String installVersion = AppUtils.getInstallVersion(maltegoConfFile);
                    if (installVersion != null) {
                        System.out.println("install version: " + installVersion);
                        configFilePath = AppUtils.buildConfigFilePath(installVersion);
                        System.out.println("user conf: " + configFilePath);
                    } else {
                        System.out.println("Could not find installed version in:" + maltegoConfFile.getPath());
                    }
                } else {
                    System.out.println("Could not find " + maltegoConfFile.getPath());
                }
            } else {
                System.out.println("Could not find install dir for: " + file.getPath());
            }
        }
        catch (Exception ex) {
            Logger.getLogger(JavaOptionsApp.class.getName()).log(Level.SEVERE, null, ex);
        }
        return configFilePath;
    }

    private static File getInstallDir(File thisJar) {
        File parent = thisJar.getParentFile();
        if (parent != null && (parent = parent.getParentFile()) != null && (parent = parent.getParentFile()) != null) {
            parent = parent.getParentFile();
        }
        return parent;
    }

    private static File getMaltegoConfFile(File installDir) {
        File etcFile = new File(installDir, "etc");
        return new File(etcFile, "maltego.conf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getInstallVersion(File maltegoConfFile) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(maltegoConfFile));
        try {
            String readLine;
            while ((readLine = reader.readLine()) != null) {
                if (!readLine.contains("default_userdir=")) continue;
                String string = readLine.substring(readLine.lastIndexOf(47) + 1, readLine.lastIndexOf(34));
                return string;
            }
        }
        finally {
            reader.close();
        }
        return null;
    }

    private static String buildConfigFilePath(String version) {
        StringBuilder configPath;
        if (System.getProperty("os.name").toLowerCase().startsWith("mac")) {
            configPath = new StringBuilder(System.getenv("HOME"));
            if (!configPath.toString().endsWith(File.separator)) {
                configPath.append(File.separator);
            }
            configPath.append("Library");
            configPath.append(File.separator);
            configPath.append("Application Support");
            configPath.append(File.separator);
            configPath.append("maltego");
        } else if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            configPath = new StringBuilder(System.getenv("APPDATA"));
            if (!configPath.toString().endsWith(File.separator)) {
                configPath.append(File.separator);
            }
            configPath.append(".maltego");
        } else {
            configPath = new StringBuilder(System.getenv("HOME"));
            if (!configPath.toString().endsWith(File.separator)) {
                configPath.append(File.separator);
            }
            configPath.append(".maltego");
        }
        configPath.append(File.separator);
        configPath.append(version);
        configPath.append(File.separator);
        configPath.append("etc");
        configPath.append(File.separator);
        configPath.append("maltego.conf");
        return configPath.toString();
    }

    public static int countDigits(String path) {
        int count = 0;
        int len = path.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isDigit(path.charAt(i))) continue;
            ++count;
        }
        return count;
    }
}

