/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config;

import com.paterva.maltego.java.config.ConfigOptions;
import com.paterva.maltego.java.config.MatteBorderLeft;
import com.paterva.maltego.java.config.jre.JavaInfo;
import com.paterva.maltego.java.config.jre.JavaUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;

public class JrePanel
extends JPanel {
    private Map<String, JavaInfo> _javaRuntimes;
    private ChangeListener _changeListener;
    private JButton _addButton;
    private JTextField _archTextField;
    private JComboBox _javaComboBox;
    private JTextField _vendorTextField;
    private JTextField _versionTextField;
    private JPanel dummy;

    public JrePanel() {
        this.initComponents();
        this._javaComboBox.addActionListener(new JavaRuntimeListener());
    }

    public void load(ConfigOptions options) {
        JavaInfo selectedJava;
        this._javaRuntimes = JavaUtils.detectJavas();
        String selected = options.getJavaRuntime();
        if (selected != null && selected.length() > 0 && !this._javaRuntimes.containsKey(selected) && (selectedJava = JavaUtils.getInfo(new File(selected))) != null) {
            this._javaRuntimes.put(selected, selectedJava);
        }
        ArrayList<String> paths = new ArrayList<String>(this._javaRuntimes.keySet());
        Collections.sort(paths);
        this._javaComboBox.removeAllItems();
        for (String path : paths) {
            this._javaComboBox.addItem(path);
        }
        if (paths.contains(selected)) {
            this._javaComboBox.setSelectedItem(selected);
        }
        this.update();
    }

    public void store(ConfigOptions options) {
        String selected = this.getSelected();
        options.setJavaRuntime(selected);
    }

    public Map<String, JavaInfo> getJavaRuntimes() {
        return Collections.unmodifiableMap(this._javaRuntimes);
    }

    public boolean valid() {
        return true;
    }

    private void update() {
        String selected = this.getSelected();
        if (selected != null) {
            JavaInfo javaInfo = this._javaRuntimes.get(selected);
            this.updateInfo(javaInfo);
        }
    }

    private void updateInfo(JavaInfo javaInfo) {
        this._versionTextField.setText(javaInfo.getVersion().toJdkStyle());
        this._archTextField.setText(javaInfo.getArch());
        this._vendorTextField.setText(javaInfo.getVendor());
    }

    private void initComponents() {
        JLabel jLabel4 = new JLabel();
        this._vendorTextField = new JTextField();
        this._javaComboBox = new JComboBox();
        this._addButton = new JButton();
        JLabel jLabel2 = new JLabel();
        this._versionTextField = new JTextField();
        JLabel jLabel3 = new JLabel();
        this._archTextField = new JTextField();
        this.dummy = new JPanel();
        JLabel jLabel5 = new JLabel();
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), UIManager.getLookAndFeelDefaults().getColor("TitledBorder.darculaMod.matteBorderColor")), "Java Runtime"), BorderFactory.createEmptyBorder(6, 10, 6, 10)));
        this.setLayout(new GridBagLayout());
        jLabel4.setText("Vendor");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.add((Component)jLabel4, gridBagConstraints);
        this._vendorTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.add((Component)this._vendorTextField, gridBagConstraints);
        this._javaComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this._javaComboBox, gridBagConstraints);
        this._addButton.setText("Browse");
        this._addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JrePanel.this._addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this._addButton, gridBagConstraints);
        jLabel2.setText("Version");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)jLabel2, gridBagConstraints);
        this._versionTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this._versionTextField, gridBagConstraints);
        jLabel3.setText("Architecture");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)jLabel3, gridBagConstraints);
        this._archTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this._archTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.dummy, gridBagConstraints);
        jLabel5.setText("Path");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)jLabel5, gridBagConstraints);
    }

    private void _addButtonActionPerformed(ActionEvent evt) {
        int result;
        String selected = this.getSelected();
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        if (selected != null) {
            fc.setCurrentDirectory(new File(selected));
        }
        if ((result = fc.showDialog(this, "OK")) == 0) {
            File folder = fc.getSelectedFile();
            String path = folder.getAbsolutePath();
            String select = null;
            if (!this._javaRuntimes.containsKey(path)) {
                JavaInfo info = JavaUtils.getInfo(new File(path));
                if (info != null) {
                    if (JavaUtils.isValidVersion(info.getVersion())) {
                        this._javaRuntimes.put(path, info);
                        this._javaComboBox.addItem(path);
                        select = path;
                    } else {
                        String msg = "The selected Java version (" + info.getVersion().toJdkStyle() + ") is not supported. Maltego only supports Java 1.8 & Java 11.";
                        JOptionPane.showMessageDialog(this, msg, "Version Not Supported", 2);
                    }
                } else {
                    String msg = "Not a valid Java runtime directory. It should contain a \"bin\" directory with a java executable file.";
                    JOptionPane.showMessageDialog(this, msg, "Java Not Found", 2);
                }
            } else {
                select = path;
            }
            if (select != null) {
                this._javaComboBox.setSelectedItem(select);
            }
            this.update();
        }
    }

    void setChangeListener(ChangeListener listener) {
        this._changeListener = listener;
    }

    public String getSelected() {
        return (String)this._javaComboBox.getSelectedItem();
    }

    private class JavaRuntimeListener
    implements ActionListener {
        private JavaRuntimeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JrePanel.this.update();
            if (JrePanel.this._changeListener != null) {
                JrePanel.this._changeListener.stateChanged(null);
            }
        }
    }
}

