/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config;

import com.paterva.maltego.java.config.ConfigFileReader;
import com.paterva.maltego.java.config.ConfigFileWriter;
import com.paterva.maltego.java.config.ConfigOptions;
import com.paterva.maltego.java.config.IPPanel;
import com.paterva.maltego.java.config.IPVersionSettings;
import com.paterva.maltego.java.config.JrePanel;
import com.paterva.maltego.java.config.MemoryPanel;
import com.paterva.maltego.java.config.MemorySelector;
import com.paterva.maltego.java.config.app.SilentDetector;
import com.paterva.maltego.java.config.jre.JavaInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JavaOptionsPanel
extends JPanel {
    private static final int HEAP_MAX_DEFAULT = 800;
    private final JButton _recommendedButton = new JButton("Set Recommended Options");
    private final JrePanel _jrePanel = new JrePanel();
    private final MemoryPanel _memoryPanel = new MemoryPanel();
    private final IPPanel _ipPanel = new IPPanel();
    private final ChangeListener _jreListener = new JreChangeListener();
    private final ChangeListener _memListener = new MemChangeListener();
    private final ChangeListener _ipListener = new IPSettingsChangeListener();
    private ChangeListener _externalListener;
    private Integer _heapSize32;
    private Integer _heapSize64;

    public JavaOptionsPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel p4 = new JPanel(new BorderLayout());
        p4.add((Component)this._ipPanel, "North");
        JPanel p3 = new JPanel(new BorderLayout(0, 12));
        p3.add((Component)this._memoryPanel, "North");
        p3.add((Component)p4, "Center");
        JPanel p2 = new JPanel(new BorderLayout());
        p2.add((Component)this._jrePanel, "North");
        p2.add((Component)p3, "Center");
        this._recommendedButton.addActionListener(new RecommendedListener());
        JPanel buttonPanel = new JPanel(new FlowLayout(0, 0, 0));
        buttonPanel.add(this._recommendedButton);
        JPanel p1 = new JPanel(new BorderLayout(12, 6));
        p1.setBorder(new EmptyBorder(0, 6, 6, 6));
        p1.add((Component)buttonPanel, "Center");
        JTextArea msgTextArea = new JTextArea("Please note that the Java options will be applied the next time Maltego is run.");
        msgTextArea.setOpaque(false);
        msgTextArea.setFont(new JLabel().getFont());
        msgTextArea.setEditable(false);
        p1.add((Component)msgTextArea, "North");
        this.add((Component)p1, "North");
        this.add(p2);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._jrePanel.setChangeListener(this._jreListener);
        this._memoryPanel.setChangeListener(this._memListener);
        this._ipPanel.setChangeListener(this._ipListener);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this._jrePanel.setChangeListener(null);
        this._memoryPanel.setChangeListener(null);
        this._ipPanel.setChangeListener(null);
    }

    public void load() {
        ConfigFileReader configFile = new ConfigFileReader();
        ConfigOptions options = configFile.read();
        this.load(options);
    }

    private void load(ConfigOptions options) {
        this._jrePanel.load(options);
        Integer heapSize = options.getMaxHeapSize();
        if (heapSize != null) {
            this.onHeapSizeChanged(heapSize);
        }
        this.updateSlider();
        this._ipPanel.load(options);
    }

    public void store() {
        ConfigOptions options = new ConfigOptions();
        this._jrePanel.store(options);
        this._memoryPanel.store(options);
        this._ipPanel.store(options);
        ConfigFileWriter configFile = new ConfigFileWriter();
        configFile.write(options);
    }

    public boolean valid() {
        return this._jrePanel.valid() && this._memoryPanel.valid() && this._ipPanel.valid();
    }

    IPPanel getIPPanel() {
        return this._ipPanel;
    }

    void doRecommendedButtonClick() {
        this._recommendedButton.doClick();
    }

    public void setChangeListener(ChangeListener listener) {
        this._externalListener = listener;
    }

    public void onHeapSizeChanged(int heapSize) {
        JavaInfo javaInfo = this.getSelectedJava();
        if (javaInfo != null) {
            this.onHeapSizeChanged(javaInfo, heapSize);
        }
    }

    public void onHeapSizeChanged(JavaInfo javaInfo, int heapSize) {
        if (javaInfo.isArch64()) {
            this._heapSize64 = heapSize;
        } else {
            this._heapSize32 = heapSize;
        }
    }

    public void updateSlider() {
        String selected = this._jrePanel.getSelected();
        if (selected != null) {
            Integer heapSize;
            MemorySelector memorySelector = MemorySelector.get(selected);
            JavaInfo javaInfo = this._jrePanel.getJavaRuntimes().get(selected);
            Integer n = heapSize = javaInfo.isArch64() ? this._heapSize64 : this._heapSize32;
            if (heapSize == null) {
                heapSize = 800;
                this.onHeapSizeChanged(javaInfo, heapSize);
            }
            this._memoryPanel.set(memorySelector.getMin(), memorySelector.getMax(), heapSize);
        }
    }

    private JavaInfo getSelectedJava() {
        String selected = this._jrePanel.getSelected();
        if (selected != null) {
            return this._jrePanel.getJavaRuntimes().get(selected);
        }
        return null;
    }

    private class RecommendedListener
    implements ActionListener {
        private RecommendedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Map<String, JavaInfo> javaRuntimes = JavaOptionsPanel.this._jrePanel.getJavaRuntimes();
            String selectedJavaBefore = JavaOptionsPanel.this._jrePanel.getSelected();
            int maxMemoryBefore = JavaOptionsPanel.this._memoryPanel.getMaxMemory();
            IPVersionSettings ipVersionSettings = JavaOptionsPanel.this._ipPanel.getIPVersionSettings();
            ConfigOptions options = new SilentDetector().selectOptions(javaRuntimes);
            Integer maxMemory = options.getMaxHeapSize();
            if (selectedJavaBefore != null && selectedJavaBefore.equals(options.getJavaRuntime()) && maxMemory != null && maxMemoryBefore == maxMemory && ipVersionSettings.equals(options.getIpVersionSettings())) {
                String msg = "Recommended options already selected.";
                String title = "Recommended Options";
                JOptionPane.showMessageDialog(JavaOptionsPanel.this, msg, title, 1);
            } else {
                JavaOptionsPanel.this.load(options);
            }
        }
    }

    private class IPSettingsChangeListener
    implements ChangeListener {
        private IPSettingsChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (JavaOptionsPanel.this._externalListener != null) {
                JavaOptionsPanel.this._externalListener.stateChanged(e);
            }
        }
    }

    private class MemChangeListener
    implements ChangeListener {
        private MemChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int memory;
            if (JavaOptionsPanel.this._externalListener != null) {
                JavaOptionsPanel.this._externalListener.stateChanged(e);
            }
            if ((memory = JavaOptionsPanel.this._memoryPanel.getMaxMemory()) > 0) {
                JavaOptionsPanel.this.onHeapSizeChanged(memory);
            }
        }
    }

    private class JreChangeListener
    implements ChangeListener {
        private JreChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (JavaOptionsPanel.this._externalListener != null) {
                JavaOptionsPanel.this._externalListener.stateChanged(e);
            }
            JavaOptionsPanel.this.updateSlider();
        }
    }
}

