/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config;

import com.paterva.maltego.java.config.ConfigFileIO;
import com.paterva.maltego.java.config.ConfigOptions;
import com.paterva.maltego.java.config.IPVersion;
import com.paterva.maltego.java.config.IPVersionSettings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.swing.JOptionPane;

public class ConfigFileWriter
extends ConfigFileIO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ConfigOptions options) {
        block22: {
            if (options.getMaxHeapSize() == null) {
                return;
            }
            OutputStreamWriter fw = null;
            try {
                try {
                    String configPath = this.getUserConfigFilePath();
                    File dir = new File(new File(configPath).getParent());
                    if (dir.exists() || dir.mkdirs()) {
                        String memPrefix;
                        boolean isValidRuntime;
                        File configFile = new File(configPath);
                        String maxMem = "-J-Xmx" + options.getMaxHeapSize() + "m";
                        String ipOptions = "";
                        IPVersionSettings ipVersionSettings = options.getIpVersionSettings();
                        boolean managed = ipVersionSettings.isManaged();
                        if (!managed) {
                            IPVersion ipv4 = ipVersionSettings.getIPv4();
                            IPVersion ipv6 = ipVersionSettings.getIPv6();
                            ipOptions = ipOptions + ipv4.getKey() + "=" + ipv4.isPrefer() + " " + ipv6.getKey() + "=" + ipv6.isPrefer() + " ";
                        }
                        String defaultOptions = "default_options=\"--branding maltego " + maxMem + " -J-XX:+UseG1GC " + ipOptions + "-J-Dsun.java2d.xrender=false --locale en:US\"\n";
                        String javaRuntime = options.getJavaRuntime();
                        boolean bl = isValidRuntime = javaRuntime != null && javaRuntime.length() > 0;
                        if (!configFile.exists()) {
                            String text = defaultOptions;
                            if (isValidRuntime) {
                                text = text + "jdkhome=\"" + javaRuntime + "\"\n";
                            }
                            fw = new FileWriter(configPath, false);
                            fw.write(text);
                            break block22;
                        }
                        BufferedReader reader = null;
                        String text = "";
                        try {
                            String line;
                            reader = new BufferedReader(new FileReader(configFile));
                            while ((line = reader.readLine()) != null) {
                                text = text + line + "\n";
                            }
                        }
                        finally {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        if (text.contains(IPVersion.getIPv4Stack().getKey())) {
                            text = text.replaceAll(IPVersion.getIPv4Stack().getKey() + "=(true|false)", "");
                        }
                        if (text.contains(IPVersion.getIPv6Addresses().getKey())) {
                            text = text.replaceAll(IPVersion.getIPv6Addresses().getKey() + "=(true|false)", "");
                        }
                        if (text.contains(memPrefix = "-J-Xmx")) {
                            text = text.replaceAll(memPrefix + "(\\d*)[kKmMgGbB]*", maxMem);
                            text = text.replaceAll(memPrefix, ipOptions + memPrefix);
                        } else {
                            text = text + "\n" + defaultOptions;
                        }
                        text = text.replaceAll(" +", " ");
                        text = text.replaceAll("jdkhome=\"[^\"]*\"", "");
                        if (isValidRuntime) {
                            text = text + "\njdkhome=\"" + javaRuntime + "\"";
                        }
                        while (text.contains("\n\n")) {
                            text = text.replaceAll("\n\n", "\n");
                        }
                        fw = new FileWriter(configPath, false);
                        fw.write(text);
                        break block22;
                    }
                    JOptionPane.showMessageDialog(null, "Unable to create " + dir.getPath(), "Error", 0);
                }
                finally {
                    if (fw != null) {
                        fw.close();
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

