/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config;

import com.paterva.maltego.java.config.ConfigFileIO;
import com.paterva.maltego.java.config.ConfigOptions;
import com.paterva.maltego.java.config.IPVersion;
import com.paterva.maltego.java.config.IPVersionSettings;
import com.paterva.maltego.java.config.jre.JavaInfo;
import com.paterva.maltego.java.config.jre.JavaUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigFileReader
extends ConfigFileIO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigOptions read() {
        FileInputStream fis;
        ConfigOptions options = new ConfigOptions();
        try {
            fis = new FileInputStream(this.getUserConfigFilePath());
        }
        catch (FileNotFoundException ex) {
            return options;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(fis));
        Pattern memPattern = Pattern.compile("Xmx(\\d*)m");
        Matcher memMatcher = memPattern.matcher("");
        Pattern jrePattern = Pattern.compile("^\\s*jdkhome=\"([^\"]*)\"");
        Matcher jreMatcher = jrePattern.matcher("");
        Pattern ipv4Pattern = Pattern.compile(IPVersion.getIPv4Stack().getKey() + "=(true|false)");
        Matcher ipv4Matcher = ipv4Pattern.matcher("");
        Pattern ipv6Pattern = Pattern.compile(IPVersion.getIPv6Addresses().getKey() + "=(true|false)");
        Matcher ipv6Matcher = ipv6Pattern.matcher("");
        try {
            try {
                String aLine;
                IPVersion ipv4 = IPVersion.getIPv4Stack();
                IPVersion ipv6 = IPVersion.getIPv6Addresses();
                boolean javaIPManaged = true;
                while ((aLine = in.readLine()) != null) {
                    String jrePath;
                    JavaInfo info;
                    memMatcher.reset(aLine);
                    if (memMatcher.find()) {
                        String heapSize = memMatcher.group(1);
                        Integer maxHeapSize = Integer.parseInt(heapSize);
                        options.setMaxHeapSize(maxHeapSize);
                    }
                    jreMatcher.reset(aLine);
                    if (jreMatcher.find() && (info = JavaUtils.getInfo(new File(jrePath = jreMatcher.group(1)))) != null && JavaUtils.isValidVersion(info.getVersion())) {
                        System.out.println("jdkhome: " + jrePath);
                        options.setJavaRuntime(jrePath);
                    }
                    ipv4Matcher.reset(aLine);
                    if (ipv4Matcher.find()) {
                        String ipv4Value = ipv4Matcher.group(1);
                        Boolean ipv4State = Boolean.parseBoolean(ipv4Value);
                        ipv4.setPrefer(ipv4State);
                        javaIPManaged = false;
                    }
                    ipv6Matcher.reset(aLine);
                    if (!ipv6Matcher.find()) continue;
                    String ipv6Value = ipv6Matcher.group(1);
                    Boolean ipv6State = Boolean.parseBoolean(ipv6Value);
                    ipv6.setPrefer(ipv6State);
                    javaIPManaged = false;
                }
                IPVersionSettings ipVersionSettings = new IPVersionSettings(ipv4, ipv6);
                ipVersionSettings.setManaged(javaIPManaged);
                options.setIpVersionSettings(ipVersionSettings);
            }
            finally {
                in.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        return options;
    }
}

