/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.rest;

import com.paterva.maltego.crypto.MaltegoClientCryptographer;
import com.paterva.maltego.crypto.payload.AsymmetricPayload;
import com.paterva.maltego.crypto.payload.EncryptedKeyAndIv;
import com.paterva.maltego.util.Args;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public class MaltegoRestRequest {
    private static final Logger LOG = Logger.getLogger(MaltegoRestRequest.class.getName());
    private static final String INDENT = "    ";
    private final String xmlRoot;
    private final Map<String, String> entries;

    public MaltegoRestRequest(String xmlRoot, Map<String, String> entries) {
        Args.notNullOrBlank((String)xmlRoot, (String)"root");
        Args.notNull(entries, (String)"entries");
        this.xmlRoot = xmlRoot;
        this.entries = Collections.unmodifiableMap(new LinkedHashMap<String, String>(entries));
    }

    public String getXmlRoot() {
        return this.xmlRoot;
    }

    public Map<String, String> getEntries() {
        return this.entries;
    }

    public String getRequestText() throws GeneralSecurityException {
        StringBuilder blob = new StringBuilder();
        MaltegoRestRequest.append(blob, INDENT, this.entries);
        LOG.fine(() -> "Request Blob:\n" + blob);
        MaltegoClientCryptographer crypto = MaltegoClientCryptographer.getInstance();
        AsymmetricPayload payload = crypto.encryptSymmetricAndAsymmetric(blob.toString());
        EncryptedKeyAndIv keyAndIv = payload.getEncryptedKeyAndIv();
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(this.xmlRoot).append(">\n");
        MaltegoRestRequest.append(sb, INDENT, "Key", this.base64(keyAndIv.getKey()));
        MaltegoRestRequest.append(sb, INDENT, "IV", this.base64(keyAndIv.getIv()));
        MaltegoRestRequest.append(sb, INDENT, "Blob", this.base64(payload.getSymmetricPayload().getCipherText()));
        sb.append("</").append(this.xmlRoot).append(">");
        return sb.toString();
    }

    public String getRequestBase64() throws GeneralSecurityException {
        return this.base64(this.getRequestText().getBytes(StandardCharsets.UTF_8));
    }

    private static void append(StringBuilder sb, String indent, Map<String, String> entries) {
        entries.entrySet().stream().forEach(e -> MaltegoRestRequest.append(sb, indent, (String)e.getKey(), (String)e.getValue()));
    }

    private static void append(StringBuilder sb, String indent, String name, String value) {
        if (value != null && !value.isEmpty()) {
            sb.append(indent);
            sb.append("<").append(name).append(">");
            sb.append(value);
            sb.append("</").append(name).append(">\n");
        }
    }

    private String base64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }
}

