/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.api;

import java.util.Date;

public class TransformMessage {
    private Date _timestamp;
    private String _text;
    private Severity _severity;
    private int _code;
    private boolean _log = false;

    public TransformMessage(String text) {
        this(null, Severity.Info, text);
    }

    public TransformMessage(Severity severity, String text) {
        this(null, severity, text);
    }

    public TransformMessage(Date timestamp, Severity severity, String text) {
        this(timestamp, severity, text, 0, false);
    }

    public TransformMessage(Date timestamp, Severity severity, String text, boolean log) {
        this(timestamp, severity, text, 0, log);
    }

    public TransformMessage(Date timestamp, Severity severity, String text, int code) {
        this(timestamp, severity, text, code, false);
    }

    public TransformMessage(Date timestamp, Severity severity, String text, int code, boolean log) {
        this._timestamp = timestamp != null ? timestamp : new Date();
        this._severity = severity;
        this._text = text;
        this._code = code;
        this._log = log;
    }

    public Date getTimestamp() {
        return this._timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this._timestamp = timestamp != null ? timestamp : new Date();
    }

    public String getText() {
        return this._text;
    }

    public void setText(String text) {
        this._text = text;
    }

    public Severity getSeverity() {
        return this._severity;
    }

    public void setSeverity(Severity severity) {
        this._severity = severity;
    }

    public int getCode() {
        return this._code;
    }

    public void setCode(int code) {
        this._code = code;
    }

    public boolean mustLog() {
        return this._log;
    }

    public void setMustLog(boolean mustLog) {
        this._log = mustLog;
    }

    public static enum Severity {
        Debug,
        Info,
        Warning,
        Error;

    }
}

