/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.event.MouseInputListener;
import javax.swing.text.BadLocationException;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.openide.util.Exceptions;
import y.view.Graph2DCanvas;
import y.view.Graph2DView;
import y.view.NodeRealizer;
import y.view.ViewContainer;
import y.view.ViewMode;
import y.view.YLabel;
import y.view.t;
import y.view.v;

public class LabelEditGraph2DView
extends Graph2DView {
    private static final Logger LOG = Logger.getLogger(LabelEditGraph2DView.class.getName());
    private static final boolean USE_OLD_EDITOR = false;

    public LabelEditGraph2DView() {
        try {
            Graph2DCanvas canvas = (Graph2DCanvas)FieldUtils.readField((Object)((Object)this), (String)"ic", (boolean)true);
            MouseInputListener mouseListener = (MouseInputListener)FieldUtils.readField((Object)((Object)this), (String)"jc", (boolean)true);
            canvas.removeMouseListener((MouseListener)mouseListener);
            canvas.removeMouseMotionListener((MouseMotionListener)mouseListener);
            canvas = new LabelEditGraph2DCanvas(this);
            canvas.addMouseListener((MouseListener)mouseListener);
            canvas.addMouseMotionListener((MouseMotionListener)mouseListener);
            FieldUtils.writeField((Object)((Object)this), (String)"ic", (Object)canvas, (boolean)true);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static class LabelEditGraph2DCanvas
    extends Graph2DCanvas {
        private final Graph2DView view;
        private JTextArea ub;

        public LabelEditGraph2DCanvas(Graph2DView view) {
            super(view);
            this.view = view;
        }

        private Integer getMb() throws IllegalAccessException {
            return (Integer)FieldUtils.readField((Object)((Object)this), (String)"mb", (boolean)true);
        }

        private void setMb(int value) throws IllegalAccessException {
            FieldUtils.writeField((Object)((Object)this), (String)"mb", (Object)value, (boolean)true);
        }

        public void openLabelEditor(YLabel label, double x, double y, PropertyChangeListener listener, final boolean singleLineMode, boolean center, boolean commitValue) {
            try {
                int i1 = NodeRealizer.z;
                Integer mb = this.getMb();
                if (mb == 666) {
                    return;
                }
                String str = label.getText();
                final JTextArea editor = new JTextArea(str){

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension localDimension = super.getPreferredSize();
                        if (this.isEditable()) {
                            try {
                                Rectangle localRectangle = this.modelToView(this.getCaretPosition());
                                if (localRectangle != null && localDimension != null && localRectangle.x + 3 > localDimension.width) {
                                    localDimension.width = localRectangle.x + Math.max(0, localRectangle.width) + 3;
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                        return localDimension;
                    }

                    @Override
                    protected void paintComponent(Graphics paramAnonymousGraphics) {
                        if (paramAnonymousGraphics.getFontMetrics().getHeight() > 0) {
                            super.paintComponent(paramAnonymousGraphics);
                        }
                    }
                };
                editor.setFont(label.getFont());
                editor.setEditable(true);
                editor.setBorder(BorderFactory.createLineBorder(Color.red));
                Double sb = (Double)FieldUtils.readField((Object)((Object)this), (String)"sb", (boolean)true);
                this.hb.setTransform(sb, 0.0, 0.0, sb, 0.0, 0.0);
                editor.setFont(editor.getFont().deriveFont(this.hb));
                if (v.b()) {
                    Font font = label.getFont();
                    font = new Font(font.getFontName(), font.getStyle(), (int)Math.ceil(sb * (double)font.getSize()));
                    editor.setFont(font);
                }
                editor.setCaretPosition(editor.getText().length());
                editor.selectAll();
                editor.putClientProperty("ylabel", label);
                editor.putClientProperty("pcl", listener);
                editor.putClientProperty("oldLabelText", str);
                editor.putClientProperty("commitValue", commitValue ? Boolean.TRUE : Boolean.FALSE);
                KeyAdapter localObject1 = new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent paramAnonymousKeyEvent) {
                        int i = NodeRealizer.z;
                        if (paramAnonymousKeyEvent.getKeyCode() == 10) {
                            if (singleLineMode) {
                                if (paramAnonymousKeyEvent.isControlDown() || paramAnonymousKeyEvent.isShiftDown()) {
                                    editor.insert("\n", editor.getCaretPosition());
                                    if (i == 0) {
                                        // empty if block
                                    }
                                } else {
                                    this.c(true);
                                    if (i == 0) {
                                        // empty if block
                                    }
                                }
                            } else if (paramAnonymousKeyEvent.isControlDown() || paramAnonymousKeyEvent.isShiftDown()) {
                                this.c(true);
                                if (i == 0) {
                                    // empty if block
                                }
                            }
                        } else if (paramAnonymousKeyEvent.getKeyCode() == 27) {
                            this.c(false);
                        }
                    }
                };
                editor.addKeyListener(localObject1);
                editor.addCaretListener(paramAnonymousCaretEvent -> editor.revalidate());
                ViewMode local4 = new ViewMode((ViewContainer)this.view){

                    public void mouseReleased(MouseEvent paramAnonymousMouseEvent) {
                        this.c(true);
                    }

                    public void mouseEntered(MouseEvent paramAnonymousMouseEvent) {
                    }
                };
                ArrayList localArrayList1 = new ArrayList(this.getViewModes());
                ArrayList<ViewMode> localArrayList2 = new ArrayList<ViewMode>();
                editor.putClientProperty("disabledViewModes", localArrayList2);
                for (ViewMode localViewMode : localArrayList1) {
                    this.removeViewMode(localViewMode);
                    localArrayList2.add(localViewMode);
                    if (i1 == 0 && i1 == 0) continue;
                }
                this.addViewMode(local4);
                editor.putClientProperty("activeViewMode", local4);
                editor.putClientProperty("yvl", local4);
                Point localObject2 = this.b(new Point2D.Double(x, y), null);
                editor.putClientProperty(t.c, center ? Boolean.TRUE : Boolean.FALSE);
                editor.putClientProperty(t.d, center ? localObject2 : new Point(((Point)localObject2).x, ((Point)localObject2).y - 2));
                editor.putClientProperty(t.b, null);
                this.setMb(666);
                System.out.println("Editor opened");
                this.ub = editor;
                this.add(this.ub);
                this.validate();
                editor.requestFocus();
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        void c(boolean paramBoolean) {
            try {
                int i2 = NodeRealizer.z;
                if (this.getMb() == 666) {
                    this.setMb(0);
                    JTextArea localJTextArea = this.ub;
                    if (localJTextArea != null) {
                        Object localObject2;
                        YLabel localYLabel = (YLabel)localJTextArea.getClientProperty("ylabel");
                        PropertyChangeListener localPropertyChangeListener = (PropertyChangeListener)localJTextArea.getClientProperty("pcl");
                        boolean i1 = Boolean.TRUE.equals(localJTextArea.getClientProperty("commitValue"));
                        System.out.println("Editor closed");
                        this.remove(localJTextArea);
                        this.ub = null;
                        ViewMode localViewMode = (ViewMode)localJTextArea.getClientProperty("activeViewMode");
                        List localList = (List)localJTextArea.getClientProperty("disabledViewModes");
                        if (localViewMode != null) {
                            this.removeViewMode(localViewMode);
                        }
                        if (localList != null) {
                            localObject2 = localList.iterator();
                            while (localObject2.hasNext()) {
                                this.addViewMode((ViewMode)((Iterator)localObject2).next());
                                if (i2 == 0 && i2 == 0) continue;
                            }
                        }
                        if (paramBoolean) {
                            localObject2 = (String)localJTextArea.getClientProperty("oldLabelText");
                            String str1 = localYLabel.getText();
                            String str2 = localJTextArea.getText();
                            if (str1.equals(localObject2) && !str2.equals(str1)) {
                                if (i1) {
                                    localYLabel.setText(str2);
                                    LabelEditGraph2DCanvas.b(localPropertyChangeListener, localYLabel, str1, localYLabel.getText());
                                    if (i2 == 0) {
                                        // empty if block
                                    }
                                } else {
                                    LabelEditGraph2DCanvas.b(localPropertyChangeListener, localYLabel, str1, str2);
                                }
                            }
                        }
                        this.validate();
                        this.updateView();
                    }
                    this.view.requestFocus();
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private static void b(PropertyChangeListener paramPropertyChangeListener, YLabel paramYLabel, String paramString1, String paramString2) {
            if (paramPropertyChangeListener != null) {
                paramPropertyChangeListener.propertyChange(new PropertyChangeEvent(paramYLabel, "text", paramString1, paramString2));
            }
        }
    }
}

