/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.painter;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.GraphUserData;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.view2d.painter.MainEntityPainterAnimatorRegistry;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Timer;
import y.base.Node;
import y.view.Graph2D;
import y.view.Graph2DView;
import y.view.NodeRealizer;

public class GraphAnimatorSettings {
    public static final int DURATION = 650;
    private static final int DELAY = 10;
    private final Map<EntityID, MainEntityPainterAnimatorRegistry.AnimatorSettings> _graphAnimatorSettingsMap = new HashMap<EntityID, MainEntityPainterAnimatorRegistry.AnimatorSettings>();
    private final Timer _timer;

    public static synchronized GraphAnimatorSettings getDefault(GraphID graphID) {
        String key;
        GraphUserData gud = GraphUserData.forGraph((GraphID)graphID);
        GraphAnimatorSettings settings = (GraphAnimatorSettings)gud.get((Object)(key = GraphAnimatorSettings.class.getName()));
        if (settings == null) {
            settings = new GraphAnimatorSettings(graphID);
            gud.put((Object)key, (Object)settings);
        }
        return settings;
    }

    protected GraphAnimatorSettings(GraphID graphID) {
        final GraphWrapper wrapper = MaltegoGraphManager.getWrapper((GraphID)graphID);
        final Graph2D graph2D = (Graph2D)wrapper.getGraph();
        this._timer = new Timer(10, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Map<EntityID, MainEntityPainterAnimatorRegistry.AnimatorSettings> entityAnimatorSettingsMap;
                if (wrapper != null && (entityAnimatorSettingsMap = GraphAnimatorSettings.this.getGraphAnimatorSettingsMap()) != null) {
                    for (Map.Entry<EntityID, MainEntityPainterAnimatorRegistry.AnimatorSettings> entrySet : entityAnimatorSettingsMap.entrySet()) {
                        EntityID entityID;
                        Node node;
                        MainEntityPainterAnimatorRegistry.AnimatorSettings entityAnimatorSettings = entrySet.getValue();
                        if (entityAnimatorSettings == null || !entityAnimatorSettings.isAnimatorRunning()) continue;
                        if (System.currentTimeMillis() > entityAnimatorSettings.getEndMillis()) {
                            entityAnimatorSettings.stopAnimator();
                        }
                        if ((node = wrapper.node(entityID = entrySet.getKey())) == null) continue;
                        NodeRealizer nr = graph2D.getRealizer(node);
                        Graph2DView view = (Graph2DView)graph2D.getCurrentView();
                        if (nr == null || view.getZoom() < 0.1) continue;
                        nr.repaint();
                    }
                    if (entityAnimatorSettingsMap.isEmpty()) {
                        GraphAnimatorSettings.this.stopTimer();
                    } else if (!GraphAnimatorSettings.this.isTimerRunning()) {
                        GraphAnimatorSettings.this.restartTimer();
                    }
                }
            }
        });
        this._timer.setRepeats(true);
        this._timer.start();
    }

    public void restartTimer() {
        this._timer.restart();
    }

    public void stopTimer() {
        this._timer.stop();
    }

    public boolean isTimerRunning() {
        return this._timer.isRunning();
    }

    public Map<EntityID, MainEntityPainterAnimatorRegistry.AnimatorSettings> getGraphAnimatorSettingsMap() {
        return this._graphAnimatorSettingsMap;
    }

    static {
        GraphLifeCycleManager.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String key;
                GraphAnimatorSettings settings;
                GraphUserData gud;
                GraphID graphID = (GraphID)evt.getNewValue();
                if ("graphClosing".equals(evt.getPropertyName()) && (gud = GraphUserData.forGraph((GraphID)graphID, (boolean)false)) != null && (settings = (GraphAnimatorSettings)gud.get((Object)(key = GraphAnimatorSettings.class.getName()))) != null) {
                    settings.stopTimer();
                }
            }
        });
    }
}

