/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.painter;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.view2d.EntityRealizerInflaterRegistry;
import com.paterva.maltego.ui.graph.view2d.LightweightEntityRealizer;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPaintContext;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainter;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainterButton;
import com.paterva.maltego.util.ui.GraphicsUtils;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Collection;
import javax.swing.JComponent;
import org.openide.util.Exceptions;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.Graph2DView;
import y.view.NodeRealizer;

public abstract class AbstractEntityPainter
implements EntityPainter {
    public static final String LIST_VIEW_NAME = "ListView";
    private final String _name;
    private final String _displayName;
    private final String _icon;
    private final int _priority;
    private final EntityPaintContext _context = new EntityPaintContext();
    private double _zoom;
    private boolean _optimizationsEnabled = true;

    public AbstractEntityPainter(String name, String displayName, String icon, int priority) {
        this._name = name;
        this._displayName = displayName;
        this._icon = icon;
        this._priority = priority;
    }

    public abstract void paint(Graphics2D var1, EntityPaintContext var2) throws Exception;

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getDisplayName() {
        return this._displayName;
    }

    @Override
    public int getPriority() {
        return this._priority;
    }

    @Override
    public String getIcon() {
        return this._icon;
    }

    @Override
    public JComponent createToolbarComponent(GraphID graphID) {
        return new EntityPainterButton(this, graphID);
    }

    @Override
    public void update(LightweightEntityRealizer realizer, boolean isInitialUpdate) {
        if (realizer.isInflated() && realizer.labelCount() <= 1) {
            realizer.removeAllLabels();
            this.createLabels(realizer);
            realizer.updateLabels();
        }
        if (realizer.isSizeDirty()) {
            this.updateSize(realizer);
            realizer.setSizeDirty(false);
        }
    }

    @Override
    public void paint(Graphics2D g2D, LightweightEntityRealizer realizer) throws Exception {
        this.onEntityPaintStart(realizer, g2D);
        this.paint(g2D, this._context);
        this.onEntityPaintEnd(realizer, g2D);
    }

    protected double getZoom() {
        return this._zoom;
    }

    protected void onEntityPaintStart(LightweightEntityRealizer realizer, Graphics2D g2D) {
        g2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this._context.setRealizer(realizer);
        this._zoom = GraphicsUtils.getZoom((Graphics2D)g2D);
    }

    protected void onEntityPaintEnd(LightweightEntityRealizer realizer, Graphics2D g2D) {
        g2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        this._context.clear();
    }

    @Override
    public void onGraphPaintStart(GraphID graphID, Collection<NodeRealizer> nodeRealizersToPaint, Collection<EdgeRealizer> edgeRealizersToPaint) {
        Graph2D graph = (Graph2D)MaltegoGraphManager.getWrapper((GraphID)graphID).getGraph();
        Graph2DView view = (Graph2DView)graph.getCurrentView();
        boolean sloppy = view.getZoom() <= view.getPaintDetailThreshold();
        for (NodeRealizer r : nodeRealizersToPaint) {
            if (!(r instanceof LightweightEntityRealizer)) continue;
            LightweightEntityRealizer realizer = (LightweightEntityRealizer)r;
            if (!sloppy) {
                try {
                    EntityRealizerInflaterRegistry.getDefault().getOrCreateInflater(graphID).inflate(realizer);
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            this.update(realizer, false);
        }
    }

    @Override
    public void onGraphPaintEnd(GraphID graphID) {
    }

    @Override
    public void setOptimizationsEnabled(boolean optimizationsEnabled) {
        this._optimizationsEnabled = optimizationsEnabled;
    }

    @Override
    public boolean isOptimizationsEnabled() {
        return this._optimizationsEnabled;
    }
}

