/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import y.base.DataProvider;
import y.base.Graph;
import y.base.Node;
import y.base.NodeMap;
import y.layout.CopiedLayoutGraph;
import y.layout.LayoutGraph;
import y.layout.Layouter;

public abstract class SmartLayouter
implements Layouter {
    private Layouter _coreLayouter;
    private LayoutGraph _layoutGraph;
    private Graph _originalGraph;
    private List<CopiedLayoutGraph> _layoutGraphs;

    public void setCoreLayouter(Layouter layouter) {
        this._coreLayouter = layouter;
    }

    public Layouter getCoreLayouter() {
        return this._coreLayouter;
    }

    protected LayoutGraph getLayoutGraph() {
        return this._layoutGraph;
    }

    protected Graph getOriginalGraph() {
        return this._originalGraph;
    }

    protected List<CopiedLayoutGraph> getLayoutGraphHierarchy() {
        return Collections.unmodifiableList(this._layoutGraphs);
    }

    protected void initialize(LayoutGraph currentGraph) {
        this._layoutGraph = currentGraph;
        this._originalGraph = currentGraph;
        this._layoutGraphs = new ArrayList<CopiedLayoutGraph>();
        while (this._originalGraph instanceof CopiedLayoutGraph) {
            CopiedLayoutGraph copiedGraph = (CopiedLayoutGraph)this._originalGraph;
            this._layoutGraphs.add(copiedGraph);
            this._originalGraph = (Graph)copiedGraph.getOriginalGraph();
        }
    }

    protected void uninitialize() {
        this._layoutGraph = null;
        this._originalGraph = null;
        this._layoutGraphs = null;
    }

    protected void disposeNodeMap(LayoutGraph graph, Object key) {
        DataProvider provider = graph.getDataProvider(key);
        if (provider instanceof NodeMap) {
            graph.disposeNodeMap((NodeMap)provider);
        }
        graph.removeDataProvider(key);
    }

    protected Node getOriginalNode(Node layoutNode) {
        Node originalNode = layoutNode;
        for (CopiedLayoutGraph copiedGraph : this.getLayoutGraphHierarchy()) {
            originalNode = (Node)copiedGraph.getOriginalNode(originalNode);
        }
        return originalNode;
    }

    protected Node getLayoutNode(Node originalNode) {
        List<CopiedLayoutGraph> layoutGraphs = this.getLayoutGraphHierarchy();
        for (int i = layoutGraphs.size() - 1; i >= 0; --i) {
            originalNode = layoutGraphs.get(i).getCopiedNode((Object)originalNode);
        }
        return originalNode;
    }
}

