/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.layout;

import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import y.base.DataProvider;
import y.base.Node;
import y.base.NodeCursor;
import y.layout.LayoutGraph;
import y.layout.Layouter;

public class PreventDriftLayouter
implements Layouter {
    private Layouter _coreLayouter;
    private Object _nodeProviderKey;

    public void setNodeProviderKey(Object nodeProviderKey) {
        this._nodeProviderKey = nodeProviderKey;
    }

    public boolean canLayout(LayoutGraph lg) {
        return true;
    }

    public void doLayout(LayoutGraph lg) {
        HashMap<Node, Point2D.Double> points = new HashMap<Node, Point2D.Double>();
        NodeCursor nodes = lg.nodes();
        while (nodes.ok()) {
            Node node = nodes.node();
            if (this.isValid(lg, node)) {
                Point2D.Double point = new Point2D.Double(lg.getX(node), lg.getY(node));
                points.put(node, point);
            }
            nodes.next();
        }
        if (this._coreLayouter != null && this._coreLayouter.canLayout(lg)) {
            this._coreLayouter.doLayout(lg);
        }
        if (!points.isEmpty()) {
            double xDrift = 0.0;
            double yDrift = 0.0;
            boolean drifted = true;
            boolean isFirst = true;
            double shiftLimit = 50.0;
            for (Map.Entry entry : points.entrySet()) {
                Node node = (Node)entry.getKey();
                Point2D.Double point = (Point2D.Double)entry.getValue();
                if (isFirst) {
                    xDrift = lg.getX(node) - point.x;
                    yDrift = lg.getY(node) - point.y;
                    isFirst = false;
                    continue;
                }
                double xShift = lg.getX(node) - point.x;
                double yShift = lg.getY(node) - point.y;
                if (!(Math.abs(xDrift - xShift) > 50.0) && !(Math.abs(yDrift - yShift) > 50.0)) continue;
                drifted = false;
                break;
            }
            if (drifted) {
                this.adjustNodeLocations(lg, -xDrift, -yDrift);
            }
        }
    }

    private void adjustNodeLocations(LayoutGraph lg, double xAdjustment, double yAdjustment) {
        NodeCursor nodes = lg.nodes();
        while (nodes.ok()) {
            Node node = nodes.node();
            if (this.isValid(lg, node)) {
                lg.setLocation(node, lg.getX(node) + xAdjustment, lg.getY(node) + yAdjustment);
            }
            nodes.next();
        }
    }

    private boolean isValid(LayoutGraph lg, Node node) {
        DataProvider dataProvider;
        if (this._nodeProviderKey != null && (dataProvider = lg.getDataProvider(this._nodeProviderKey)) != null) {
            return dataProvider.getBool((Object)node);
        }
        return true;
    }

    public void setCoreLayouter(Layouter layouter) {
        this._coreLayouter = layouter;
    }
}

