/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.layout;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.Node;
import y.base.NodeCursor;
import y.geom.YPoint;
import y.geom.YPointCursor;
import y.geom.YPointPath;
import y.layout.CopiedLayoutGraph;
import y.layout.LayoutGraph;
import y.layout.Layouter;
import y.view.Graph2D;
import y.view.Graph2DView;

public class MinimizeVisibleEntityMovementLayouter
implements Layouter {
    private Layouter _coreLayouter;
    private Map<Node, YPoint> _beforeCenters;
    private Map<Node, Double> _weights;
    private static final boolean DEBUG = false;

    public MinimizeVisibleEntityMovementLayouter(Graph2DView view) {
        this.initialize(view);
    }

    private void initialize(Graph2DView view) {
        this._beforeCenters = this.getCentersOfVisibleNodes(view);
        this._weights = this.getWeights(view, this._beforeCenters);
        if (this._beforeCenters.isEmpty() && view.getGraph2D().nodeCount() > 0) {
            Graph2D graph2D = view.getGraph2D();
            Node node = graph2D.firstNode();
            this._beforeCenters.put(node, graph2D.getCenter(node));
            this._weights.put(node, 1.0);
        }
    }

    public void setCoreLayouter(Layouter layouter) {
        this._coreLayouter = layouter;
    }

    public boolean canLayout(LayoutGraph lg) {
        return true;
    }

    public void doLayout(LayoutGraph lg) {
        if (this._coreLayouter != null && this._coreLayouter.canLayout(lg)) {
            this._coreLayouter.doLayout(lg);
        }
        if (lg instanceof CopiedLayoutGraph && !this._beforeCenters.isEmpty()) {
            CopiedLayoutGraph copiedGraph = (CopiedLayoutGraph)lg;
            double totalWeight = 0.0;
            double xDiff = 0.0;
            double yDiff = 0.0;
            for (Map.Entry<Node, YPoint> entry : this._beforeCenters.entrySet()) {
                Node node = entry.getKey();
                Node copiedNode = copiedGraph.getCopiedNode((Object)node);
                if (copiedNode == null) continue;
                YPoint centerBefore = entry.getValue();
                YPoint centerAfter = lg.getCenter(copiedNode);
                double weight = this._weights.get(node);
                xDiff += (centerBefore.x - centerAfter.x) * weight;
                yDiff += (centerBefore.y - centerAfter.y) * weight;
                totalWeight += weight;
            }
            if (totalWeight != 0.0) {
                xDiff /= totalWeight;
                yDiff /= totalWeight;
            }
            this.adjustNodeLocations(lg, xDiff, yDiff);
            this.adjustBendLocations(lg, xDiff, yDiff);
        }
    }

    private Map<Node, YPoint> getCentersOfVisibleNodes(Graph2DView view) {
        Graph2D graph2D = view.getGraph2D();
        Rectangle visibleRect = view.getVisibleRect();
        HashMap<Node, YPoint> centers = new HashMap<Node, YPoint>();
        NodeCursor nodes = graph2D.nodes();
        while (nodes.ok()) {
            Node node = nodes.node();
            YPoint center = graph2D.getCenter(node);
            if (visibleRect.contains(new Point2D.Double(center.x, center.y))) {
                centers.put(node, center);
            }
            nodes.next();
        }
        return centers;
    }

    private Map<Node, Double> getWeights(Graph2DView view, Map<Node, YPoint> centers) {
        Graph2D graph2D = view.getGraph2D();
        Rectangle worldRect = view.getWorldRect();
        double worldCenterX = worldRect.getX() + worldRect.getWidth() / 2.0;
        double worldCenterY = worldRect.getY() + worldRect.getHeight() / 2.0;
        HashMap<Node, Double> weights = new HashMap<Node, Double>();
        for (Map.Entry<Node, YPoint> entry : centers.entrySet()) {
            Node node = entry.getKey();
            YPoint center = entry.getValue();
            double weight = 1.0 / (1.0 + Math.abs(center.x - worldCenterX) + Math.abs(center.y - worldCenterY));
            if (graph2D.isSelected(node)) {
                weight += 1.0;
            }
            weights.put(node, weight);
        }
        return weights;
    }

    private void adjustNodeLocations(LayoutGraph lg, double xAdjustment, double yAdjustment) {
        NodeCursor nodes = lg.nodes();
        while (nodes.ok()) {
            Node node = nodes.node();
            lg.setLocation(node, lg.getX(node) + xAdjustment, lg.getY(node) + yAdjustment);
            nodes.next();
        }
    }

    private void adjustBendLocations(LayoutGraph lg, double xAdjustment, double yAdjustment) {
        EdgeCursor edges = lg.edges();
        while (edges.ok()) {
            Edge edge = edges.edge();
            YPointPath path = lg.getPath(edge);
            YPointCursor points = path.points();
            YPoint[] newPath = new YPoint[path.length()];
            int count = 0;
            while (points.ok()) {
                YPoint point = points.point();
                newPath[count] = count == 0 || count == path.length() - 1 ? point : point.moveBy(xAdjustment, yAdjustment);
                ++count;
                points.next();
            }
            lg.setPath(edge, new YPointPath(newPath));
            edges.next();
        }
    }

    private String format(YPoint point) {
        return this.format(point.x) + "," + this.format(point.y);
    }

    private String format(double value) {
        return String.format("%10.5f", value);
    }

    private String fixLengthStr(Object obj, int length) {
        String tmp = obj.toString();
        while (tmp.length() < length) {
            tmp = tmp + " ";
        }
        return tmp.substring(0, length);
    }
}

