/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.layout;

import java.util.Comparator;
import y.base.DataProvider;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.layout.LayoutGraph;
import y.layout.Layouter;

public class MatrixLayouter
implements Layouter {
    private int _rowSpacing = 10;
    private int _colSpacing = 10;

    public void doLayout(LayoutGraph graph) {
        int maxPerRow = (int)Math.sqrt(graph.nodeCount()) + 1;
        double[] maxColWidth = new double[maxPerRow];
        double maxRowHeight = 0.0;
        NodeList nodes = this.getLayoutNodes(graph);
        int col = 0;
        int row = 0;
        NodeCursor nc = this.getNodeCursor(graph, nodes);
        while (nc.ok()) {
            Node node = nc.node();
            maxRowHeight = Math.max(graph.getHeight(node), maxRowHeight);
            maxColWidth[col] = Math.max(graph.getWidth(node), maxColWidth[col]);
            if (col >= maxPerRow - 1) {
                col = 0;
                ++row;
            } else {
                ++col;
            }
            nc.next();
        }
        double[] colCenter = new double[maxPerRow];
        double prevColWidth = 0.0;
        for (int i = 0; i < maxPerRow; ++i) {
            colCenter[i] = prevColWidth + maxColWidth[i] / 2.0;
            prevColWidth += maxColWidth[i] + (double)this._colSpacing;
        }
        col = 0;
        row = 0;
        NodeCursor nc2 = this.getNodeCursor(graph, nodes);
        while (nc2.ok()) {
            Node node = nc2.node();
            double x = colCenter[col];
            double y = maxRowHeight / 2.0 + ((double)this._rowSpacing + maxRowHeight) * (double)row;
            graph.setCenter(node, x, y);
            if (col >= maxPerRow - 1) {
                col = 0;
                ++row;
            } else {
                ++col;
            }
            nc2.next();
        }
    }

    protected NodeCursor getNodeCursor(LayoutGraph graph, NodeList nodes) {
        if (nodes == null) {
            return graph.nodes();
        }
        return nodes.nodes();
    }

    protected NodeList getLayoutNodes(LayoutGraph graph) {
        final DataProvider idProvider = graph.getDataProvider((Object)"nodeOrder");
        NodeList nodes = new NodeList(graph.nodes());
        if (idProvider != null) {
            nodes.sort((Comparator)new Comparator<Node>(){

                @Override
                public int compare(Node o1, Node o2) {
                    return idProvider.getInt((Object)o1) - idProvider.getInt((Object)o2);
                }
            });
        }
        return nodes;
    }

    public int getRowSpacing() {
        return this._rowSpacing;
    }

    public void setRowSpacing(int rowSpacing) {
        this._rowSpacing = rowSpacing;
    }

    public int getColSpacing() {
        return this._colSpacing;
    }

    public void setColSpacing(int colSpacing) {
        this._colSpacing = colSpacing;
    }

    public boolean canLayout(LayoutGraph lg) {
        return true;
    }
}

