/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.layout;

import com.paterva.maltego.ui.graph.view2d.layout.FastHierarchicLayouter;
import com.paterva.maltego.ui.graph.view2d.layout.MaltegoHierarchicLayouter;
import com.paterva.maltego.ui.graph.view2d.layout.MatrixLayouter;
import com.paterva.maltego.ui.graph.view2d.layout.SmartLayouter;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.layout.EdgeLayout;
import y.layout.LayoutGraph;
import y.layout.LayoutMultiplexer;
import y.layout.Layouter;
import y.layout.grouping.Grouping;
import y.layout.grouping.RecursiveGroupLayouter;
import y.layout.hierarchic.IncrementalHierarchicLayouter;

public class MaltegoLayouter
extends SmartLayouter {
    private static final Logger LOG = Logger.getLogger(MaltegoLayouter.class.getName());
    private Set<Node> _newNodes = Collections.EMPTY_SET;
    private Set<Node> _leafNodes;
    private boolean _incremental = false;

    public boolean canLayout(LayoutGraph lg) {
        return true;
    }

    public void setIncremental(boolean incremental) {
        this._incremental = incremental;
    }

    public void setNewNodes(Set<Node> newNodes) {
        this._newNodes = new HashSet<Node>(newNodes);
        this.expandNewNodesToParents();
    }

    @Override
    protected void initialize(LayoutGraph currentGraph) {
        super.initialize(currentGraph);
        this._leafNodes = new HashSet<Node>();
        NodeCursor nc = this.getLayoutGraph().nodes();
        while (nc.ok()) {
            Node layoutNode = nc.node();
            Node originalNode = this.getOriginalNode(layoutNode);
            if (MaltegoLayouter.isLeefNode(originalNode)) {
                this._leafNodes.add(layoutNode);
            }
            nc.next();
        }
    }

    private void configureGroups(Layouter outer, Layouter inner) {
        LayoutGraph layoutGraph = this.getLayoutGraph();
        NodeMap nodeId = layoutGraph.createNodeMap();
        NodeMap parentNodeId = layoutGraph.createNodeMap();
        NodeMap groupKey = layoutGraph.createNodeMap();
        NodeMap layoutMap = layoutGraph.createNodeMap();
        layoutGraph.addDataProvider(Grouping.NODE_ID_DPKEY, (DataProvider)nodeId);
        layoutGraph.addDataProvider(Grouping.PARENT_NODE_ID_DPKEY, (DataProvider)parentNodeId);
        layoutGraph.addDataProvider(Grouping.GROUP_DPKEY, (DataProvider)groupKey);
        layoutGraph.addDataProvider(LayoutMultiplexer.LAYOUTER_DPKEY, (DataProvider)layoutMap);
        LinkedHashMap<Node, NodeList> leafNodeMap = new LinkedHashMap<Node, NodeList>();
        int index = 0;
        NodeCursor nc = layoutGraph.nodes();
        while (nc.ok()) {
            Node layoutNode = nc.node();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Node: {0}", layoutNode);
                LOG.log(Level.FINE, "Original node: {0}", this.getOriginalNode(layoutNode));
            }
            if (this._leafNodes.contains(layoutNode)) {
                LOG.log(Level.FINE, "Leaf=YES");
                Node originalNode = this.getOriginalNode(layoutNode);
                Node parent = originalNode.firstInEdge().source();
                LOG.log(Level.FINE, "Parent: {0}", parent);
                parent = this.getLayoutNode(parent);
                NodeList leafNodes = (NodeList)leafNodeMap.get(parent);
                if (leafNodes == null) {
                    leafNodes = new NodeList();
                    leafNodeMap.put(parent, leafNodes);
                }
                leafNodes.add((Object)layoutNode);
                layoutMap.set((Object)layoutNode, (Object)inner);
            } else {
                LOG.log(Level.FINE, "Leaf=NO");
                layoutMap.set((Object)layoutNode, (Object)outer);
            }
            LOG.log(Level.FINE, "Index: {0}\n", index);
            nodeId.set((Object)layoutNode, (Object)index++);
            nc.next();
        }
        int groupIndex = 0x3FFFFFFF;
        for (NodeList list : leafNodeMap.values()) {
            Node groupNode = layoutGraph.createNode();
            groupKey.setBool((Object)groupNode, true);
            nodeId.set((Object)groupNode, (Object)groupIndex);
            NodeCursor nc2 = list.nodes();
            while (nc2.ok()) {
                Node node = nc2.node();
                parentNodeId.set((Object)node, (Object)groupIndex);
                nc2.next();
            }
            if (this._incremental) {
                this._newNodes.add(groupNode);
            }
            ++groupIndex;
        }
    }

    private void logWarning(String msg) {
        this.getLogger().log(Level.WARNING, msg);
    }

    private Logger getLogger() {
        return Logger.getLogger(MaltegoLayouter.class.getName());
    }

    private void restoreGroups(LayoutGraph graph) {
        NodeCursor nodes = graph.nodes();
        if (nodes == null) {
            this.logWarning("LayoutGraph.nodes() returned null.");
        } else {
            DataProvider dataProvider = graph.getDataProvider(Grouping.GROUP_DPKEY);
            if (dataProvider == null) {
                this.logWarning("GROUP_DPKEY data provider is null.");
            } else {
                NodeList groups = new NodeList(nodes, dataProvider);
                NodeCursor nc = groups.nodes();
                while (nc.ok()) {
                    graph.removeNode(nc.node());
                    nc.next();
                }
            }
        }
        this.disposeNodeMap(graph, Grouping.NODE_ID_DPKEY);
        this.disposeNodeMap(graph, Grouping.PARENT_NODE_ID_DPKEY);
        this.disposeNodeMap(graph, Grouping.GROUP_DPKEY);
        this.disposeNodeMap(graph, LayoutMultiplexer.LAYOUTER_DPKEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLayout(LayoutGraph graph) {
        LOG.fine("Layout Start");
        try {
            Object outerLayouter;
            if (LOG.isLoggable(Level.FINE)) {
                NodeCursor nc = graph.nodes();
                while (nc.ok()) {
                    Node node = nc.node();
                    LOG.log(Level.FINE, "{0}", node);
                    nc.next();
                }
            }
            this.initialize(graph);
            if (this._incremental) {
                IncrementalHierarchicLayouter ihl = new IncrementalHierarchicLayouter();
                ihl.setMinimumLayerDistance(60.0);
                ihl.setLayoutMode((byte)0);
                MaltegoHierarchicLayouter mhl = new MaltegoHierarchicLayouter(this._newNodes);
                mhl.setCoreLayouter((Layouter)ihl);
                outerLayouter = mhl;
            } else {
                FastHierarchicLayouter hierarchicLayouter = new FastHierarchicLayouter();
                hierarchicLayouter.setMinimalFirstSegmentLength(60.0);
                outerLayouter = hierarchicLayouter;
            }
            try {
                this.configureGroups((Layouter)outerLayouter, new MatrixLayouter());
                LayoutMultiplexer lm = new LayoutMultiplexer();
                RecursiveGroupLayouter rgl = new RecursiveGroupLayouter((Layouter)lm);
                rgl.doLayout(graph);
                this.repositionEdges();
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                this.restoreGroups(graph);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            this._leafNodes = null;
        }
        LOG.fine("Layout End");
    }

    private void repositionEdges() {
        LayoutGraph layoutGraph = this.getLayoutGraph();
        NodeCursor nc = layoutGraph.nodes();
        while (nc.ok()) {
            Edge edge;
            Node layoutNode = nc.node();
            if (this._leafNodes.contains(layoutNode) && (edge = layoutNode.firstInEdge()) != null) {
                EdgeLayout layout = layoutGraph.getLayout(edge);
                layout.clearPoints();
                layoutGraph.setSourcePointAbs(edge, layoutGraph.getCenter(edge.source()));
                layoutGraph.setTargetPointAbs(edge, layoutGraph.getCenter(layoutNode));
            }
            nc.next();
        }
    }

    private static boolean isLeefNode(Node node) {
        return node.outDegree() == 0 && node.inDegree() == 1;
    }

    private void expandNewNodesToParents() {
        HashSet<Node> parents = new HashSet<Node>();
        for (Node node : this._newNodes) {
            if (node.inDegree() <= 0) continue;
            EdgeCursor edges = node.inEdges();
            while (edges.ok()) {
                parents.add(edges.edge().source());
                edges.next();
            }
        }
        this._newNodes.addAll(parents);
    }

    private NodeList getSortedNodes(LayoutGraph graph) {
        final DataProvider idProvider = graph.getDataProvider((Object)"nodeOrder");
        NodeList nodes = new NodeList(graph.nodes());
        nodes.sort((Comparator)new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                int o1Int = idProvider.getInt((Object)o1);
                LOG.log(Level.FINE, "{0}->{1}", new Object[]{o1Int, MaltegoLayouter.this.getOriginalNode(o1)});
                int o2Int = idProvider.getInt((Object)o2);
                LOG.log(Level.FINE, "{0}->{1}", new Object[]{o2Int, MaltegoLayouter.this.getOriginalNode(o2)});
                return o1Int - o2Int;
            }
        });
        return nodes;
    }
}

