/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.layout;

import com.paterva.maltego.util.StringUtilities;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.GraphInterface;
import y.base.Node;
import y.base.NodeCursor;
import y.base.YList;
import y.geom.YPoint;
import y.geom.YRectangle;
import y.layout.AbstractLayoutStage;
import y.layout.CopiedLayoutGraph;
import y.layout.EdgeLabelLayout;
import y.layout.EdgeLabelModel;
import y.layout.EdgeLayout;
import y.layout.LabelCandidate;
import y.layout.LabelLayout;
import y.layout.LayoutGraph;
import y.layout.NodeLabelLayout;
import y.layout.NodeLabelModel;
import y.layout.NodeLayout;
import y.view.EdgeLabel;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.NodeLabel;
import y.view.NodeRealizer;
import y.view.YLabel;

public class MaltegoLabelLayouter
extends AbstractLayoutStage {
    private static final Logger LOG = Logger.getLogger(MaltegoLabelLayouter.class.getName());
    private int _collisionChecksNode;
    private int _collisionChecksLabel;
    private int _collisionChecksEdge;
    private long _time;
    private Map<LabelLayout, LabelCandidate> _newLabelLocations;

    public boolean canLayout(LayoutGraph lg) {
        return true;
    }

    public void doLayout(LayoutGraph lg) {
        try {
            this.doLayoutCore(lg);
            this._collisionChecksNode = 0;
            this._collisionChecksLabel = 0;
            this._collisionChecksEdge = 0;
            this._time = System.currentTimeMillis();
            this._newLabelLocations = new HashMap<LabelLayout, LabelCandidate>();
            NodeCursor nodes = lg.nodes();
            LOG.log(Level.FINE, "Node count: {0}", nodes.size());
            while (nodes.ok()) {
                Node node = nodes.node();
                this.layoutLabel(lg, node, 4);
                nodes.next();
            }
            EdgeCursor edges = lg.edges();
            LOG.log(Level.FINE, "Edge count: {0}", edges.size());
            while (edges.ok()) {
                Edge edge = edges.edge();
                this.layoutLabel(lg, edge);
                edges.next();
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Notes label layout speed = {0}ms", System.currentTimeMillis() - this._time);
                LOG.log(Level.FINE, "Notes label layout collission checks:");
                LOG.log(Level.FINE, "   node = {0}", this._collisionChecksNode);
                LOG.log(Level.FINE, "   label = {0}", this._collisionChecksLabel);
                LOG.log(Level.FINE, "   edge = {0}", this._collisionChecksEdge);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void layoutLabel(LayoutGraph lg, Node node, int index) {
        YLabel originalLabel = this.getOriginalLabel((GraphInterface)lg, node, index);
        if (originalLabel != null) {
            NodeLabelLayout labelLayout;
            LabelCandidate bestCandidate;
            NodeLabelLayout[] labelLayouts;
            boolean visible = originalLabel.isVisible();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "node1 = {0}", this.getOriginalNode((GraphInterface)lg, node));
                LOG.log(Level.FINE, "   originalLabel = {0} ({1})", new Object[]{originalLabel, visible ? "visible" : "not visible"});
            }
            if (visible && (labelLayouts = lg.getLabelLayout(node)).length > index && (bestCandidate = this.getBestCandidate(lg, node, labelLayout = labelLayouts[index])) != null && !bestCandidate.getModelParameter().equals(labelLayout.getModelParameter())) {
                bestCandidate.propagate();
                this._newLabelLocations.put((LabelLayout)labelLayout, bestCandidate);
            }
        }
    }

    private void layoutLabel(LayoutGraph lg, Edge edge) {
        YLabel originalLabel;
        EdgeLabelLayout[] labelLayouts = lg.getLabelLayout(edge);
        if (labelLayouts != null && labelLayouts.length > 0 && (originalLabel = this.getOriginalLabel((GraphInterface)lg, edge)) != null && originalLabel.isVisible() && !StringUtilities.isNullOrEmpty((String)originalLabel.getText())) {
            EdgeLabelLayout labelLayout;
            LabelCandidate bestCandidate;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "edge1 = \"{0}\"", this.getOriginalEdge((GraphInterface)lg, edge));
                LOG.log(Level.FINE, "   originalLabel = {0}", originalLabel);
            }
            if ((bestCandidate = this.getBestCandidate(lg, edge, labelLayout = lg.getLabelLayout(edge)[0])) != null && !bestCandidate.getModelParameter().equals(labelLayout.getModelParameter())) {
                bestCandidate.propagate();
                this._newLabelLocations.put((LabelLayout)labelLayout, bestCandidate);
            }
        }
    }

    private LabelCandidate getBestCandidate(LayoutGraph lg, Node node, NodeLabelLayout labelLayout) {
        NodeLabelModel labelModel = labelLayout.getLabelModel();
        YList labelCandidates = labelModel.getLabelCandidates(labelLayout, lg.getNodeLayout((Object)node));
        Object defaultParameter = labelLayout.getLabelModel().getDefaultParameter();
        return this.getBestCandidate(lg, labelCandidates, (LabelLayout)labelLayout, defaultParameter, node);
    }

    private LabelCandidate getBestCandidate(LayoutGraph lg, Edge edge, EdgeLabelLayout labelLayout) {
        EdgeLabelModel labelModel = labelLayout.getLabelModel();
        EdgeLayout edgeLayout = lg.getEdgeLayout((Object)edge);
        NodeLayout sourceNodeLayout = lg.getNodeLayout((Object)edge.source());
        NodeLayout targetNodeLayout = lg.getNodeLayout((Object)edge.target());
        YList labelCandidates = labelModel.getLabelCandidates(labelLayout, edgeLayout, sourceNodeLayout, targetNodeLayout);
        Object defaultParameter = labelLayout.getLabelModel().getDefaultParameter();
        return this.getBestCandidate(lg, labelCandidates, (LabelLayout)labelLayout, defaultParameter, edge);
    }

    private LabelCandidate getBestCandidate(LayoutGraph lg, YList labelCandidates, LabelLayout labelLayout, Object defaultParameter, Object ignore) {
        LabelCandidate labelCandidate;
        double totalIntersectionArea;
        double minIntersectionArea = Double.MAX_VALUE;
        LabelCandidate bestCandidate = null;
        Object currentModelParameter = labelLayout.getModelParameter();
        LabelCandidate current = null;
        for (Object obj : labelCandidates) {
            LabelCandidate labelCandidate2;
            Object modelParameter;
            if (!(obj instanceof LabelCandidate) || !(modelParameter = (labelCandidate2 = (LabelCandidate)obj).getModelParameter()).equals(currentModelParameter)) continue;
            current = labelCandidate2;
            minIntersectionArea = totalIntersectionArea = this.getTotalIntersectionArea(labelCandidate2, lg, ignore, minIntersectionArea);
            bestCandidate = labelCandidate2;
            if (!(minIntersectionArea < 1.0)) break;
            LOG.fine("   Current position is best");
            return bestCandidate;
        }
        if (current != null) {
            labelCandidates.remove(current);
        }
        LabelCandidate defaultCandidate = null;
        for (Object obj : labelCandidates) {
            Object modelParameter;
            if (!(obj instanceof LabelCandidate) || !defaultParameter.equals(modelParameter = (labelCandidate = (LabelCandidate)obj).getModelParameter())) continue;
            defaultCandidate = labelCandidate;
            double totalIntersectionArea2 = this.getTotalIntersectionArea(labelCandidate, lg, ignore, minIntersectionArea);
            if (bestCandidate != null && !(totalIntersectionArea2 < minIntersectionArea)) continue;
            minIntersectionArea = totalIntersectionArea2;
            bestCandidate = labelCandidate;
            if (!(minIntersectionArea < 1.0)) continue;
            LOG.fine("   Default position is best");
            return bestCandidate;
        }
        if (defaultCandidate != null) {
            labelCandidates.remove(defaultCandidate);
        }
        for (Object obj : labelCandidates) {
            if (!(obj instanceof LabelCandidate)) continue;
            labelCandidate = (LabelCandidate)obj;
            totalIntersectionArea = this.getTotalIntersectionArea(labelCandidate, lg, ignore, minIntersectionArea);
            if (bestCandidate != null && !(totalIntersectionArea < minIntersectionArea)) continue;
            minIntersectionArea = totalIntersectionArea;
            bestCandidate = labelCandidate;
            if (!(minIntersectionArea < 1.0)) continue;
            LOG.log(Level.FINE, "   Best candidate: {0}", bestCandidate);
            return bestCandidate;
        }
        return bestCandidate;
    }

    private double getTotalIntersectionArea(LabelCandidate labelCandidate, LayoutGraph lg, Object ignore, double stopIfOver) {
        LOG.log(Level.FINE, "   labelCandidate = {0}", labelCandidate);
        YRectangle labelBoundingBox = labelCandidate.getBoundingBox();
        double totalIntersectionArea = 0.0;
        totalIntersectionArea += this.getNodesIntersectionArea(lg, ignore, labelBoundingBox, stopIfOver - totalIntersectionArea);
        if (totalIntersectionArea < stopIfOver && (totalIntersectionArea += this.getEdgeLabelIntersectionArea(lg, ignore, labelBoundingBox, stopIfOver - totalIntersectionArea)) < stopIfOver && (totalIntersectionArea += this.getEdgeIntersectionArea(lg, ignore, labelBoundingBox, stopIfOver - totalIntersectionArea)) < stopIfOver && (totalIntersectionArea += this.getNodeLabelIntersectionArea(lg, ignore, labelBoundingBox, 4, stopIfOver - totalIntersectionArea)) < stopIfOver) {
            totalIntersectionArea += this.getNodeLabelIntersectionArea(lg, ignore, labelBoundingBox, 0, stopIfOver - totalIntersectionArea);
        }
        LOG.log(Level.FINE, "   stopIfOver = {0}", stopIfOver);
        LOG.log(Level.FINE, "   totalIntersectionArea = {0}", totalIntersectionArea);
        return totalIntersectionArea;
    }

    private double getNodesIntersectionArea(LayoutGraph lg, Object ignore, YRectangle rect, double stopIfOver) {
        double totalIntersectionArea = 0.0;
        NodeCursor nodes = lg.nodes();
        while (nodes.ok()) {
            Node node = nodes.node();
            if (!node.equals(ignore)) {
                NodeLayout nodeLayout = lg.getNodeLayout((Object)node);
                YRectangle nodeRect = new YRectangle(nodeLayout.getX(), nodeLayout.getY(), nodeLayout.getWidth(), nodeLayout.getHeight());
                double intersectionArea = this.getIntersectionArea(rect, nodeRect);
                totalIntersectionArea += intersectionArea;
                ++this._collisionChecksNode;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "      node2 = {0}", this.getOriginalNode((GraphInterface)lg, node));
                    LOG.log(Level.FINE, "         {0} = {1} intersect {2}", new Object[]{intersectionArea, rect, nodeRect});
                }
            }
            if (totalIntersectionArea >= stopIfOver) break;
            nodes.next();
        }
        return totalIntersectionArea;
    }

    private double getNodeLabelIntersectionArea(LayoutGraph lg, Object ignore, YRectangle rect, int labelIndex, double stopIfOver) {
        double totalIntersectionArea = 0.0;
        NodeCursor nodes = lg.nodes();
        while (nodes.ok()) {
            NodeLabelLayout[] labelLayouts;
            YLabel originalLabel;
            Node node = nodes.node();
            if (!node.equals(ignore) && (originalLabel = this.getOriginalLabel((GraphInterface)lg, node, labelIndex)) != null && originalLabel.isVisible() && (labelLayouts = lg.getLabelLayout(node)).length > labelIndex) {
                NodeLabelLayout labelLayout = labelLayouts[labelIndex];
                LabelCandidate labelCandidate = this._newLabelLocations.get(labelLayout);
                YRectangle otherRect = labelCandidate != null ? labelCandidate.getBoundingBox() : labelLayout.getBox();
                double intersectionArea = this.getIntersectionArea(rect, otherRect);
                totalIntersectionArea += intersectionArea;
                ++this._collisionChecksLabel;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "      node2 = {0}", this.getOriginalNode((GraphInterface)lg, node));
                    LOG.log(Level.FINE, "         {0} = {1} intersect {2} {3}", new Object[]{intersectionArea, rect, otherRect, labelLayout});
                }
            }
            if (totalIntersectionArea >= stopIfOver) break;
            nodes.next();
        }
        return totalIntersectionArea;
    }

    private double getEdgeIntersectionArea(LayoutGraph lg, Object ignore, YRectangle rect, double stopIfOver) {
        double totalIntersectionArea = 0.0;
        Rectangle2D.Double jRect = new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height);
        EdgeCursor edges = lg.edges();
        while (edges.ok()) {
            Edge edge = edges.edge();
            if (!edge.equals(ignore)) {
                YPoint sourcePointAbs = lg.getSourcePointAbs(edge);
                YPoint targetPointAbs = lg.getTargetPointAbs(edge);
                Line2D.Double line = new Line2D.Double(sourcePointAbs.x, sourcePointAbs.y, targetPointAbs.x, targetPointAbs.y);
                boolean intersects = line.intersects(jRect);
                ++this._collisionChecksEdge;
                if (intersects) {
                    totalIntersectionArea += 10.0;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "      edge2 = {0}", this.getOriginalEdge((GraphInterface)lg, edge));
                        LOG.fine("         Collision");
                    }
                }
            }
            if (totalIntersectionArea >= stopIfOver) break;
            edges.next();
        }
        return totalIntersectionArea;
    }

    private double getEdgeLabelIntersectionArea(LayoutGraph lg, Object ignore, YRectangle rect, double stopIfOver) {
        double totalIntersectionArea = 0.0;
        EdgeCursor edges = lg.edges();
        while (edges.ok()) {
            EdgeLabelLayout[] labelLayouts;
            YLabel originalLabel;
            Edge edge = edges.edge();
            if (!edge.equals(ignore) && (originalLabel = this.getOriginalLabel((GraphInterface)lg, edge)) != null && originalLabel.isVisible() && (labelLayouts = lg.getLabelLayout(edge)).length > 0) {
                EdgeLabelLayout labelLayout = labelLayouts[0];
                LabelCandidate labelCandidate = this._newLabelLocations.get(labelLayout);
                YRectangle otherRect = labelCandidate != null ? labelCandidate.getBoundingBox() : labelLayout.getBox();
                double intersectionArea = this.getIntersectionArea(rect, otherRect);
                totalIntersectionArea += intersectionArea;
                ++this._collisionChecksLabel;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "      edge2 = {0}", this.getOriginalEdge((GraphInterface)lg, edge));
                    LOG.log(Level.FINE, "         {0} = {1} intersect {2} {3}", new Object[]{intersectionArea, rect, otherRect, labelLayout});
                }
            }
            if (totalIntersectionArea >= stopIfOver) break;
            edges.next();
        }
        return totalIntersectionArea;
    }

    private YLabel getOriginalLabel(GraphInterface graph, Node node, int index) {
        Graph2D graph2D;
        NodeRealizer realizer;
        NodeLabel label = null;
        while (graph instanceof CopiedLayoutGraph && node != null) {
            CopiedLayoutGraph copiedGraph = (CopiedLayoutGraph)graph;
            node = (Node)copiedGraph.getOriginalNode(node);
            graph = copiedGraph.getOriginalGraph();
        }
        if (graph instanceof Graph2D && node != null && (realizer = (graph2D = (Graph2D)graph).getRealizer(node)) != null && realizer.labelCount() > index) {
            label = realizer.getLabel(index);
        }
        return label;
    }

    private YLabel getOriginalLabel(GraphInterface graph, Edge edge) {
        Graph2D graph2D;
        EdgeRealizer realizer;
        EdgeLabel label = null;
        while (graph instanceof CopiedLayoutGraph && edge != null) {
            CopiedLayoutGraph copiedGraph = (CopiedLayoutGraph)graph;
            edge = (Edge)copiedGraph.getOriginalEdge(edge);
            graph = copiedGraph.getOriginalGraph();
        }
        if (graph instanceof Graph2D && edge != null && (realizer = (graph2D = (Graph2D)graph).getRealizer(edge)) != null && realizer.labelCount() > 0) {
            label = realizer.getLabel();
        }
        return label;
    }

    private Node getOriginalNode(GraphInterface graph, Node node) {
        while (graph instanceof CopiedLayoutGraph && node != null) {
            CopiedLayoutGraph copiedGraph = (CopiedLayoutGraph)graph;
            node = (Node)copiedGraph.getOriginalNode(node);
            graph = copiedGraph.getOriginalGraph();
        }
        return node;
    }

    private Edge getOriginalEdge(GraphInterface graph, Edge edge) {
        while (graph instanceof CopiedLayoutGraph && edge != null) {
            CopiedLayoutGraph copiedGraph = (CopiedLayoutGraph)graph;
            edge = (Edge)copiedGraph.getOriginalEdge(edge);
            graph = copiedGraph.getOriginalGraph();
        }
        return edge;
    }

    private double getIntersectionArea(YRectangle rect1, YRectangle rect2) {
        if (YRectangle.intersects((YRectangle)rect1, (YRectangle)rect2)) {
            return this.getArea(this.getIntersection(rect1, rect2));
        }
        return 0.0;
    }

    private double getArea(YRectangle rect) {
        return rect.width * rect.height;
    }

    private YRectangle getIntersection(YRectangle rect1, YRectangle rect2) {
        double x1 = Math.max(rect1.x, rect2.x);
        double y1 = Math.max(rect1.y, rect2.y);
        double x2 = Math.min(rect1.x + rect1.width, rect2.x + rect2.width);
        double y2 = Math.min(rect1.y + rect1.height, rect2.y + rect2.height);
        return new YRectangle(x1, y1, x2 - x1, y2 - y1);
    }
}

