/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.layout;

import com.paterva.maltego.ui.graph.view2d.layout.SmartLayouter;
import java.util.Set;
import y.base.DataMap;
import y.base.DataProvider;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.layout.LayoutGraph;
import y.layout.Layouter;
import y.layout.hierarchic.IncrementalHierarchicLayouter;
import y.layout.hierarchic.incremental.IncrementalHintsFactory;
import y.util.Maps;

public class MaltegoHierarchicLayouter
extends SmartLayouter {
    private Set<Node> _newNodes;

    public MaltegoHierarchicLayouter(Set<Node> newNodes) {
        this._newNodes = newNodes;
    }

    public boolean canLayout(LayoutGraph lg) {
        return true;
    }

    public void doLayout(LayoutGraph lg) {
        Layouter coreLayouter = this.getCoreLayouter();
        if (coreLayouter instanceof IncrementalHierarchicLayouter && coreLayouter.canLayout(lg)) {
            IncrementalHierarchicLayouter ihl = (IncrementalHierarchicLayouter)coreLayouter;
            this.initialize(lg);
            DataMap hintMap = Maps.createHashedDataMap();
            lg.addDataProvider(IncrementalHierarchicLayouter.INCREMENTAL_HINTS_DPKEY, (DataProvider)hintMap);
            IncrementalHintsFactory hintsFactory = ihl.createIncrementalHintsFactory();
            NodeList incNL = this.getIncrementalNodeList(lg);
            NodeCursor nc = incNL.nodes();
            while (nc.ok()) {
                hintMap.set((Object)nc.node(), hintsFactory.createLayerIncrementallyHint((Object)nc.node()));
                nc.next();
            }
            ihl.doLayout(lg);
            this.disposeNodeMap(lg, IncrementalHierarchicLayouter.INCREMENTAL_HINTS_DPKEY);
        }
    }

    private NodeList getIncrementalNodeList(LayoutGraph lg) {
        NodeList nodeList = new NodeList();
        NodeCursor nodes = lg.nodes();
        while (nodes.ok()) {
            Node node = nodes.node();
            if (this._newNodes.contains(node)) {
                nodeList.add((Object)node);
            } else {
                Node originalNode = this.getOriginalNode(node);
                if (this._newNodes.contains(originalNode)) {
                    nodeList.add((Object)node);
                }
            }
            nodes.next();
        }
        return nodeList;
    }
}

