/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.layout;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.layout.LayoutGraph;
import y.layout.Layouter;

public abstract class AbstractAlignLayouter
implements Layouter {
    protected abstract double getAlignDirectionMin(LayoutGraph var1, Node var2);

    protected abstract double getAlignDirectionSize(LayoutGraph var1, Node var2);

    protected abstract double getAlignDimensionMin(LayoutGraph var1, Node var2);

    protected abstract double getAlignDimensionSize(LayoutGraph var1, Node var2);

    protected abstract double getAlignPercentage();

    protected abstract void setAlignDimensionMin(LayoutGraph var1, Node var2, double var3);

    protected double getMargin() {
        return 10.0;
    }

    public void doLayout(LayoutGraph graph) {
        if (graph.isEmpty()) {
            return;
        }
        NodeList sortedNodes = new NodeList(graph.nodes());
        sortedNodes.sort((Comparator)new AlignValueComparator(graph));
        ArrayList<List<Node>> nodeMatrix = new ArrayList<List<Node>>();
        NodeCursor nc = sortedNodes.nodes();
        while (nc.ok()) {
            Node node = nc.node();
            List<Node> listForNode = this.findNodeList(graph, nodeMatrix, node);
            if (listForNode == null) {
                listForNode = new ArrayList<Node>();
                nodeMatrix.add(listForNode);
            }
            listForNode.add(node);
            nc.next();
        }
        double alignValue = this.getAlignValue(graph, (Node)sortedNodes.get(0));
        List prevNodeList = null;
        for (List list : nodeMatrix) {
            if (prevNodeList != null) {
                double prevListMax = this.getAlignDimensionMax(graph, prevNodeList);
                double minToAlignValue = this.getMaxDiffBetweenMinAndAlignValue(graph, list);
                alignValue = prevListMax + this.getMargin() + minToAlignValue;
            }
            for (Node listNode : list) {
                this.setAlignValue(graph, listNode, alignValue);
            }
            prevNodeList = list;
        }
    }

    private double getAlignValue(LayoutGraph graph, Node node) {
        double min = this.getAlignDimensionMin(graph, node);
        double size = this.getAlignDimensionSize(graph, node);
        return min + size * this.getAlignPercentage();
    }

    private void setAlignValue(LayoutGraph graph, Node node, double value) {
        double size = this.getAlignDimensionSize(graph, node);
        double min = value - size * this.getAlignPercentage();
        this.setAlignDimensionMin(graph, node, min);
    }

    private List<Node> findNodeList(LayoutGraph graph, List<List<Node>> nodeMatrix, Node node) {
        double nodeMin = this.getAlignDirectionMin(graph, node);
        double nodeSize = this.getAlignDirectionSize(graph, node);
        List<Node> listForNode = null;
        for (List<Node> nodeList : nodeMatrix) {
            if (this.intersectsAny(graph, nodeList, nodeMin, nodeSize)) continue;
            listForNode = nodeList;
            break;
        }
        return listForNode;
    }

    private boolean intersectsAny(LayoutGraph graph, List<Node> nodeList, double nodeMin, double nodeSize) {
        double nodeMax = nodeMin + nodeSize;
        for (Node listNode : nodeList) {
            double listNodeMax;
            double listNodeMin = this.getAlignDirectionMin(graph, listNode);
            if (!this.intersects(nodeMin, nodeMax, listNodeMin, listNodeMax = listNodeMin + this.getAlignDirectionSize(graph, listNode))) continue;
            return true;
        }
        return false;
    }

    private boolean intersects(double min1, double max1, double min2, double max2) {
        return !(max1 < min2) && !(max2 < min1);
    }

    private double getAlignDimensionMax(LayoutGraph graph, List<Node> nodes) {
        double maxValue = -1.7976931348623157E308;
        for (Node node : nodes) {
            double min = this.getAlignDimensionMin(graph, node);
            double size = this.getAlignDimensionSize(graph, node);
            double value = min + size;
            maxValue = Math.max(maxValue, value);
        }
        return maxValue;
    }

    private double getMaxDiffBetweenMinAndAlignValue(LayoutGraph graph, List<Node> nodes) {
        double maxDiff = -1.7976931348623157E308;
        for (Node node : nodes) {
            double min = this.getAlignDimensionMin(graph, node);
            double alignValue = this.getAlignValue(graph, node);
            double diff = alignValue - min;
            maxDiff = Math.max(maxDiff, diff);
        }
        return maxDiff;
    }

    public boolean canLayout(LayoutGraph graph) {
        return true;
    }

    private class AlignValueComparator
    implements Comparator<Node> {
        private LayoutGraph _graph;

        public AlignValueComparator(LayoutGraph graph) {
            this._graph = graph;
        }

        @Override
        public int compare(Node node1, Node node2) {
            double alignValue2;
            double alignValue1 = AbstractAlignLayouter.this.getAlignValue(this._graph, node1);
            return alignValue1 <= (alignValue2 = AbstractAlignLayouter.this.getAlignValue(this._graph, node2)) ? -1 : 1;
        }
    }
}

