/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.labels;

import com.paterva.maltego.ui.graph.view2d.LightweightEntityRealizer;
import com.paterva.maltego.ui.graph.view2d.labels.EntityLabelProvider;
import com.paterva.maltego.ui.graph.view2d.labels.EntityPropertyLabel;
import com.paterva.maltego.ui.graph.view2d.labels.EntityPropertyLabelDescriptor;
import com.paterva.maltego.ui.graph.view2d.labels.EntityPropertyLabelReader;
import com.paterva.maltego.ui.graph.view2d.labels.EntityPropertyLabelTranslator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import y.view.NodeLabel;
import y.view.NodeRealizer;

public class EntityPropertyLabelProvider
extends EntityLabelProvider {
    private final Map<FileObject, EntityPropertyLabelDescriptor> _descriptors = new HashMap<FileObject, EntityPropertyLabelDescriptor>();

    @Override
    public List<NodeLabel> getLabels(NodeRealizer nr) {
        ArrayList<NodeLabel> labels = new ArrayList<NodeLabel>();
        if (nr instanceof LightweightEntityRealizer) {
            LightweightEntityRealizer entityLabelNR = (LightweightEntityRealizer)nr;
            FileObject entityLabels = FileUtil.getConfigFile((String)"Maltego/EntityLabels/PropertyLabels");
            if (entityLabels != null) {
                labels = this.createPropertyLabels(entityLabels, entityLabelNR);
            }
        }
        return labels;
    }

    private ArrayList<NodeLabel> createPropertyLabels(FileObject entityLabels, LightweightEntityRealizer entityLabelNR) {
        ArrayList<NodeLabel> labels = new ArrayList<NodeLabel>();
        EntityPropertyLabelReader reader = new EntityPropertyLabelReader();
        EntityPropertyLabelTranslator translator = new EntityPropertyLabelTranslator();
        for (FileObject fileObject : entityLabels.getChildren()) {
            EntityPropertyLabel label = this.createPropertyLabel(fileObject, reader, translator);
            if (label == null) continue;
            label.attach(entityLabelNR);
            labels.add(label);
        }
        return labels;
    }

    private EntityPropertyLabel createPropertyLabel(FileObject entityLabel, EntityPropertyLabelReader reader, EntityPropertyLabelTranslator translator) {
        EntityPropertyLabel label = null;
        try {
            EntityPropertyLabelDescriptor descriptor = this._descriptors.get(entityLabel);
            if (descriptor == null) {
                descriptor = reader.read(entityLabel);
                this._descriptors.put(entityLabel, descriptor);
            }
            if (descriptor != null) {
                label = translator.translate(descriptor);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return label;
    }
}

