/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.labels;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStore;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.ui.graph.GraphType;
import com.paterva.maltego.ui.graph.view2d.LightweightEntityRealizer;
import com.paterva.maltego.ui.graph.view2d.labels.EntityPropertyLabelSettings;
import org.openide.util.Exceptions;
import y.base.Graph;
import y.base.Node;
import y.view.Graph2D;
import y.view.NodeLabel;
import y.view.NodeRealizer;

public class EntityPropertyLabel
extends NodeLabel {
    private final String _property;
    private GraphEntity _entity;
    private String _graphType = null;

    public EntityPropertyLabel(String property) {
        this._property = property;
    }

    public void setGraphEntity(GraphEntity graphEntity) {
        this._entity = graphEntity;
        this.updateText();
    }

    public void attach(LightweightEntityRealizer entityLabelNR) {
        this.bindRealizer((NodeRealizer)entityLabelNR);
    }

    private GraphDataStore getGraphDataStore() {
        try {
            return GraphStoreRegistry.getDefault().forGraphID(this._entity.getGraphID()).getGraphDataStore();
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public void update() {
        this.updateText();
        this.repaintNode();
    }

    void updateText() {
        Object value;
        MaltegoEntity entity;
        PropertyDescriptor pd;
        Graph2D graph2D = this.getGraph2D();
        String string = this._graphType = graph2D != null ? GraphType.getType((Graph)graph2D) : null;
        String text = graph2D != null && !EntityPropertyLabelSettings.isShowPropertyLabels(this._graphType) ? "" : (this._entity != null ? ((pd = (entity = this.getEntity()).getProperties().get(this._property)) != null ? ((value = entity.getValue(pd)) != null ? " " + TypeRegistry.getDefault().getType(pd.getType()).convert(value) : "") : "") : "(no entity)");
        this.setText(text);
    }

    private MaltegoEntity getEntity() {
        try {
            return this.getGraphDataStore().getDataStoreReader().getEntity((EntityID)this._entity.getID());
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private void repaintNode() {
        NodeRealizer realizer;
        Graph2D graph2D;
        Node node = this.getNode();
        if (node != null && (graph2D = this.getGraph2D()) != null && (realizer = graph2D.getRealizer(node)) != null) {
            realizer.repaint();
        }
    }
}

