/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.DataProviders;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import y.base.DataProvider;
import y.base.Graph;

public class ViewGraphName {
    private static final String VIEW_NAME_KEY = "maltego.ViewGraphName";

    private ViewGraphName() {
    }

    public static synchronized String get(GraphID graphID) {
        Graph graph = MaltegoGraphManager.getWrapper((GraphID)graphID).getGraph();
        return ViewGraphName.get(graph);
    }

    public static synchronized String get(Graph viewGraph) {
        DataProviders.Singleton dataProvider = (DataProviders.Singleton)viewGraph.getDataProvider((Object)VIEW_NAME_KEY);
        String name = dataProvider != null ? (String)dataProvider.get() : null;
        return name;
    }

    public static synchronized void set(Graph viewGraph, String name) {
        DataProviders.Singleton dataProvider = new DataProviders.Singleton((Object)name);
        viewGraph.addDataProvider((Object)VIEW_NAME_KEY, (DataProvider)dataProvider);
    }

    public static synchronized Map<String, Graph> getForModelGraph(Graph modelGraph) {
        Set<Graph> viewGraphs = Collections.singleton(modelGraph);
        return ViewGraphName.get(viewGraphs);
    }

    public static synchronized Map<String, Graph> get(Collection<Graph> viewGraphs) {
        HashMap<String, Graph> viewNames = new HashMap<String, Graph>();
        if (viewGraphs != null) {
            for (Graph viewGraph : viewGraphs) {
                String viewName = ViewGraphName.get(viewGraph);
                if (viewName == null) continue;
                viewNames.put(viewName, viewGraph);
            }
        }
        return viewNames;
    }
}

