/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import y.base.GraphEvent;
import y.view.Graph2D;
import y.view.Selections;

abstract class SelectionStateObserver
extends Selections.SelectionStateObserver {
    private int _eventDepth = 0;
    private boolean _inDeleteTransaction = false;

    SelectionStateObserver() {
    }

    protected void updateSelectionState(Graph2D graph) {
        if (!this._inDeleteTransaction) {
            this.selectionChanged(graph);
        }
    }

    public void onGraphEvent(GraphEvent ge) {
        this.handle(ge);
        super.onGraphEvent(ge);
    }

    private void handle(GraphEvent evt) {
        Graph2D graph2D = (Graph2D)evt.getGraph();
        switch (evt.getType()) {
            case 5: {
                if (this._eventDepth <= 0) break;
                this._inDeleteTransaction = true;
                break;
            }
            case 3: {
                if (this._eventDepth <= 0) break;
                this._inDeleteTransaction = true;
                break;
            }
            case 12: {
                ++this._eventDepth;
                break;
            }
            case 13: {
                --this._eventDepth;
                if (this._eventDepth > 0 || !this._inDeleteTransaction) break;
                this._inDeleteTransaction = false;
                this.updateSelectionState(graph2D);
            }
        }
    }

    protected abstract void selectionChanged(Graph2D var1);
}

