/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.actions.SelectionMode;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.Node;
import y.base.NodeCursor;
import y.view.Bend;
import y.view.Graph2D;
import y.view.SelectionBoxMode;

public class SelectionBoxViewMode
extends SelectionBoxMode {
    protected boolean belongsToSelection(Node node, Rectangle2D rd) {
        Graph2D g2D = this.getGraph2D();
        return rd.contains(g2D.getCenterX(node), g2D.getCenterY(node));
    }

    protected boolean belongsToSelection(Edge edge, Rectangle2D rd) {
        Graph2D g2D = this.getGraph2D();
        return g2D.getRealizer(edge).pathIntersects(rd, false);
    }

    protected boolean belongsToSelection(Bend bend, Rectangle2D rd) {
        return false;
    }

    protected void selectionBoxAction(Rectangle rctngl, boolean addToSelection) {
        Graph2D g2D = this.getGraph2D();
        GraphID graphID = GraphIDProvider.forGraph((Graph2D)g2D);
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((GraphID)graphID);
        GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
        boolean selectNodes = SelectionMode.isEntities();
        MouseEvent lastClick = this.getLastReleaseEvent();
        if (lastClick != null && (lastClick.isControlDown() || lastClick.isAltDown())) {
            boolean bl = selectNodes = !selectNodes;
        }
        if (selectNodes) {
            HashSet<EntityID> entities = new HashSet<EntityID>();
            NodeCursor nodes = g2D.nodes();
            while (nodes.ok()) {
                Node node = nodes.node();
                if (this.belongsToSelection(node, (Rectangle2D)rctngl)) {
                    EntityID entityID = wrapper.entityID(node);
                    entities.add(entityID);
                }
                nodes.next();
            }
            if (addToSelection) {
                selection.addSelectedViewEntities(entities);
            } else {
                selection.setSelectedViewEntities(entities);
            }
        } else {
            HashSet<LinkID> links = new HashSet<LinkID>();
            EdgeCursor edges = g2D.edges();
            while (edges.ok()) {
                Edge edge = edges.edge();
                if (this.belongsToSelection(edge, (Rectangle2D)rctngl)) {
                    LinkID linkID = wrapper.linkID(edge);
                    links.add(linkID);
                }
                edges.next();
            }
            if (addToSelection) {
                selection.addSelectedViewLinks(links);
            } else {
                selection.setSelectedViewLinks(links);
            }
        }
        this.view.updateView();
    }
}

