/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.graph.selection.SelectionState;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeUtils;
import com.paterva.maltego.ui.graph.view2d.NodeLabelUtils;
import com.paterva.maltego.ui.graph.view2d.NodeRealizerSettings;
import com.paterva.maltego.ui.graph.view2d.painter.MainEntityPainter;
import com.paterva.maltego.util.ColorUtilities;
import com.paterva.maltego.util.ui.GraphicsUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;
import y.view.GenericNodeRealizer;
import y.view.NodeRealizer;

public class RoundRectHotSpotPainter
implements GenericNodeRealizer.HotSpotPainter {
    private static final Logger LOG = Logger.getLogger(RoundRectHotSpotPainter.class.getName());
    public static final boolean DRAW_ENTITY_HOTSPOTS_ROUND = true;
    public static final int ENTITY_HOTSPOT_ROUND_RECT_ARC = 10;
    private static final float[] _dash1 = new float[]{8.0f, 6.0f};
    private static final Insets _i = new Insets(0, 0, 0, 0);

    public void paintHotSpots(NodeRealizer nr, Graphics2D g2D) {
        Color col1 = ColorUtilities.makeTranslucent((Color)NodeRealizerSettings.getDefault().getSelectionBackgroundColor1(), (int)200);
        g2D.setPaint(col1);
        if (CollectionNodeUtils.isCollectionNode(nr)) {
            double zoom = GraphicsUtils.getZoom((Graphics2D)g2D);
            if (MainEntityPainter.isFarZoom(zoom)) {
                g2D.fill(new Rectangle2D.Double((float)nr.getX() - (float)RoundRectHotSpotPainter._i.left, (float)nr.getY() - (float)RoundRectHotSpotPainter._i.top, (float)nr.getWidth() + (float)RoundRectHotSpotPainter._i.left + (float)RoundRectHotSpotPainter._i.right, (float)nr.getHeight() + (float)RoundRectHotSpotPainter._i.top + (float)RoundRectHotSpotPainter._i.bottom));
            }
        } else {
            this.paintHotSpot(g2D, nr);
        }
        RoundRectHotSpotPainter.paintBorder(nr, g2D, _i, true, null);
    }

    public void paintHotSpot(Graphics2D g2D, NodeRealizer nr) {
        Rectangle2D rect = NodeLabelUtils.getRectangle2D(nr, 0.0f);
        LOG.log(Level.FINE, "rect={0}", rect);
        g2D.fill(new Ellipse2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight()));
    }

    public static void paintBorder(NodeRealizer nr, Graphics2D g2D, Insets i, boolean drawLabelBg, Double ballSize) {
        double zoom = GraphicsUtils.getZoom((Graphics2D)g2D);
        float strokeWidth = RoundRectHotSpotPainter.getStrokeWidth();
        if (zoom < 1.0) {
            strokeWidth = (float)((double)strokeWidth / zoom);
        }
        Color col1 = ColorUtilities.makeTranslucent((Color)NodeRealizerSettings.getDefault().getSelectionBorderColor1(), (int)200);
        if (CollectionNodeUtils.getSelectionState(nr) == SelectionState.NO) {
            col1 = UIManager.getLookAndFeelDefaults().getColor("graph-collection-selection-icon-background-color");
        }
        g2D.setPaint(col1);
        if (CollectionNodeUtils.isCollectionNode(nr)) {
            float strokeWidthCollection = strokeWidth;
            if (CollectionNodeUtils.getSelectionState(nr) == SelectionState.PARTIAL) {
                g2D.setStroke(new BasicStroke(strokeWidthCollection, 0, 0, 10.0f, _dash1, 0.0f));
            } else {
                g2D.setStroke(new BasicStroke(strokeWidthCollection, 0, 0));
            }
            if (ballSize == null) {
                g2D.draw(new Rectangle2D.Double((float)nr.getX() - strokeWidthCollection / 2.0f - (float)i.left, (float)nr.getY() - strokeWidthCollection / 2.0f - (float)i.top, (float)((int)nr.getWidth()) + strokeWidthCollection + (float)i.left + (float)i.right, (float)((int)nr.getHeight()) + strokeWidthCollection + (float)i.top + (float)i.bottom));
            } else {
                double x = nr.getX() + (nr.getWidth() - ballSize) / 2.0;
                g2D.draw(new Rectangle2D.Double((float)x - strokeWidthCollection / 2.0f - (float)i.left, (float)nr.getY() - strokeWidthCollection / 2.0f - (float)i.top, (float)ballSize.intValue() + strokeWidthCollection + (float)i.left + (float)i.right, (float)ballSize.intValue() + strokeWidthCollection + (float)i.top + (float)i.bottom));
            }
        } else {
            float strokeWidthEntity = strokeWidth;
            g2D.setStroke(new BasicStroke(strokeWidthEntity, 0, 0));
            Rectangle2D rect = NodeLabelUtils.getRectangle2D(nr, strokeWidthEntity);
            Ellipse2D.Double circle = new Ellipse2D.Double();
            circle.setFrame(rect);
            g2D.draw(circle);
            if (drawLabelBg) {
                NodeLabelUtils.paintLabelBackground(nr, g2D, rect, strokeWidthEntity);
            }
        }
    }

    public static float getStrokeWidth() {
        return NodeRealizerSettings.getDefault().getSelectionBorderStrokeWidth();
    }
}

