/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.actions.NodeEditor;
import com.paterva.maltego.ui.graph.actions.SelectionMode;
import com.paterva.maltego.ui.graph.view2d.BookmarkClickViewMode;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeUtils;
import com.paterva.maltego.ui.graph.view2d.EditableNodeLabel;
import com.paterva.maltego.ui.graph.view2d.HitInfoCache;
import com.paterva.maltego.ui.graph.view2d.MacOSXEditMode;
import com.paterva.maltego.ui.graph.view2d.NodeEditHook;
import com.paterva.maltego.ui.graph.view2d.NotesClickViewMode;
import com.paterva.maltego.ui.graph.view2d.PinClickViewMode;
import com.paterva.maltego.ui.graph.view2d.painter.MainEntityPainter;
import java.awt.Component;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.openide.util.Utilities;
import y.base.Edge;
import y.base.Graph;
import y.base.Node;
import y.geom.YPoint;
import y.view.Graph2D;
import y.view.Graph2DView;
import y.view.HitInfo;
import y.view.NodeLabel;
import y.view.NodeRealizer;
import y.view.YLabel;

public class PopupAwareEditMode
extends MacOSXEditMode {
    private static final Logger LOG = Logger.getLogger(PopupAwareEditMode.class.getName());
    private final BookmarkClickViewMode _bookmarkClickViewMode = new BookmarkClickViewMode();
    private final NotesClickViewMode _notesClickViewMode = new NotesClickViewMode();
    private final PinClickViewMode _pinClickViewMode = new PinClickViewMode();

    public PopupAwareEditMode() {
        this.allowNodeCreation(false);
        this.allowBendCreation(false);
        this.allowEdgeCreation(true);
        this.allowMovePorts(false);
        this.allowMoveLabels(false);
        this.allowMovingWithPopup(true);
        this.allowResizeNodes(false);
        this.allowLabelSelection(false);
    }

    public void setActiveView(Graph2DView activeView) {
        super.setActiveView(activeView);
        activeView.getCanvasComponent().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("Zoom".equals(evt.getPropertyName())) {
                    PopupAwareEditMode.this.checkEditNode();
                }
            }
        });
    }

    protected void setSelected(Graph2D graph, Node node, boolean state) {
        GraphID graphID = GraphIDProvider.forGraph((Graph2D)graph);
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((GraphID)graphID);
        GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
        selection.setViewEntitiesSelected(Collections.singleton(wrapper.entityID(node)), state);
    }

    protected void unselectAll(Graph2D graph) {
        GraphID graphID = GraphIDProvider.forGraph((Graph2D)graph);
        GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
        selection.clearSelection();
    }

    public void mouseMoved(double x, double y) {
        if (!(this._bookmarkClickViewMode.isOverLabel(this.view, x, y) || this._notesClickViewMode.isOverLabel(this.view, x, y) || this._pinClickViewMode.isOverLabel(this.view, x, y))) {
            super.mouseMoved(x, y);
        }
        this.checkEditNode();
    }

    private void checkEditNode() {
        Node node;
        HitInfo hit = this.getLastHitInfo();
        if (hit != null && (node = hit.getHitNode()) != null && this.isEditSwingGesture(node, this.lastPressEvent, this.lastReleaseEvent, this.lastClickEvent)) {
            this.editSwing(node, this.lastMoveEvent);
        }
    }

    public void mousePressedLeft(double x, double y) {
        if (this._bookmarkClickViewMode.isOverLabel(this.view, x, y)) {
            this.setChild(this._bookmarkClickViewMode, this.lastPressEvent, null);
        } else if (this._notesClickViewMode.isOverLabel(this.view, x, y)) {
            this.setChild(this._notesClickViewMode, this.lastPressEvent, null);
        } else if (this._pinClickViewMode.isOverLabel(this.view, x, y)) {
            this.setChild(this._pinClickViewMode, this.lastPressEvent, null);
        } else {
            super.mousePressedLeft(x, y);
        }
    }

    public MouseEvent processModifierLeftMouseButtonClicked(MouseEvent e) {
        if (Utilities.isMac()) {
            int onMask1 = 1344;
            if (e.getClickCount() == 1 && (e.getModifiersEx() & onMask1) == onMask1) {
                return new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), 1024, e.getX(), e.getY(), 707, false, 1);
            }
            onMask1 = 1280;
            int onMask2 = 256;
            if (e.getClickCount() == 1 && ((e.getModifiersEx() & onMask1) == onMask1 || e.getButton() == 1 && (e.getModifiersEx() & onMask2) == onMask2)) {
                return new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), 1024, e.getX(), e.getY(), 717, false, 1);
            }
        }
        return e;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Edge edge;
        HitInfo hitInfo;
        mouseEvent = this.processModifierLeftMouseButtonClicked(mouseEvent);
        super.mouseReleased(mouseEvent);
        if (mouseEvent.getClickCount() == 2 && !mouseEvent.isConsumed() && SwingUtilities.isLeftMouseButton(mouseEvent) && (hitInfo = this.getHitInfo(this.view.toWorldCoordX(mouseEvent.getX()), this.view.toWorldCoordY(mouseEvent.getY()))).hasHitEdges() && (edge = hitInfo.getHitEdge()) != null) {
            mouseEvent.consume();
            GraphID graphID = GraphIDProvider.forGraph((Graph2D)this.getGraph2D());
            GraphWrapper wrapper = MaltegoGraphManager.getWrapper((GraphID)graphID);
            LinkID linkID = wrapper.linkID(edge);
            if (linkID != null) {
                NodeEditor.getDefault().edit(graphID, linkID);
            }
        }
    }

    protected void nodeClicked(Graph2D gd, Node node, boolean bln, double d, double d1, boolean bln1) {
        if (this.canSelectNodes() && node != null && !this.isEditing(gd, node)) {
            super.nodeClicked(gd, node, bln, d, d1, bln1);
        }
    }

    protected void edgeClicked(Graph2D gd, Edge edge, boolean bln, double d, double d1, boolean bln1) {
        if (!this.canSelectNodes()) {
            super.edgeClicked(gd, edge, bln, d, d1, bln1);
        }
    }

    protected HitInfo getHitInfo(double x, double y) {
        HitInfo hInfo = HitInfoCache.getDefault().getStandardHitInfo(this.view, x, y);
        this.setLastHitInfo(hInfo);
        return hInfo;
    }

    private boolean canSelectNodes() {
        boolean selectNodes = SelectionMode.isEntities();
        MouseEvent lastClick = this.getLastClickEvent();
        if (lastClick != null && (lastClick.isControlDown() || lastClick.isAltDown())) {
            selectNodes = !selectNodes;
        }
        return selectNodes;
    }

    private HitInfo createNodeOnlyHitInfo(double x, double y) {
        return HitInfoCache.getDefault().getOrCreateHitInfo(this.view, x, y, true, 19);
    }

    private HitInfo createEdgeOnlyHitInfo(double x, double y) {
        return HitInfoCache.getDefault().getOrCreateHitInfo(this.view, x, y, true, 35);
    }

    public void mousePressed(MouseEvent e) {
        MouseEvent e1 = this.processModifierLeftMouseButtonClicked(e);
        if (SwingUtilities.isRightMouseButton(e1) && this.getChild() != null) {
            this.getChild().reactivateParent();
        }
        super.mousePressed(e1);
    }

    protected boolean editNode(Node hitNode, EventObject e) {
        boolean result = false;
        if (e instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)e)) {
            HitInfo hi;
            Node node;
            double worldY;
            MouseEvent evt = (MouseEvent)e;
            int x = evt.getX();
            int y = evt.getY();
            double worldX = this.view.toWorldCoordX(x);
            if (this._bookmarkClickViewMode.isOverLabel(this.view, worldX, worldY = this.view.toWorldCoordY(y)) || this._notesClickViewMode.isOverLabel(this.view, worldX, worldY) || this._pinClickViewMode.isOverLabel(this.view, worldX, worldY)) {
                result = false;
            }
            if ((node = (hi = this.getLastHitInfo()).getHitNode()) != null) {
                NodeLabel editLabel = null;
                NodeRealizer realizer = this.view.getGraph2D().getRealizer(node);
                if (this.view.getZoom() >= this.view.getPaintDetailThreshold()) {
                    for (int i = 0; i < realizer.labelCount(); ++i) {
                        NodeLabel label = realizer.getLabel(i);
                        if (label == null || !label.isVisible() || !label.getBox().contains(worldX, worldY)) continue;
                        editLabel = label;
                        break;
                    }
                }
                if (editLabel instanceof EditableLabel && ((EditableLabel)editLabel).isEditable()) {
                    this.editLabel(editLabel);
                } else {
                    this.editNode(node);
                }
            }
        }
        return result;
    }

    protected boolean isEditNodeGesture(Node hitNode, MouseEvent lastPressEvent, MouseEvent lastReleaseEvent, MouseEvent lastClickEvent) {
        return super.isEditNodeGesture(hitNode, lastPressEvent, lastReleaseEvent, lastClickEvent);
    }

    void editSwing(Node hitNode, EventObject e) {
        super.editNode(hitNode, e);
    }

    boolean isEditSwingGesture(Node hitNode, MouseEvent lastPressEvent, MouseEvent lastReleaseEvent, MouseEvent lastClickEvent) {
        Graph2DView gv = this.view;
        if (MainEntityPainter.isDeepZoom(gv.getZoom())) {
            return PopupAwareEditMode.isSwingNode(gv.getGraph2D(), hitNode) && PopupAwareEditMode.isOverCollectionNodeMinusBanner(hitNode, gv, this.lastMoveEvent);
        }
        return false;
    }

    public static boolean isOverCollectionNodeMinusBanner(Node node, Graph2DView gv, MouseEvent evt) {
        NodeRealizer nr = ((Graph2D)node.getGraph()).getRealizer(node);
        return nr.contains(gv.toWorldCoordX(evt.getX()), gv.toWorldCoordY(evt.getY()) - 15.0);
    }

    static boolean isSwingNode(Graph2D graph, Node node) {
        return CollectionNodeUtils.isCollectionNode(node);
    }

    private boolean isEditing(Graph2D graph, Node node) {
        return graph.getDataProvider((Object)"IS_EDITING_DPKEY").getBool((Object)node);
    }

    protected void editLabel(final NodeLabel label) {
        PropertyChangeListener pcl = e -> {
            this.reactivateParent();
            this.fireEditEvent("nodeEdited", label.getNode());
        };
        ContainerAdapter containerListener = new ContainerAdapter(){

            @Override
            public void componentRemoved(ContainerEvent e) {
                boolean fireByCollectionNode = CollectionNodeUtils.isFiredByCollectionNode(e);
                if (!fireByCollectionNode) {
                    SwingUtilities.invokeLater(() -> {
                        PopupAwareEditMode.this.fireEditEvent("labelEditorClosed", label.getNode());
                        if (label instanceof EditableNodeLabel) {
                            EditableNodeLabel editableLabel = (EditableNodeLabel)label;
                            editableLabel.setEditing(false);
                        }
                    });
                    PopupAwareEditMode.this.view.getCanvasComponent().removeContainerListener(this);
                }
            }
        };
        this.fireEditEvent("labelEditorOpened", label.getNode());
        this.view.getCanvasComponent().addContainerListener(containerListener);
        if (label instanceof EditableNodeLabel) {
            EditableNodeLabel editableLabel = (EditableNodeLabel)label;
            editableLabel.setEditing(true);
            this.view.repaint();
        }
        this.view.openLabelEditor((YLabel)label, label.getTextLocation().x, label.getTextLocation().y, pcl, true, true);
    }

    protected void editNode(Node node) {
        if (CollectionNodeUtils.isCollectionNode(node)) {
            this.zoomToList(node);
        } else {
            GraphID graphID = GraphIDProvider.forGraph((Graph2D)this.getGraph2D());
            GraphWrapper wrapper = MaltegoGraphManager.getWrapper((GraphID)graphID);
            if (NodeEditor.getDefault().edit(graphID, wrapper.entityID(node))) {
                this.fireEditEvent("nodeEdited", node);
            }
        }
    }

    private void zoomToList(Node node) {
        YPoint center = this.view.getGraph2D().getCenter(node);
        this.view.focusView(3.0, (Point2D)new Point2D.Double(center.x, center.y), true);
    }

    private void fireEditEvent(String id, Node node) {
        Collection<? extends NodeEditHook> hooks = NodeEditHook.getAll();
        if (hooks.isEmpty()) {
            return;
        }
        Graph graph = node.getGraph();
        if (graph != null) {
            GraphID graphID = GraphIDProvider.forGraph((Graph)graph);
            for (NodeEditHook nodeEditHook : hooks) {
                nodeEditHook.handle(id, graphID);
            }
        }
    }

    public static interface EditableLabel {
        public boolean isEditable();
    }
}

