/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.structure.GraphStructureStore;
import com.paterva.maltego.graph.store.view.GraphModelViewMappings;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openide.util.Exceptions;
import y.base.Graph;
import y.base.Node;
import y.view.Graph2D;
import y.view.NodeLabel;
import y.view.YLabel;

public class PinUtils {
    private PinUtils() {
    }

    public static boolean isPinned(YLabel label) {
        boolean pinned = false;
        if (label instanceof NodeLabel) {
            NodeLabel nodeLabel = (NodeLabel)label;
            Node node = nodeLabel.getNode();
            Graph2D graph2D = nodeLabel.getGraph2D();
            GraphWrapper wrapper = MaltegoGraphManager.getWrapper((Graph)graph2D);
            EntityID entityID = wrapper.entityID(node);
            GraphID graphID = GraphIDProvider.forGraph((Graph2D)graph2D);
            pinned = PinUtils.isPinned(graphID, entityID);
        }
        return pinned;
    }

    public static boolean isPinned(GraphID graphID, EntityID entityID) {
        boolean pinned = false;
        try {
            GraphStructureReader structureReader;
            GraphStructureStore structureStore;
            GraphStore graphStore;
            GraphModelViewMappings mappings;
            GraphStoreView view;
            GraphStoreViewRegistry registry = GraphStoreViewRegistry.getDefault();
            if (registry != null && (view = registry.getDefaultView(graphID)) != null && (mappings = view.getModelViewMappings()) != null && !mappings.isOnlyViewEntity(entityID) && (graphStore = view.getModel()) != null && (structureStore = graphStore.getGraphStructureStore()) != null && (structureReader = structureStore.getStructureReader()) != null) {
                pinned = structureReader.getPinned(entityID);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return pinned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pinClicked(GraphWrapper wrapper, GraphID graphID, EntityID entityID, boolean accountForSelection, Collection<EntityID> previousSelection) {
        GraphStore graphStore = null;
        try {
            boolean newPinned;
            Set<EntityID> entityIDs;
            graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            graphStore.beginUpdate();
            if (wrapper.isCollectionNode(entityID)) {
                GraphStoreView graphStoreView = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
                entityIDs = graphStoreView.getModelViewMappings().getModelEntities(entityID);
                newPinned = true;
            } else {
                GraphSelection selection;
                GraphStructureStore structureStore = graphStore.getGraphStructureStore();
                GraphStructureReader structureReader = structureStore.getStructureReader();
                boolean oldPinned = structureReader.getPinned(entityID);
                boolean bl = newPinned = !oldPinned;
                entityIDs = accountForSelection ? (!(selection = GraphSelection.forGraph((GraphID)graphID)).isSelectedInModel(entityID) ? Collections.singleton(entityID) : selection.getSelectedModelEntities()) : (previousSelection == null || previousSelection.isEmpty() ? Collections.singleton(entityID) : new HashSet<EntityID>(previousSelection));
            }
            GraphTransactionHelper.doChangePinned(graphID, (Collection<EntityID>)entityIDs, newPinned);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (graphStore != null) {
                graphStore.endUpdate((Object)true);
            }
        }
    }
}

