/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.ui.graph.view2d.EditableNodeLabel;
import com.paterva.maltego.ui.graph.view2d.EntityLabelMax;
import com.paterva.maltego.ui.graph.view2d.EntityLabelOptions;
import com.paterva.maltego.ui.graph.view2d.LightweightEntityRealizer;
import com.paterva.maltego.util.StringUtilities;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NotesLabel
extends EditableNodeLabel {
    private static final Logger LOG = Logger.getLogger(NotesLabel.class.getName());

    public NotesLabel(LightweightEntityRealizer realizer) {
        super(realizer);
    }

    @Override
    public void updateText() {
        LightweightEntityRealizer realizer = this.getEntityRealizer();
        MaltegoEntity entitySkeleton = realizer.getEntitySkeleton();
        this.updateText(entitySkeleton);
    }

    public void updateText(MaltegoEntity entitySkeleton) {
        if (entitySkeleton != null) {
            String text = entitySkeleton.getNotes();
            if (text == null) {
                text = "";
            }
            this.setTextInternal(text);
        }
    }

    public void setText(String text) {
        this.setTextInternal(text);
    }

    private void setTextInternal(String text) {
        LOG.log(Level.FINE, "text = {0}", text);
        text = StringUtilities.escapeRTLBidiText((String)text);
        if (!this.isEditing() && EntityLabelOptions.isEnabled(EntityLabelMax.NOTES)) {
            text = StringUtilities.chompLines((String)text, (int)EntityLabelOptions.getMaxLength(EntityLabelMax.NOTES));
            LOG.log(Level.FINE, "text (truncated) = {0}", text);
        }
        super.setText(text);
    }
}

