/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.ui.graph.view2d.LabelViewMode;
import com.paterva.maltego.util.StringUtilities;
import java.awt.event.MouseEvent;
import java.util.Collections;
import javax.swing.SwingUtilities;
import y.base.Graph;
import y.base.Node;
import y.view.Graph2DView;
import y.view.NodeLabel;

public class NotesClickViewMode
extends LabelViewMode {
    public boolean isOverLabel(Graph2DView view, double x, double y) {
        return this.getLabel(view, x, y, 2) != null;
    }

    public void mouseClicked(MouseEvent me) {
        NodeLabel label;
        super.mouseClicked(me);
        if (me.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(me) && (label = this.getLabel(this.view, this.view.toWorldCoordX(me.getX()), this.view.toWorldCoordY(me.getY()), 2)) != null) {
            this.notesClicked(label);
        }
        this.reactivateParent();
    }

    private void notesClicked(NodeLabel label) {
        NodeLabel notesEditLabel = this.view.getGraph2D().getRealizer(label.getNode()).getLabel(4);
        if (notesEditLabel != null) {
            MaltegoEntity entity = this.getEntity(label.getNode());
            String notes = entity.getNotes();
            boolean showNotes = entity.isShowNotes();
            if (StringUtilities.isNullOrEmpty((String)entity.getNotes())) {
                showNotes = true;
                notes = "(Click here to add notes)";
            } else if ("(Click here to add notes)".equals(entity.getNotes())) {
                showNotes = false;
                notes = "";
            } else {
                showNotes = !showNotes;
            }
            GraphTransactionHelper.doChangeNotes((Graph)this.getGraph2D(), Collections.singleton(entity), notes, showNotes);
        }
    }

    private MaltegoEntity getEntity(Node node) {
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((Graph)this.view.getGraph2D());
        MaltegoEntity entity = wrapper.entity(node);
        return entity;
    }
}

