/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeUtils;
import com.paterva.maltego.ui.graph.view2d.EmptyNodeMap;
import com.paterva.maltego.ui.graph.view2d.EntityNodeCellRenderer;
import com.paterva.maltego.ui.graph.view2d.EntityNodePainter;
import com.paterva.maltego.ui.graph.view2d.EntityRealizerInflater;
import com.paterva.maltego.ui.graph.view2d.EntityRealizerInflaterRegistry;
import com.paterva.maltego.ui.graph.view2d.LinkEdgeRealizer;
import com.paterva.maltego.ui.graph.view2d.VisiblePruner;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainterSettings;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainterSettingsEvent;
import com.paterva.maltego.util.SmartExceptionFilterLogger;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import y.base.DataProvider;
import y.base.Node;
import y.view.DefaultGraph2DRenderer;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.Graph2DView;
import y.view.LineType;
import y.view.NodeCellRendererPainter;
import y.view.NodeRealizer;

public class MaltegoGraph2DRenderer
extends DefaultGraph2DRenderer {
    private static final Logger LOG = Logger.getLogger(MaltegoGraph2DRenderer.class.getName());
    private static final int NON_SLOPPY_DRAG_CUTOFF_LIMIT = 30;
    private static final int NON_SLOPPY_STATIC_CUTOFF_LIMIT = 300;
    private final Graph2DView _view;
    private final Object GRAPH_ID_LOCK = new Object();
    private final boolean _pruneVisible;
    private GraphID _graphID;
    private EntityNodePainter _entityPainter;
    private EntityNodeCellRenderer _entityNodeCellRenderer;
    private NodeCellRendererPainter _nodePainter;
    private Rectangle2D _previousVisibleRect2D;
    private Rectangle2D _visibleRect2D;
    private long _paintStartTime;
    private int _linkPaintedNormal = 0;
    private int _linkPaintedFast = 0;
    private int _linkPaintedSloppy = 0;
    private boolean _paintDetailed = false;
    private final Timer _detailedPaintTimer;
    private final boolean _paintAnimations;
    private boolean _firstPaint = false;
    private VisiblePruner _visiblePruner;
    private boolean _optimizationsEnabled;

    public MaltegoGraph2DRenderer(Graph2DView view, boolean paintAnimations) {
        this._pruneVisible = paintAnimations;
        this._view = view;
        this._paintAnimations = paintAnimations;
        this._detailedPaintTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MaltegoGraph2DRenderer.this._paintDetailed = true;
                MaltegoGraph2DRenderer.this._view.repaint();
            }
        });
        this._detailedPaintTimer.setRepeats(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGraphID(final GraphID graphID) {
        final EntityRealizerInflater inflater = EntityRealizerInflaterRegistry.getDefault().getOrCreateInflater(graphID);
        this._entityPainter = new EntityNodePainter(graphID, inflater, this._paintAnimations);
        this._entityNodeCellRenderer = new EntityNodeCellRenderer(graphID, inflater);
        this._nodePainter = new NodeCellRendererPainter(this._entityNodeCellRenderer, (DataProvider)new EmptyNodeMap()){

            protected void paintHotSpots(NodeRealizer context, Graphics2D g2D) {
            }
        };
        final PropertyChangeListener painterSettingsListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EntityPainterSettingsEvent event = (EntityPainterSettingsEvent)evt.getNewValue();
                if (graphID.equals((Object)event.getGraphID())) {
                    inflater.deflateAll();
                    MaltegoGraph2DRenderer.this._view.updateView();
                }
            }
        };
        EntityPainterSettings.getDefault().addPropertyChangeListener(painterSettingsListener);
        GraphLifeCycleManager.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GraphID closedGraphID;
                if ("graphClosing".equals(evt.getPropertyName()) && (closedGraphID = (GraphID)evt.getNewValue()).equals((Object)graphID)) {
                    EntityPainterSettings.getDefault().removePropertyChangeListener(painterSettingsListener);
                    GraphLifeCycleManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
        });
        this._visiblePruner = new VisiblePruner(graphID, this, this._view);
        this._firstPaint = true;
        Object object = this.GRAPH_ID_LOCK;
        synchronized (object) {
            this._graphID = graphID;
        }
    }

    public void paintSloppy(Graphics2D gfx, Graph2D graph) {
        if (!this.isGraphSetAndOpen()) {
            return;
        }
        try {
            this._optimizationsEnabled = this.isOptimizationsEnabled();
            this._visibleRect2D = this._view.getVisibleRect2D();
            this.calculateVisible(graph);
            this._paintStartTime = System.currentTimeMillis();
            ArrayList<EdgeRealizer> edgesToPaint = new ArrayList<EdgeRealizer>(this._visiblePruner.getVisibleEdges());
            ArrayList<NodeRealizer> nodesToPaint = new ArrayList<NodeRealizer>(this._visiblePruner.getVisibleNodes());
            LinkEdgeRealizer.onPaintStart(edgesToPaint, false);
            this._entityPainter.onPaintStart(nodesToPaint, edgesToPaint);
            if (!this._optimizationsEnabled) {
                super.paintSloppy(gfx, graph);
            } else {
                for (EdgeRealizer edgeRealizer : edgesToPaint) {
                    this.paintSloppy(gfx, edgeRealizer);
                }
                for (NodeRealizer nodeRealizer : nodesToPaint) {
                    this.paintSloppy(gfx, nodeRealizer);
                }
            }
            this._entityPainter.onPaintEnd();
            int paintTime = (int)(System.currentTimeMillis() - this._paintStartTime);
            LOG.log(Level.FINE, "Paint time: {0}ms", paintTime);
            LOG.log(Level.FINEST, "{0}/{1} edges painted", new Object[]{edgesToPaint.size(), graph.E()});
            LOG.log(Level.FINEST, "{0}/{1} nodes painted", new Object[]{nodesToPaint.size(), graph.N()});
            this._previousVisibleRect2D = this._visibleRect2D;
            this._visiblePruner.adjustPaintMax(paintTime);
        }
        catch (Exception ex) {
            SmartExceptionFilterLogger.getDefault().log(((Object)((Object)this)).getClass(), ex);
        }
        this.checkFirstPaint();
    }

    public void paint(Graphics2D g2D, Graph2D graph) {
        if (!this.isGraphSetAndOpen()) {
            return;
        }
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
            if (!graphStore.isOpen()) {
                return;
            }
            this._optimizationsEnabled = this.isOptimizationsEnabled();
            this._visibleRect2D = this._view.getVisibleRect2D();
            this.calculateVisible(graph);
            this._detailedPaintTimer.stop();
            this._linkPaintedNormal = 0;
            this._linkPaintedFast = 0;
            this._linkPaintedSloppy = 0;
            this._paintStartTime = System.currentTimeMillis();
            ArrayList<EdgeRealizer> visibleEdges = new ArrayList<EdgeRealizer>(this._visiblePruner.getVisibleEdges());
            ArrayList<NodeRealizer> visibleNodes = new ArrayList<NodeRealizer>(this._visiblePruner.getVisibleNodes());
            LinkEdgeRealizer.onPaintStart(visibleEdges, true);
            this._entityPainter.onPaintStart(visibleNodes, visibleEdges);
            if (!this._optimizationsEnabled) {
                super.paint(g2D, graph);
            } else {
                for (EdgeRealizer edgeRealizer : visibleEdges) {
                    this.paint(g2D, edgeRealizer);
                }
                for (NodeRealizer nodeRealizer : visibleNodes) {
                    this.paint(g2D, nodeRealizer);
                }
            }
            this._entityPainter.onPaintEnd();
            int paintTime = (int)(System.currentTimeMillis() - this._paintStartTime);
            LOG.log(Level.FINE, "Paint time: {0}ms", paintTime);
            LOG.log(Level.FINE, "Links painted normal: {0} fast: {1} sloppy: {2}", new Object[]{this._linkPaintedNormal, this._linkPaintedFast, this._linkPaintedSloppy});
            if (!this._paintDetailed && this._linkPaintedFast > 0) {
                this._detailedPaintTimer.setInitialDelay(paintTime * 10);
                this._detailedPaintTimer.restart();
            }
            this._paintDetailed = false;
            this._previousVisibleRect2D = this._visibleRect2D;
            this._visiblePruner.adjustPaintMax(paintTime);
        }
        catch (Exception ex) {
            SmartExceptionFilterLogger.getDefault().log(((Object)((Object)this)).getClass(), ex);
        }
        this.checkFirstPaint();
    }

    private void checkFirstPaint() {
        if (this._firstPaint && this._view.isVisible()) {
            LOG.log(Level.FINE, "First paint {0}", this._graphID);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GraphLifeCycleManager.getDefault().fireGraphShowing(MaltegoGraph2DRenderer.this._graphID);
                }
            });
            this._firstPaint = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGraphSetAndOpen() {
        boolean graphSetAndOpen = false;
        Object object = this.GRAPH_ID_LOCK;
        synchronized (object) {
            try {
                graphSetAndOpen = this._graphID != null && GraphStoreRegistry.getDefault().isExistingAndOpen(this._graphID);
            }
            catch (GraphStoreException ex) {
                SmartExceptionFilterLogger.getDefault().log(((Object)((Object)this)).getClass(), (Exception)((Object)ex));
            }
        }
        return graphSetAndOpen;
    }

    protected void paint(Graphics2D g2D, EdgeRealizer er) {
        try {
            if (!this._optimizationsEnabled) {
                super.paint(g2D, er);
                return;
            }
            LinkEdgeRealizer realizer = (LinkEdgeRealizer)er;
            long timeDiff = System.currentTimeMillis() - this._paintStartTime;
            boolean isSameVisibleRect = this.isSame(this._visibleRect2D, this._previousVisibleRect2D);
            boolean paintFast = !this._paintDetailed && (!isSameVisibleRect && timeDiff > 30L || isSameVisibleRect && timeDiff > 300L);
            NodeRealizer targetRealizer = er.getTargetRealizer();
            NodeRealizer sourceRealizer = er.getSourceRealizer();
            if (this.viewContains(targetRealizer) || this.viewContains(sourceRealizer)) {
                realizer.beforePaint();
                LineType lineType = er.getLineType();
                if (paintFast) {
                    er.setLineType(LineType.getLineType((int)((int)lineType.getLineWidth()), (byte)0));
                    ++this._linkPaintedFast;
                } else {
                    ++this._linkPaintedNormal;
                }
                super.paint(g2D, er);
                if (paintFast) {
                    er.setLineType(lineType);
                }
            } else {
                ++this._linkPaintedSloppy;
                this.paintSloppy(g2D, er);
            }
        }
        catch (Exception ex) {
            SmartExceptionFilterLogger.getDefault().log(((Object)((Object)this)).getClass(), ex);
        }
    }

    protected void paint(Graphics2D g2D, NodeRealizer nr) {
        try {
            this._entityPainter.paint(nr, g2D);
            if (this._optimizationsEnabled && CollectionNodeUtils.isCollectionNode(nr) && CollectionNodeUtils.isShowComponents(this._view) && !this.isEditing(nr) && this._entityPainter.isCollectionNodeEditorEnabled()) {
                this._nodePainter.paint(nr, g2D);
            }
        }
        catch (Exception ex) {
            SmartExceptionFilterLogger.getDefault().log(((Object)((Object)this)).getClass(), ex);
        }
    }

    boolean intersectsRegion(EdgeRealizer er, Rectangle2D region) {
        return super.intersects(er, region);
    }

    boolean intersectsRegion(NodeRealizer nr, Rectangle2D region) {
        return super.intersects(nr, region);
    }

    protected void paintSloppy(Graphics2D gfx, EdgeRealizer er) {
        try {
            super.paintSloppy(gfx, er);
        }
        catch (Exception ex) {
            SmartExceptionFilterLogger.getDefault().log(((Object)((Object)this)).getClass(), ex);
        }
    }

    protected void paintSloppy(Graphics2D g2D, NodeRealizer nr) {
        try {
            this._entityPainter.paintSloppy(nr, g2D);
        }
        catch (Exception ex) {
            SmartExceptionFilterLogger.getDefault().log(((Object)((Object)this)).getClass(), ex);
        }
    }

    public boolean isPruneVisible() {
        return this._pruneVisible;
    }

    private boolean viewContains(NodeRealizer nodeRealizer) {
        double coordXMin = nodeRealizer.getX();
        double coordYMin = nodeRealizer.getY();
        double coordXMax = coordXMin + nodeRealizer.getWidth();
        double coordYMax = coordYMin + nodeRealizer.getHeight();
        return this._visibleRect2D.contains(coordXMin, coordYMax) || this._visibleRect2D.contains(coordXMin, coordYMin) || this._visibleRect2D.contains(coordXMax, coordYMax) || this._visibleRect2D.contains(coordXMax, coordYMin);
    }

    private boolean isSame(Rectangle2D left, Rectangle2D right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return this.isClose(left.getMinX(), right.getMinX()) && this.isClose(left.getMaxX(), right.getMaxX()) && this.isClose(left.getMinY(), right.getMinY()) && this.isClose(left.getMaxY(), right.getMaxY());
    }

    private boolean isClose(double left, double right) {
        return Math.abs(left - right) < 1.0E-6;
    }

    private boolean isEditing(NodeRealizer nr) {
        Node node = nr.getNode();
        return node.getGraph().getDataProvider((Object)"IS_EDITING_DPKEY").getBool((Object)node);
    }

    public boolean isOptimizationsEnabled() {
        return this._entityPainter.isOptimizationsEnabled();
    }

    private void calculateVisible(Graph2D graph) {
        this._visiblePruner.calculateVisibleNodes(graph, this._visibleRect2D);
        this._visiblePruner.calculateVisibleEdges(graph, this._visibleRect2D);
    }
}

