/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.view.GraphModelViewMappings;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.view2d.HitInfoCache;
import com.paterva.maltego.ui.graph.view2d.LinkEdgeRealizer;
import com.paterva.maltego.ui.graph.view2d.LinkPresenter;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.UIManager;
import org.openide.util.Exceptions;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.Graph;
import y.base.GraphEvent;
import y.base.GraphListener;
import y.base.Node;
import y.base.NodeCursor;
import y.view.EdgeLabel;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.Graph2DSelectionListener;
import y.view.HitInfo;
import y.view.LineType;
import y.view.NodeRealizer;
import y.view.Selections;
import y.view.ViewMode;

public class LinkHighlighter
extends ViewMode {
    private Node _lastHoveredNode;
    private final LineType _highlightType = LineType.LINE_2;
    private NodeCursor _lastSelection;
    private final MyListener _selectionListener = new MyListener();
    private static final int MAX_NODES = 50;
    private Rectangle2D _dirtyArea = null;

    private Color getHighlightColorChild() {
        return UIManager.getLookAndFeelDefaults().getColor("graph-link-highlight-child-color");
    }

    private Color getHighlightColorParent() {
        return UIManager.getLookAndFeelDefaults().getColor("graph-link-highlight-parent-color");
    }

    private boolean highlightOnHover() {
        return true;
    }

    private boolean highlightOnSelect() {
        return true;
    }

    private boolean highlightOnHover(Node node) {
        if (this._lastSelection == null) {
            return true;
        }
        return !this.highlightOnSelect() || this._lastSelection.size() > 50 || !this.view.getGraph2D().isSelected(node);
    }

    protected void setSelectedNodes(NodeCursor selectionCursor) throws GraphStoreException {
        if (this.highlightOnSelect()) {
            NodeCursor nc;
            if (this._lastSelection != null && this._lastSelection.size() <= 50) {
                this._lastSelection.toFirst();
                nc = this._lastSelection;
                while (nc.ok()) {
                    this.markEdges(nc.node().edges(), null, null);
                    nc.next();
                }
            }
            if (selectionCursor != null && selectionCursor.size() <= 50) {
                selectionCursor.toFirst();
                nc = selectionCursor;
                while (nc.ok()) {
                    this.markEdges(nc.node().inEdges(), this.getHighlightColorParent(), this._highlightType);
                    this.markEdges(nc.node().outEdges(), this.getHighlightColorChild(), this._highlightType);
                    nc.next();
                }
            }
            this._lastSelection = selectionCursor;
        }
    }

    protected void setHoveredEdge(Edge edge) {
    }

    protected void setHoveredNode(Node node) {
        try {
            if (this.highlightOnHover() && this._lastHoveredNode != node) {
                if (this._lastHoveredNode != null && this.highlightOnHover(this._lastHoveredNode)) {
                    this.markEdges(this._lastHoveredNode.edges(), null, null);
                    if (this._lastSelection != null && this.highlightOnSelect()) {
                        this.setSelectedNodes(this._lastSelection);
                    }
                }
                if (node != null && this.highlightOnHover(node)) {
                    this.markEdges(node.inEdges(), this.getHighlightColorParent(), this._highlightType);
                    this.markEdges(node.outEdges(), this.getHighlightColorChild(), this._highlightType);
                }
                this._lastHoveredNode = node;
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void markEdges(EdgeCursor cursor, Color color, LineType type) throws GraphStoreException {
        Graph2D graph = this.view.getGraph2D();
        GraphID graphID = GraphIDProvider.forGraph((Graph2D)graph);
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((Graph)graph);
        HashMap<LinkID, Realizers> linkRealizers = new HashMap<LinkID, Realizers>(cursor.size());
        HashMap<LinkID, Realizers> cnLinkRealizers = new HashMap<LinkID, Realizers>(cursor.size());
        cursor.toFirst();
        while (cursor.ok()) {
            Edge edge = cursor.edge();
            LinkID linkID = wrapper.linkID(edge);
            EdgeRealizer er = graph.getRealizer(edge);
            NodeRealizer sr = graph.getRealizer(edge.source());
            NodeRealizer tr = graph.getRealizer(edge.target());
            if (!wrapper.isCollectionNodeLink(linkID)) {
                linkRealizers.put(linkID, new Realizers(er, sr, tr));
            } else {
                cnLinkRealizers.put(linkID, new Realizers(er, sr, tr));
            }
            cursor.next();
        }
        Set linkIDs = linkRealizers.keySet();
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
        linkIDs = structureReader.getExistingLinks(linkIDs);
        Map links = GraphStoreHelper.getLinks((GraphID)graphID, (Collection)linkIDs);
        GraphStoreView gsView = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
        GraphModelViewMappings modelViewMappings = gsView.getModelViewMappings();
        Set cnLinkIDs = cnLinkRealizers.keySet();
        for (LinkID linkID : cnLinkIDs) {
            if (!modelViewMappings.isViewLink(linkID)) continue;
            links.put(linkID, null);
        }
        for (Map.Entry entry : links.entrySet()) {
            Color lineColor;
            LineType lineType;
            LinkID linkID = (LinkID)entry.getKey();
            MaltegoLink link = (MaltegoLink)entry.getValue();
            Realizers realizers = (Realizers)linkRealizers.get(linkID);
            if (realizers == null) {
                realizers = (Realizers)cnLinkRealizers.get(linkID);
            }
            EdgeRealizer er = realizers.getEdgeRealizer();
            LinkPresenter linkPresenter = LinkPresenter.getDefault();
            if (link == null) {
                lineType = type != null ? type : LinkEdgeRealizer.DEFAULT_LINE_TYPE;
                lineColor = color != null ? color : LinkEdgeRealizer.DEFAULT_MANUAL_LINK_COLOR;
            } else {
                lineType = type != null ? type : LineType.getLineType((int)linkPresenter.getThickness(link), (byte)((byte)linkPresenter.getStyle(link)));
                lineColor = color != null ? color : linkPresenter.getColor(link);
            }
            er.setLineColor(lineColor);
            er.setLineType(lineType);
            EdgeLabel label = er.getLabel();
            if (label != null) {
                label.setTextColor(lineColor);
            }
            NodeRealizer sr = realizers.getSourceRealizer();
            NodeRealizer tr = realizers.getTargetRealizer();
            this.addDirtyArea(new Rectangle2D.Double(sr.getX() - 1.0, sr.getY() - 1.0, sr.getWidth() + 2.0, sr.getHeight() + 2.0));
            this.addDirtyArea(new Rectangle2D.Double(tr.getX() - 1.0, tr.getY() - 1.0, tr.getWidth() + 2.0, tr.getHeight() + 2.0));
        }
    }

    public void mouseMoved(double x, double y) {
        super.mouseMoved(x, y);
        HitInfo info = this.getHitInfo(x, y);
        if (info != null) {
            if (info.hasHitNodes()) {
                this.setHoveredNode(info.getHitNode());
            } else if (info.hasHitEdges()) {
                this.setHoveredEdge(info.getHitEdge());
            } else {
                this.setHoveredEdge(null);
                this.setHoveredNode(null);
            }
        } else {
            this.setHoveredEdge(null);
            this.setHoveredNode(null);
        }
        this.repaint();
    }

    public void disconnect(Graph2D graph) {
        graph.removeGraph2DSelectionListener((Graph2DSelectionListener)this._selectionListener);
        graph.removeGraphListener((GraphListener)this._selectionListener);
    }

    public void connect(Graph2D graph) {
        graph.addGraph2DSelectionListener((Graph2DSelectionListener)this._selectionListener);
        graph.addGraphListener((GraphListener)this._selectionListener);
    }

    private void repaint() {
        if (this._dirtyArea != null) {
            this.view.updateView(this._dirtyArea);
            this._dirtyArea = null;
        }
    }

    private void addDirtyArea(Rectangle2D area) {
        if (this._dirtyArea == null) {
            this._dirtyArea = area.getBounds2D();
        } else {
            this._dirtyArea.add(area);
        }
    }

    protected HitInfo getHitInfo(double x, double y) {
        return HitInfoCache.getDefault().getStandardHitInfo(this.view, x, y);
    }

    private static class Realizers {
        private final EdgeRealizer _edgeRealizer;
        private final NodeRealizer _sourceRealizer;
        private final NodeRealizer _targetRealizer;

        public Realizers(EdgeRealizer edgeRealizer, NodeRealizer sourceRealizer, NodeRealizer targetRealizer) {
            this._edgeRealizer = edgeRealizer;
            this._sourceRealizer = sourceRealizer;
            this._targetRealizer = targetRealizer;
        }

        public EdgeRealizer getEdgeRealizer() {
            return this._edgeRealizer;
        }

        public NodeRealizer getSourceRealizer() {
            return this._sourceRealizer;
        }

        public NodeRealizer getTargetRealizer() {
            return this._targetRealizer;
        }
    }

    private class MyListener
    extends Selections.SelectionStateObserver {
        private int _eventDepth = 0;
        private boolean _inDeleteTransaction = false;

        private MyListener() {
        }

        protected void updateSelectionState(Graph2D graph) {
            if (!this._inDeleteTransaction) {
                this.smartUpdateSelectionState(graph);
            }
        }

        public void onGraphEvent(GraphEvent ge) {
            this.handle(ge);
            super.onGraphEvent(ge);
        }

        private void handle(GraphEvent evt) {
            switch (evt.getType()) {
                case 5: {
                    if (this._eventDepth <= 0) break;
                    this._inDeleteTransaction = true;
                    break;
                }
                case 3: {
                    if (this._eventDepth <= 0) break;
                    this._inDeleteTransaction = true;
                    break;
                }
                case 12: {
                    ++this._eventDepth;
                    break;
                }
                case 13: {
                    --this._eventDepth;
                    if (this._eventDepth > 0 || !this._inDeleteTransaction) break;
                    this._eventDepth = 0;
                    this._inDeleteTransaction = false;
                    this.updateSelectionState((Graph2D)evt.getGraph());
                }
            }
        }

        protected void smartUpdateSelectionState(Graph2D graph) {
            try {
                LinkHighlighter.this.setSelectedNodes(graph.selectedNodes());
                LinkHighlighter.this.repaint();
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

