/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.GraphPart;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.transform.api.TransformMessage;
import com.paterva.maltego.transform.runner.api.TransformMessageCache;
import com.paterva.maltego.ui.graph.EntityColorFactory;
import com.paterva.maltego.ui.graph.HoverContext;
import com.paterva.maltego.ui.graph.view2d.GraphViewOptions;
import com.paterva.maltego.util.ui.fonts.FontFallbackStringPainter;
import com.paterva.maltego.util.ui.fonts.FontUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openide.util.Exceptions;
import y.base.Graph;
import y.view.DefaultBackgroundRenderer;
import y.view.Graph2D;
import y.view.Graph2DView;

public class LegendBackgroundRenderer
extends DefaultBackgroundRenderer {
    private static final Logger LOG = Logger.getLogger(LegendBackgroundRenderer.class.getName());
    public static final int POSITION_NE = 0;
    public static final int POSITION_SE = 1;
    public static final int POSITION_NW = 2;
    public static final int POSITION_SW = 3;
    private static final int MARGIN_X = 15;
    private static final int MARGIN_Y = 15;
    private final GraphID _graphID;
    private Legend _legend = new Legend();
    private boolean _needsReCalc = true;
    private int _position = 0;
    private MyListener _graphListener = new MyListener();
    private GraphStore _graphStore;
    private PropertyChangeListener _backgroundListener;

    public LegendBackgroundRenderer(GraphID graphID, Graph2DView view) {
        super(view);
        this._graphID = graphID;
    }

    public void setNeedsRecalc() {
        this._needsReCalc = true;
    }

    public Font getFont() {
        return this._legend.getFont();
    }

    public void setFont(Font font) {
        this._legend.setFont(font);
    }

    public void setLegendTextColor(Color textColor) {
        this._legend.setTextColor(textColor);
    }

    public Color getLegendTextColor() {
        return this._legend.getTextColor();
    }

    public int getLegendPosition() {
        return this._position;
    }

    public void setLegendPosition(int position) {
        this._position = position;
    }

    private void recalcLegend() throws GraphStoreException {
        Graph2D graph2D = this.getView().getGraph2D();
        EntityRegistry registry = EntityRegistry.forGraph((Graph)this.view.getGraph2D());
        GraphID graphID = GraphIDProvider.forGraph((Graph2D)graph2D);
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
        HashMap<String, String> types = new HashMap<String, String>();
        Iterator<Object> iterator = dataReader.getEntityTypes().iterator();
        while (iterator.hasNext()) {
            String string;
            String typeName = string = (String)iterator.next();
            MaltegoEntitySpec spec = (MaltegoEntitySpec)registry.get(string);
            if (spec != null) {
                typeName = spec.getDisplayName();
            }
            types.put(string, typeName);
        }
        this._legend.clear();
        for (Map.Entry entry : types.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key == null || value == null) continue;
            LOG.log(Level.FINE, "{0}->{1}", new Object[]{key, value});
            this._legend.add(key, value);
        }
        this._needsReCalc = false;
    }

    public void paint(Graphics2D g2D, int x, int y, int width, int height) {
        super.paint(g2D, x, y, width, height);
        double zoom = this.view.getZoom();
        if (zoom <= this.view.getPaintDetailThreshold()) {
            if (this._needsReCalc) {
                try {
                    this.recalcLegend();
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            Rectangle rect = new Rectangle(this._legend.getRectangle(g2D));
            Point p = this.calcLocation(rect);
            rect.translate(p.x, p.y);
            if (this._legend.needsRepainting() || rect.intersects(this.toWorldRect(x, y, width, height))) {
                this.undoWorldTransform(g2D);
                this._legend.paint(g2D, p.x, p.y);
                this.redoWorldTransform(g2D);
            }
        }
        this.undoWorldTransform(g2D);
        int zoomPercent = (int)(zoom * 100.0);
        this.paintZoom(g2D, zoomPercent);
        this.redoWorldTransform(g2D);
    }

    private void paintZoom(Graphics2D g2D, int zoomPercent) {
        String zoomTxt = zoomPercent < 1 ? "<1%" : Integer.toString(zoomPercent) + "%";
        g2D.setFont(this.getFont());
        g2D.setColor(Color.LIGHT_GRAY);
        Rectangle2D stringBounds = g2D.getFontMetrics().getStringBounds(zoomTxt, g2D);
        Point p = new Point((int)((double)(this.view.getWidth() - 15) - stringBounds.getWidth()), 15);
        g2D.drawString(zoomTxt, p.x, p.y);
    }

    private void paintMessages(Graphics2D g2D) {
        try {
            GraphEntity graphEntity;
            List<TransformMessage> messages;
            HoverContext hoverContext = HoverContext.forContextID("graph");
            GraphPart<? extends Guid> part = hoverContext.getHoverPart();
            if (part instanceof GraphEntity && (messages = this.getMessages(graphEntity = (GraphEntity)part)) != null) {
                this.paintMessages(g2D, messages);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void paintMessages(Graphics2D g2D, List<TransformMessage> messages) {
        Font font = this.getFont();
        font = font.deriveFont(font.getSize2D() + 2.0f);
        Rectangle2D stringBounds = g2D.getFontMetrics().getStringBounds("X", g2D);
        float yOffset = 15.0f + (float)stringBounds.getMaxY();
        Object antialiasBackup = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (TransformMessage message : messages) {
            TransformMessage.Severity severity = message.getSeverity();
            String text = message.getText();
            Color color = LegendBackgroundRenderer.getColor(severity);
            yOffset = FontFallbackStringPainter.paint((Graphics2D)g2D, (String)text, (Font)font, (Color)color, (float)15.0f, (float)yOffset, (boolean)false);
        }
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasBackup);
    }

    private List<TransformMessage> getMessages(GraphEntity graphEntity) throws GraphStoreException {
        GraphID graphID = graphEntity.getGraphID();
        if (GraphStoreRegistry.getDefault().isExistingAndOpen(graphID)) {
            EntityID entityID = (EntityID)graphEntity.getID();
            TransformMessageCache.GraphMessages graphMsgs = (TransformMessageCache.GraphMessages)TransformMessageCache.getInstance().getMessages().get(graphID);
            if (graphMsgs != null) {
                return (List)graphMsgs.get((Object)entityID);
            }
        }
        return null;
    }

    private Rectangle toWorldRect(int x, int y, int width, int height) {
        int viewX = this.view.toViewCoordX((double)x);
        int viewY = this.view.toViewCoordY((double)y);
        int viewWidth = this.view.toViewCoordX((double)(x + width)) - viewX;
        int viewHeight = this.view.toViewCoordY((double)(y + height)) - viewY;
        return new Rectangle(viewX, viewY, viewWidth, viewHeight);
    }

    private Point calcLocation(Rectangle legendRect) {
        int marginX = 10;
        int marginY = 10;
        switch (this._position) {
            case 0: {
                return new Point((int)((double)this.view.getWidth() - legendRect.getWidth() - (double)marginX), marginY);
            }
            case 2: {
                return new Point(marginX, marginY);
            }
            case 1: {
                return new Point((int)((double)this.view.getWidth() - legendRect.getWidth() - (double)marginX), (int)((double)this.view.getHeight() - legendRect.getHeight() - (double)marginY - 15.0));
            }
            case 3: {
                return new Point(marginX, (int)((double)this.view.getHeight() - legendRect.getHeight() - (double)marginY - 15.0));
            }
        }
        return new Point(marginX, marginY);
    }

    public void addListeners() {
        try {
            LOG.fine("Adding listeners");
            this._graphStore = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
            this._graphStore.getGraphDataStore().addPropertyChangeListener((PropertyChangeListener)this._graphListener);
            this._graphStore.getGraphStructureStore().addPropertyChangeListener((PropertyChangeListener)this._graphListener);
            this._backgroundListener = ignored -> this.setImage(GraphViewOptions.getDefault().getBackground());
            GraphViewOptions.getDefault().addPropertyChangeListener(this._backgroundListener);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void removeListeners() {
        LOG.fine("Removing listeners");
        if (this._graphStore != null) {
            this._graphStore.getGraphDataStore().removePropertyChangeListener((PropertyChangeListener)this._graphListener);
            this._graphStore.getGraphStructureStore().removePropertyChangeListener((PropertyChangeListener)this._graphListener);
        }
        if (this._backgroundListener != null) {
            GraphViewOptions.getDefault().removePropertyChangeListener(this._backgroundListener);
            this._backgroundListener = null;
        }
    }

    public static Color getColor(TransformMessage.Severity severity) {
        switch (severity) {
            case Debug: {
                return Color.lightGray;
            }
            case Info: {
                return Color.darkGray;
            }
            case Warning: {
                return Color.decode("#F7A009");
            }
            case Error: {
                return UIManager.getLookAndFeelDefaults().getColor("7-red");
            }
        }
        return Color.black;
    }

    private static class Legend {
        private Set<LegendEntry> _entries = new HashSet<LegendEntry>();
        private boolean _needsRepainting = true;
        private Rectangle _rect;
        private int _rowHeight = 14;
        private int[] _colX;
        private int _spacingX = 10;
        private int _colorWidth = 12;
        private int _colorHeight = 8;
        private int _spacingY = 0;
        private Color _textColor = Color.GRAY;
        private Font _font = FontUtils.defaultScaled((float)-1.0f);

        public Font getFont() {
            return this._font;
        }

        public void setFont(Font font) {
            this._font = font;
        }

        public void setTextColor(Color textColor) {
            this._textColor = textColor;
        }

        public Color getTextColor() {
            return this._textColor;
        }

        public void add(Object key, String description) {
            if (this._entries.add(new LegendEntry(key, description))) {
                this._needsRepainting = true;
            }
        }

        public void remove(Object key) {
            if (this._entries.remove(new LegendEntry(key))) {
                this._needsRepainting = true;
            }
        }

        public void clear() {
            this._needsRepainting = true;
            this._entries.clear();
        }

        private void calculateRect(Graphics2D g2D) {
            int colCount = 4;
            int[] colWidths = new int[colCount];
            int col = 0;
            int row = 0;
            for (LegendEntry entry : this._entries) {
                if (col >= colCount - 1) {
                    col = 0;
                }
                FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
                Rectangle2D stringBounds = this.getFont().getStringBounds(entry.description, fontRenderContext);
                int stringWidth = (int)stringBounds.getWidth() + 3;
                colWidths[col] = Math.max(colWidths[col], stringWidth + this._colorWidth);
                entry.column = col++;
                entry.row = ++row;
            }
            this._colX = new int[colCount];
            int totalWidth = 0;
            for (int i = 0; i < colCount; ++i) {
                this._colX[i] = totalWidth;
                totalWidth += colWidths[i] + this._spacingX;
            }
            this._rect = new Rectangle(totalWidth, this._rowHeight * (1 + row));
        }

        public void paint(Graphics2D g2D, int x, int y) {
            if (this.needsRepainting()) {
                this.calculateRect(g2D);
            }
            Color prevColor = g2D.getColor();
            for (LegendEntry entry : this._entries) {
                int posX = this._colX[entry.column] + x;
                int posY = entry.row * (this._spacingY + this._rowHeight) + y;
                int colorY = posY + (this._rowHeight - this._colorHeight) / 2;
                g2D.setColor(EntityColorFactory.getDefault().getTypeColor((String)entry.key));
                g2D.fillRect(posX, colorY, this._colorWidth, this._colorHeight);
                g2D.setColor(Color.GRAY);
                g2D.drawRect(posX, colorY, this._colorWidth, this._colorHeight);
                g2D.setFont(this._font);
                g2D.setColor(this._textColor);
                g2D.drawString(entry.description, posX + this._colorWidth + 5, colorY + this._colorHeight);
            }
            this._needsRepainting = false;
            g2D.setColor(prevColor);
        }

        public Rectangle getRectangle(Graphics2D g2D) {
            if (this.needsRepainting()) {
                this.calculateRect(g2D);
            }
            return this._rect;
        }

        public boolean needsRepainting() {
            return this._needsRepainting;
        }

        private class LegendEntry {
            public String description;
            public Object key;
            public int row;
            public int column;

            public LegendEntry(Object key, String description) {
                this.key = key;
                this.description = description;
            }

            private LegendEntry(Object key) {
                this(key, "");
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                LegendEntry other = (LegendEntry)obj;
                return this.key == other.key || this.key != null && this.key.equals(other.key);
            }

            public int hashCode() {
                int hash = 5;
                hash = 53 * hash + (this.key != null ? this.key.hashCode() : 0);
                return hash;
            }
        }
    }

    private class MyListener
    implements PropertyChangeListener {
        private MyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LOG.fine("Recalc legend");
            LegendBackgroundRenderer.this._needsReCalc = true;
            SwingUtilities.invokeLater(() -> LegendBackgroundRenderer.this.view.updateView());
        }
    }
}

