/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.view2d.LabelViewMode;
import com.paterva.maltego.ui.graph.view2d.NodeLabelUtils;
import java.awt.Cursor;
import y.base.Graph;
import y.base.Node;
import y.view.Graph2D;
import y.view.NodeLabel;
import y.view.NodeRealizer;
import y.view.YLabel;

public abstract class LabelHoverViewMode
extends LabelViewMode {
    private NodeLabel _hoveredLabel;
    private int _labelIndex;
    private Node _hoveredNode;

    public LabelHoverViewMode(int labelIndex) {
        this._labelIndex = labelIndex;
    }

    protected abstract boolean showIfEntityNotHovered(GraphID var1, EntityID var2, MaltegoEntity var3);

    public void mouseMoved(double x, double y) {
        Node node;
        super.mouseMoved(x, y);
        NodeLabel label = this.getLabel(this.view, x, y, this._labelIndex);
        if (!LabelHoverViewMode.areEqual(label, this._hoveredLabel)) {
            if (this._hoveredLabel != null) {
                NodeLabelUtils.setHover((YLabel)this._hoveredLabel, false);
                this._hoveredLabel.repaint();
            }
            this._hoveredLabel = label;
            if (this._hoveredLabel != null) {
                NodeLabelUtils.setHover((YLabel)this._hoveredLabel, true);
                this._hoveredLabel.repaint();
            }
        }
        if (this._hoveredLabel != null) {
            this.view.setViewCursor(Cursor.getPredefinedCursor(0));
        }
        if (!LabelHoverViewMode.areEqual(this._hoveredNode, node = this.getNode(this.view, x, y))) {
            this.onHoverChanged(this._hoveredNode, node);
            this._hoveredNode = node;
        }
    }

    protected void onHoverChanged(Node oldNode, Node newNode) {
        NodeLabel nLabel;
        EntityID entityID;
        if (oldNode != null && (entityID = this.getEntityID(oldNode)) != null) {
            MaltegoEntity entity = this.isCollectionNode(entityID) ? null : this.getEntity(entityID);
            NodeLabel nLabel2 = this.getLabel(oldNode);
            if (nLabel2 != null) {
                GraphID graphID = GraphIDProvider.forGraph((Graph2D)nLabel2.getGraph2D());
                nLabel2.setVisible(this.showIfEntityNotHovered(graphID, entityID, entity));
                nLabel2.repaint();
            }
        }
        if (newNode != null && (nLabel = this.getLabel(newNode)) != null) {
            nLabel.setVisible(true);
            nLabel.repaint();
        }
    }

    private boolean isCollectionNode(EntityID entityID) {
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((Graph)this.view.getGraph2D());
        return entityID != null ? wrapper.isCollectionNode(entityID) : false;
    }

    private boolean isCollectionNode(Node node) {
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((Graph)this.view.getGraph2D());
        EntityID entityID = wrapper.entityID(node);
        return entityID != null ? wrapper.isCollectionNode(entityID) : false;
    }

    private EntityID getEntityID(Node node) {
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((Graph)this.view.getGraph2D());
        EntityID entityID = wrapper.entityID(node);
        return entityID;
    }

    private MaltegoEntity getEntity(EntityID entityID) {
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((Graph)this.view.getGraph2D());
        return entityID != null ? wrapper.getEntity(entityID) : null;
    }

    private NodeLabel getLabel(Node node) {
        NodeRealizer realizer = this.view.getGraph2D().getRealizer(node);
        return realizer.labelCount() > this._labelIndex ? realizer.getLabel(this._labelIndex) : null;
    }

    private static boolean areEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 != null) {
            return o1.equals(o2);
        }
        return false;
    }
}

